/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.requests;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.network.ByteBufferSend;
import org.apache.kafka.common.network.MultiSend;
import org.apache.kafka.common.network.Send;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.protocol.types.Struct;
import org.apache.kafka.common.protocol.types.Type;
import org.apache.kafka.common.record.Records;
import org.apache.kafka.common.requests.AbstractResponse;
import org.apache.kafka.common.requests.FetchRequest;
import org.apache.kafka.common.requests.RecordsSend;
import org.apache.kafka.common.requests.RequestHeader;
import org.apache.kafka.common.requests.ResponseHeader;

public class FetchResponse
extends AbstractResponse {
    private static final String RESPONSES_KEY_NAME = "responses";
    private static final String TOPIC_KEY_NAME = "topic";
    private static final String PARTITIONS_KEY_NAME = "partition_responses";
    private static final String PARTITION_HEADER_KEY_NAME = "partition_header";
    private static final String PARTITION_KEY_NAME = "partition";
    private static final String ERROR_CODE_KEY_NAME = "error_code";
    private static final String HIGH_WATERMARK_KEY_NAME = "high_watermark";
    private static final String LAST_STABLE_OFFSET_KEY_NAME = "last_stable_offset";
    private static final String LOG_START_OFFSET_KEY_NAME = "log_start_offset";
    private static final String ABORTED_TRANSACTIONS_KEY_NAME = "aborted_transactions";
    private static final String RECORD_SET_KEY_NAME = "record_set";
    private static final String PRODUCER_ID_KEY_NAME = "producer_id";
    private static final String FIRST_OFFSET_KEY_NAME = "first_offset";
    private static final int DEFAULT_THROTTLE_TIME = 0;
    public static final long INVALID_HIGHWATERMARK = -1L;
    public static final long INVALID_LAST_STABLE_OFFSET = -1L;
    public static final long INVALID_LOG_START_OFFSET = -1L;
    private final LinkedHashMap<TopicPartition, PartitionData> responseData;
    private final int throttleTimeMs;

    public FetchResponse(LinkedHashMap<TopicPartition, PartitionData> responseData, int throttleTimeMs) {
        this.responseData = responseData;
        this.throttleTimeMs = throttleTimeMs;
    }

    public FetchResponse(Struct struct) {
        LinkedHashMap<TopicPartition, PartitionData> responseData = new LinkedHashMap<TopicPartition, PartitionData>();
        for (Object topicResponseObj : struct.getArray(RESPONSES_KEY_NAME)) {
            Struct topicResponse = (Struct)topicResponseObj;
            String topic = topicResponse.getString(TOPIC_KEY_NAME);
            for (Object partitionResponseObj : topicResponse.getArray(PARTITIONS_KEY_NAME)) {
                Object[] abortedTransactionsArray;
                Struct partitionResponse = (Struct)partitionResponseObj;
                Struct partitionResponseHeader = partitionResponse.getStruct(PARTITION_HEADER_KEY_NAME);
                int partition = partitionResponseHeader.getInt(PARTITION_KEY_NAME);
                Errors error = Errors.forCode(partitionResponseHeader.getShort(ERROR_CODE_KEY_NAME));
                long highWatermark = partitionResponseHeader.getLong(HIGH_WATERMARK_KEY_NAME);
                long lastStableOffset = -1L;
                if (partitionResponseHeader.hasField(LAST_STABLE_OFFSET_KEY_NAME)) {
                    lastStableOffset = partitionResponseHeader.getLong(LAST_STABLE_OFFSET_KEY_NAME);
                }
                long logStartOffset = -1L;
                if (partitionResponseHeader.hasField(LOG_START_OFFSET_KEY_NAME)) {
                    logStartOffset = partitionResponseHeader.getLong(LOG_START_OFFSET_KEY_NAME);
                }
                Records records = partitionResponse.getRecords(RECORD_SET_KEY_NAME);
                ArrayList<AbortedTransaction> abortedTransactions = null;
                if (partitionResponseHeader.hasField(ABORTED_TRANSACTIONS_KEY_NAME) && (abortedTransactionsArray = partitionResponseHeader.getArray(ABORTED_TRANSACTIONS_KEY_NAME)) != null) {
                    abortedTransactions = new ArrayList<AbortedTransaction>(abortedTransactionsArray.length);
                    for (Object abortedTransactionObj : abortedTransactionsArray) {
                        Struct abortedTransactionStruct = (Struct)abortedTransactionObj;
                        long producerId = abortedTransactionStruct.getLong(PRODUCER_ID_KEY_NAME);
                        long firstOffset = abortedTransactionStruct.getLong(FIRST_OFFSET_KEY_NAME);
                        abortedTransactions.add(new AbortedTransaction(producerId, firstOffset));
                    }
                }
                PartitionData partitionData = new PartitionData(error, highWatermark, lastStableOffset, logStartOffset, abortedTransactions, records);
                responseData.put(new TopicPartition(topic, partition), partitionData);
            }
        }
        this.responseData = responseData;
        this.throttleTimeMs = struct.hasField("throttle_time_ms") ? struct.getInt("throttle_time_ms") : 0;
    }

    @Override
    public Struct toStruct(short version) {
        return FetchResponse.toStruct(version, this.responseData, this.throttleTimeMs);
    }

    @Override
    public Send toSend(String dest, RequestHeader requestHeader) {
        return this.toSend(this.toStruct(requestHeader.apiVersion()), this.throttleTimeMs, dest, requestHeader);
    }

    public Send toSend(Struct responseStruct, int throttleTimeMs, String dest, RequestHeader requestHeader) {
        Struct responseHeader = new ResponseHeader(requestHeader.correlationId()).toStruct();
        ByteBuffer buffer = ByteBuffer.allocate(responseHeader.sizeOf() + 4);
        buffer.putInt(responseHeader.sizeOf() + responseStruct.sizeOf());
        responseHeader.writeTo(buffer);
        buffer.rewind();
        ArrayList<Send> sends = new ArrayList<Send>();
        sends.add(new ByteBufferSend(dest, buffer));
        FetchResponse.addResponseData(responseStruct, throttleTimeMs, dest, sends);
        return new MultiSend(dest, sends);
    }

    public LinkedHashMap<TopicPartition, PartitionData> responseData() {
        return this.responseData;
    }

    public int throttleTimeMs() {
        return this.throttleTimeMs;
    }

    public static FetchResponse parse(ByteBuffer buffer, short version) {
        return new FetchResponse(ApiKeys.FETCH.responseSchema(version).read(buffer));
    }

    private static void addResponseData(Struct struct, int throttleTimeMs, String dest, List<Send> sends) {
        ByteBuffer buffer;
        Object[] allTopicData = struct.getArray(RESPONSES_KEY_NAME);
        if (struct.hasField("throttle_time_ms")) {
            buffer = ByteBuffer.allocate(8);
            buffer.putInt(throttleTimeMs);
            buffer.putInt(allTopicData.length);
            buffer.rewind();
            sends.add(new ByteBufferSend(dest, buffer));
        } else {
            buffer = ByteBuffer.allocate(4);
            buffer.putInt(allTopicData.length);
            buffer.rewind();
            sends.add(new ByteBufferSend(dest, buffer));
        }
        for (Object topicData : allTopicData) {
            FetchResponse.addTopicData(dest, sends, (Struct)topicData);
        }
    }

    private static void addTopicData(String dest, List<Send> sends, Struct topicData) {
        String topic = topicData.getString(TOPIC_KEY_NAME);
        Object[] allPartitionData = topicData.getArray(PARTITIONS_KEY_NAME);
        ByteBuffer buffer = ByteBuffer.allocate(Type.STRING.sizeOf(topic) + 4);
        Type.STRING.write(buffer, topic);
        buffer.putInt(allPartitionData.length);
        buffer.rewind();
        sends.add(new ByteBufferSend(dest, buffer));
        for (Object partitionData : allPartitionData) {
            FetchResponse.addPartitionData(dest, sends, (Struct)partitionData);
        }
    }

    private static void addPartitionData(String dest, List<Send> sends, Struct partitionData) {
        Struct header = partitionData.getStruct(PARTITION_HEADER_KEY_NAME);
        Records records = partitionData.getRecords(RECORD_SET_KEY_NAME);
        ByteBuffer buffer = ByteBuffer.allocate(header.sizeOf() + 4);
        header.writeTo(buffer);
        buffer.putInt(records.sizeInBytes());
        buffer.rewind();
        sends.add(new ByteBufferSend(dest, buffer));
        sends.add(new RecordsSend(dest, records));
    }

    private static Struct toStruct(short version, LinkedHashMap<TopicPartition, PartitionData> responseData, int throttleTime) {
        Struct struct = new Struct(ApiKeys.FETCH.responseSchema(version));
        List<FetchRequest.TopicAndPartitionData<PartitionData>> topicsData = FetchRequest.TopicAndPartitionData.batchByTopic(responseData);
        ArrayList<Struct> topicArray = new ArrayList<Struct>();
        for (FetchRequest.TopicAndPartitionData<PartitionData> topicEntry : topicsData) {
            Struct topicData = struct.instance(RESPONSES_KEY_NAME);
            topicData.set(TOPIC_KEY_NAME, (Object)topicEntry.topic);
            ArrayList<Struct> partitionArray = new ArrayList<Struct>();
            for (Map.Entry partitionEntry : topicEntry.partitions.entrySet()) {
                PartitionData fetchPartitionData = (PartitionData)partitionEntry.getValue();
                Struct partitionData = topicData.instance(PARTITIONS_KEY_NAME);
                Struct partitionDataHeader = partitionData.instance(PARTITION_HEADER_KEY_NAME);
                partitionDataHeader.set(PARTITION_KEY_NAME, (Object)partitionEntry.getKey());
                partitionDataHeader.set(ERROR_CODE_KEY_NAME, (Object)fetchPartitionData.error.code());
                partitionDataHeader.set(HIGH_WATERMARK_KEY_NAME, (Object)fetchPartitionData.highWatermark);
                if (partitionDataHeader.hasField(LAST_STABLE_OFFSET_KEY_NAME)) {
                    partitionDataHeader.set(LAST_STABLE_OFFSET_KEY_NAME, (Object)fetchPartitionData.lastStableOffset);
                    if (fetchPartitionData.abortedTransactions == null) {
                        partitionDataHeader.set(ABORTED_TRANSACTIONS_KEY_NAME, null);
                    } else {
                        ArrayList<Struct> abortedTransactionStructs = new ArrayList<Struct>(fetchPartitionData.abortedTransactions.size());
                        for (AbortedTransaction abortedTransaction : fetchPartitionData.abortedTransactions) {
                            Struct abortedTransactionStruct = partitionDataHeader.instance(ABORTED_TRANSACTIONS_KEY_NAME);
                            abortedTransactionStruct.set(PRODUCER_ID_KEY_NAME, (Object)abortedTransaction.producerId);
                            abortedTransactionStruct.set(FIRST_OFFSET_KEY_NAME, (Object)abortedTransaction.firstOffset);
                            abortedTransactionStructs.add(abortedTransactionStruct);
                        }
                        partitionDataHeader.set(ABORTED_TRANSACTIONS_KEY_NAME, (Object)abortedTransactionStructs.toArray());
                    }
                }
                if (partitionDataHeader.hasField(LOG_START_OFFSET_KEY_NAME)) {
                    partitionDataHeader.set(LOG_START_OFFSET_KEY_NAME, (Object)fetchPartitionData.logStartOffset);
                }
                partitionData.set(PARTITION_HEADER_KEY_NAME, (Object)partitionDataHeader);
                partitionData.set(RECORD_SET_KEY_NAME, (Object)fetchPartitionData.records);
                partitionArray.add(partitionData);
            }
            topicData.set(PARTITIONS_KEY_NAME, (Object)partitionArray.toArray());
            topicArray.add(topicData);
        }
        struct.set(RESPONSES_KEY_NAME, (Object)topicArray.toArray());
        if (struct.hasField("throttle_time_ms")) {
            struct.set("throttle_time_ms", (Object)throttleTime);
        }
        return struct;
    }

    public static int sizeOf(short version, LinkedHashMap<TopicPartition, PartitionData> responseData) {
        return 4 + FetchResponse.toStruct(version, responseData, 0).sizeOf();
    }

    public static final class PartitionData {
        public final Errors error;
        public final long highWatermark;
        public final long lastStableOffset;
        public final long logStartOffset;
        public final List<AbortedTransaction> abortedTransactions;
        public final Records records;

        public PartitionData(Errors error, long highWatermark, long lastStableOffset, long logStartOffset, List<AbortedTransaction> abortedTransactions, Records records) {
            this.error = error;
            this.highWatermark = highWatermark;
            this.lastStableOffset = lastStableOffset;
            this.logStartOffset = logStartOffset;
            this.abortedTransactions = abortedTransactions;
            this.records = records;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            PartitionData that = (PartitionData)o;
            return this.error == that.error && this.highWatermark == that.highWatermark && this.lastStableOffset == that.lastStableOffset && this.logStartOffset == that.logStartOffset && (this.abortedTransactions == null ? that.abortedTransactions == null : this.abortedTransactions.equals(that.abortedTransactions)) && (this.records == null ? that.records == null : this.records.equals(that.records));
        }

        public int hashCode() {
            int result = this.error != null ? this.error.hashCode() : 0;
            result = 31 * result + (int)(this.highWatermark ^ this.highWatermark >>> 32);
            result = 31 * result + (int)(this.lastStableOffset ^ this.lastStableOffset >>> 32);
            result = 31 * result + (int)(this.logStartOffset ^ this.logStartOffset >>> 32);
            result = 31 * result + (this.abortedTransactions != null ? this.abortedTransactions.hashCode() : 0);
            result = 31 * result + (this.records != null ? this.records.hashCode() : 0);
            return result;
        }

        public String toString() {
            return "(error=" + (Object)((Object)this.error) + ", highWaterMark=" + this.highWatermark + ", lastStableOffset = " + this.lastStableOffset + ", logStartOffset = " + this.logStartOffset + ", abortedTransactions = " + this.abortedTransactions + ", recordsSizeInBytes=" + this.records.sizeInBytes() + ")";
        }
    }

    public static final class AbortedTransaction {
        public final long producerId;
        public final long firstOffset;

        public AbortedTransaction(long producerId, long firstOffset) {
            this.producerId = producerId;
            this.firstOffset = firstOffset;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            AbortedTransaction that = (AbortedTransaction)o;
            return this.producerId == that.producerId && this.firstOffset == that.firstOffset;
        }

        public int hashCode() {
            int result = (int)(this.producerId ^ this.producerId >>> 32);
            result = 31 * result + (int)(this.firstOffset ^ this.firstOffset >>> 32);
            return result;
        }

        public String toString() {
            return "(producerId=" + this.producerId + ", firstOffset=" + this.firstOffset + ")";
        }
    }
}

