/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.client.dataframe;

import java.util.Objects;
import java.util.Optional;
import org.elasticsearch.client.Validatable;
import org.elasticsearch.client.ValidationException;
import org.elasticsearch.common.unit.TimeValue;

public class StartDataFrameTransformRequest
implements Validatable {
    private final String id;
    private TimeValue timeout;

    public StartDataFrameTransformRequest(String id) {
        this.id = id;
    }

    public StartDataFrameTransformRequest(String id, TimeValue timeout) {
        this.id = id;
        this.timeout = timeout;
    }

    public String getId() {
        return this.id;
    }

    public TimeValue getTimeout() {
        return this.timeout;
    }

    public void setTimeout(TimeValue timeout) {
        this.timeout = timeout;
    }

    @Override
    public Optional<ValidationException> validate() {
        if (this.id == null) {
            ValidationException validationException = new ValidationException();
            validationException.addValidationError("data frame transform id must not be null");
            return Optional.of(validationException);
        }
        return Optional.empty();
    }

    public int hashCode() {
        return Objects.hash(this.id, this.timeout);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        StartDataFrameTransformRequest other = (StartDataFrameTransformRequest)obj;
        return Objects.equals(this.id, other.id) && Objects.equals(this.timeout, other.timeout);
    }
}

