/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.config;

import com.hazelcast.client.config.AbstractQueryCacheConfigBuilderHelper;
import com.hazelcast.client.config.ClientConfig;
import com.hazelcast.config.DomConfigHelper;
import com.hazelcast.config.EntryListenerConfig;
import com.hazelcast.config.InvalidConfigurationException;
import com.hazelcast.config.MapIndexConfig;
import com.hazelcast.config.PredicateConfig;
import com.hazelcast.config.QueryCacheConfig;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

final class QueryCacheYamlConfigBuilderHelper
extends AbstractQueryCacheConfigBuilderHelper {
    QueryCacheYamlConfigBuilderHelper() {
        super(true);
    }

    @Override
    public void handleQueryCache(ClientConfig clientConfig, Node node) {
        for (Node queryCacheNode : DomConfigHelper.childElements(node)) {
            this.handleQueryCacheNode(clientConfig, queryCacheNode);
        }
    }

    @Override
    protected String getCacheName(Node queryCacheNode) {
        return queryCacheNode.getNodeName();
    }

    @Override
    protected String getCacheMapName(NamedNodeMap attrs) {
        return this.getTextContent(attrs.getNamedItem("map-name"));
    }

    @Override
    protected void handleEntryListeners(QueryCacheConfig queryCacheConfig, Node childNode) {
        for (Node listenerNode : DomConfigHelper.childElements(childNode)) {
            NamedNodeMap attrs = listenerNode.getAttributes();
            boolean incValue = DomConfigHelper.getBooleanValue(this.getTextContent(attrs.getNamedItem("include-value")));
            boolean local = DomConfigHelper.getBooleanValue(this.getTextContent(attrs.getNamedItem("local")));
            String listenerClass = this.getTextContent(attrs.getNamedItem("class-name"));
            queryCacheConfig.addEntryListenerConfig(new EntryListenerConfig(listenerClass, local, incValue));
        }
    }

    @Override
    protected void queryCachePredicateHandler(Node childNode, QueryCacheConfig queryCacheConfig) {
        NamedNodeMap predicateAttributes = childNode.getAttributes();
        Node classNameNode = predicateAttributes.getNamedItem("class-name");
        Node sqlNode = predicateAttributes.getNamedItem("sql");
        if (classNameNode != null && sqlNode != null) {
            throw new InvalidConfigurationException("Both class-name and sql is defined for the predicate of map " + childNode.getParentNode().getParentNode().getNodeName());
        }
        if (classNameNode == null && sqlNode == null) {
            throw new InvalidConfigurationException("Either class-name and sql should be defined for the predicate of map " + childNode.getParentNode().getParentNode().getNodeName());
        }
        PredicateConfig predicateConfig = new PredicateConfig();
        if (classNameNode != null) {
            predicateConfig.setClassName(this.getTextContent(classNameNode));
        } else if (sqlNode != null) {
            predicateConfig.setSql(this.getTextContent(sqlNode));
        }
        queryCacheConfig.setPredicateConfig(predicateConfig);
    }

    @Override
    protected void queryCacheIndexesHandle(Node childNode, QueryCacheConfig queryCacheConfig) {
        for (Node indexNode : DomConfigHelper.childElements(childNode)) {
            this.handleIndexNode(queryCacheConfig, indexNode);
        }
    }

    @Override
    protected void handleIndexNode(QueryCacheConfig queryCacheConfig, Node indexNode) {
        NamedNodeMap attrs = indexNode.getAttributes();
        boolean ordered = DomConfigHelper.getBooleanValue(this.getTextContent(attrs.getNamedItem("ordered")));
        String attribute = indexNode.getNodeName();
        queryCacheConfig.addIndexConfig(new MapIndexConfig(attribute, ordered));
    }
}

