/*
 * Decompiled with CFR 0.152.
 */
package org.apache.unomi.persistence.elasticsearch.querybuilders.core;

import co.elastic.clients.elasticsearch._types.query_dsl.BoolQuery;
import co.elastic.clients.elasticsearch._types.query_dsl.Query;
import java.util.List;
import java.util.Map;
import org.apache.unomi.api.conditions.Condition;
import org.apache.unomi.persistence.elasticsearch.ConditionESQueryBuilder;
import org.apache.unomi.persistence.elasticsearch.ConditionESQueryBuilderDispatcher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BooleanConditionESQueryBuilder
implements ConditionESQueryBuilder {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)BooleanConditionESQueryBuilder.class.getName());

    @Override
    public Query buildQuery(Condition condition, Map<String, Object> context, ConditionESQueryBuilderDispatcher dispatcher) {
        boolean isAndOperator = "and".equalsIgnoreCase((String)condition.getParameter("operator"));
        List conditions = (List)condition.getParameter("subConditions");
        int conditionCount = conditions.size();
        if (conditionCount == 1) {
            return dispatcher.buildFilter((Condition)conditions.get(0), context);
        }
        BoolQuery.Builder boolQueryBuilder = new BoolQuery.Builder();
        for (int i = 0; i < conditionCount; ++i) {
            if (isAndOperator) {
                Query andFilter = dispatcher.buildFilter((Condition)conditions.get(i), context);
                if (andFilter != null) {
                    if (andFilter.isRange()) {
                        boolQueryBuilder.filter(andFilter, new Query[0]);
                        continue;
                    }
                    boolQueryBuilder.must(andFilter, new Query[0]);
                    continue;
                }
                LOGGER.warn("Null filter for boolean AND sub condition. See debug log level for more information");
                if (!LOGGER.isDebugEnabled()) continue;
                LOGGER.debug("Null filter for boolean AND sub condition {}", conditions.get(i));
                continue;
            }
            Query orFilter = dispatcher.buildFilter((Condition)conditions.get(i), context);
            if (orFilter != null) {
                boolQueryBuilder.should(orFilter, new Query[0]);
                continue;
            }
            LOGGER.warn("Null filter for boolean OR sub condition. See debug log level for more information");
            if (!LOGGER.isDebugEnabled()) continue;
            LOGGER.debug("Null filter for boolean OR sub condition {}", conditions.get(i));
        }
        return Query.of(q -> q.bool(boolQueryBuilder.build()));
    }
}

