/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common;

import java.util.Collections;
import java.util.List;
import org.apache.kafka.common.Node;
import org.apache.kafka.common.utils.Utils;

public class TopicPartitionInfo {
    private final int partition;
    private final Node leader;
    private final List<Node> replicas;
    private final List<Node> isr;

    public TopicPartitionInfo(int partition, Node leader, List<Node> replicas, List<Node> isr) {
        this.partition = partition;
        this.leader = leader;
        this.replicas = Collections.unmodifiableList(replicas);
        this.isr = Collections.unmodifiableList(isr);
    }

    public int partition() {
        return this.partition;
    }

    public Node leader() {
        return this.leader;
    }

    public List<Node> replicas() {
        return this.replicas;
    }

    public List<Node> isr() {
        return this.isr;
    }

    public String toString() {
        return "(partition=" + this.partition + ", leader=" + this.leader + ", replicas=" + Utils.join(this.replicas, ", ") + ", isr=" + Utils.join(this.isr, ", ") + ")";
    }
}

