/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.markup;

import org.apache.wicket.Component;
import org.apache.wicket.markup.ComponentTag;
import org.apache.wicket.markup.IMarkupFragment;
import org.apache.wicket.markup.MarkupElement;
import org.apache.wicket.markup.MarkupException;
import org.apache.wicket.markup.MarkupFragment;
import org.apache.wicket.markup.MergedMarkup;
import org.apache.wicket.markup.RawMarkup;
import org.apache.wicket.markup.WicketTag;
import org.apache.wicket.util.lang.Args;
import org.apache.wicket.util.resource.IResourceStream;
import org.apache.wicket.util.string.Strings;

public class MarkupStream {
    private MarkupElement current;
    private int currentIndex = 0;
    private final IMarkupFragment markup;

    public MarkupStream(IMarkupFragment markup) {
        Args.notNull((Object)markup, (String)"markup");
        this.markup = markup;
        if (markup.size() > 0) {
            this.current = this.get(this.currentIndex);
        }
    }

    public boolean atCloseTag() {
        return this.atTag() && this.getTag().isClose();
    }

    public boolean atOpenCloseTag() {
        return this.atTag() && this.getTag().isOpenClose();
    }

    public boolean atOpenCloseTag(String componentId) {
        return this.atOpenCloseTag() && componentId.equals(this.getTag().getId());
    }

    public boolean atOpenTag() {
        return this.atTag() && this.getTag().isOpen();
    }

    public boolean atOpenTag(String id) {
        return this.atOpenTag() && id.equals(this.getTag().getId());
    }

    public boolean atTag() {
        return this.current instanceof ComponentTag;
    }

    public boolean equalTo(MarkupStream that) {
        while (this.isCurrentIndexInsideTheStream()) {
            MarkupElement thisElement = this.get();
            MarkupElement thatElement = that.get();
            if (thisElement != null && thatElement != null ? !thisElement.equalTo(thatElement) : thisElement != null || thatElement != null) {
                return false;
            }
            this.next();
            that.next();
        }
        return !that.isCurrentIndexInsideTheStream();
    }

    public final boolean equalMarkup(MarkupStream markupStream) {
        if (markupStream == null) {
            return false;
        }
        return this.markup == markupStream.markup;
    }

    public MarkupElement get() {
        return this.current;
    }

    public MarkupElement get(int index) {
        return this.markup.get(index);
    }

    public final Class<? extends Component> getContainerClass() {
        return this.markup.getMarkupResourceStream().getMarkupClass();
    }

    public int getCurrentIndex() {
        return this.currentIndex;
    }

    public final String getEncoding() {
        return this.markup.getMarkupResourceStream().getEncoding();
    }

    public IResourceStream getResource() {
        return this.markup.getMarkupResourceStream().getResource();
    }

    public ComponentTag getTag() {
        if (this.current instanceof ComponentTag) {
            return (ComponentTag)this.current;
        }
        this.throwMarkupException("Tag expected");
        return null;
    }

    public final String getWicketNamespace() {
        return this.markup.getMarkupResourceStream().getWicketNamespace();
    }

    public boolean isCurrentIndexInsideTheStream() {
        return this.currentIndex < this.markup.size();
    }

    @Deprecated
    public boolean hasMore() {
        return this.currentIndex < this.markup.size();
    }

    public final boolean isMergedMarkup() {
        return this.markup instanceof MergedMarkup;
    }

    public MarkupElement next() {
        if (++this.currentIndex < this.markup.size()) {
            this.current = this.get(this.currentIndex);
            return this.current;
        }
        return null;
    }

    public MarkupElement nextOpenTag() {
        while (this.next() != null) {
            ComponentTag tag;
            MarkupElement elem = this.get();
            if (!(elem instanceof ComponentTag) || !(tag = (ComponentTag)elem).isOpen() && !tag.isOpenClose()) continue;
            this.current = this.get(this.currentIndex);
            return this.current;
        }
        return null;
    }

    public MarkupStream setCurrentIndex(int currentIndex) {
        this.current = this.get(currentIndex);
        this.currentIndex = currentIndex;
        return this;
    }

    public final void skipComponent() {
        ComponentTag startTag = this.getTag();
        if (startTag.isOpen()) {
            if (!startTag.hasNoCloseTag()) {
                this.next();
                this.skipToMatchingCloseTag(startTag);
            }
            this.next();
        } else if (startTag.isOpenClose()) {
            this.next();
        } else {
            this.throwMarkupException("Skip component called on bad markup element " + startTag);
        }
    }

    public void skipRawMarkup() {
        ComponentTag tag;
        while (this.current instanceof RawMarkup ? this.next() != null : this.current instanceof ComponentTag && !(this.current instanceof WicketTag) && ((tag = (ComponentTag)this.current).isAutoComponentTag() ? this.next() != null : tag.isClose() && tag.getOpenTag().isAutoComponentTag() && this.next() != null)) {
        }
    }

    public boolean skipUntil(Class<? extends MarkupElement> clazz) {
        while (this.isCurrentIndexInsideTheStream()) {
            if (clazz.isInstance(this.current)) {
                return true;
            }
            this.next();
        }
        return false;
    }

    public void skipUntil(String wicketTagName) {
        do {
            if (!(this.current instanceof WicketTag) || !((WicketTag)this.current).getName().equals(wicketTagName)) continue;
            return;
        } while (this.next() != null);
    }

    public void skipToMatchingCloseTag(ComponentTag openTag) {
        while (this.isCurrentIndexInsideTheStream()) {
            if (this.get().closes(openTag)) {
                return;
            }
            this.next();
        }
        this.throwMarkupException("Expected close tag for " + openTag);
    }

    public final IMarkupFragment getMarkupFragment() {
        return new MarkupFragment(this.markup, this.currentIndex);
    }

    public final String getTagAttribute(String name, boolean withWicketNamespace) {
        String attr;
        attr = withWicketNamespace ? (attr = this.getWicketNamespace() + ":" + name) : name;
        return this.getTag().getAttributes().getString(attr);
    }

    public final ComponentTag getPreviousTag() {
        MarkupElement elem = this.get(this.currentIndex - 1);
        if (!(elem instanceof ComponentTag)) {
            this.throwMarkupException("Tag expected");
        }
        return (ComponentTag)elem;
    }

    public void throwMarkupException(String message) {
        throw new MarkupException(this, message);
    }

    public String toHtmlDebugString() {
        StringBuilder buffer = new StringBuilder();
        for (int i = 0; i < this.markup.size(); ++i) {
            if (i == this.currentIndex) {
                buffer.append("<font color = \"red\">");
            }
            MarkupElement element = this.markup.get(i);
            buffer.append(Strings.escapeMarkup((CharSequence)element.toString(), (boolean)true).toString());
            if (i != this.currentIndex) continue;
            buffer.append("</font>");
        }
        return buffer.toString();
    }

    public String toString() {
        return "[markup = " + String.valueOf(this.markup) + ", index = " + this.currentIndex + ", current = " + (this.current == null ? "null" : this.current.toUserDebugString()) + "]";
    }
}

