
/*
This Java source file was generated by test-to-java.xsl
and is a derived work from the source document.
The source document contained the following notice:



Copyright (c) 2001-2004 World Wide Web Consortium, 
(Massachusetts Institute of Technology, Institut National de
Recherche en Informatique et en Automatique, Keio University).  All 
Rights Reserved.  This program is distributed under the W3C's Software
Intellectual Property License.  This program is distributed in the 
hope that it will be useful, but WITHOUT ANY WARRANTY; without even
the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  

See W3C License http://www.w3.org/Consortium/Legal/ for more details.


*/

package org.w3c.domts.level3.core;

import org.w3c.dom.*;


import org.w3c.domts.DOMTestCase;
import org.w3c.domts.DOMTestDocumentBuilderFactory;



/**
 *      Invoke setIdAttributeNode on the 2nd and 3rd acronym element using the class attribute as a parameter .  Verify by calling
 *      isID on the attribute node and getElementById on document node.  
 *     
* @author IBM
* @author Jenny Hsu
* @see <a href="http://www.w3.org/TR/2003/CR-DOM-Level-3-Core-20031107/core#ID-ElSetIdAttrNode">http://www.w3.org/TR/2003/CR-DOM-Level-3-Core-20031107/core#ID-ElSetIdAttrNode</a>
*/
public final class elementsetidattributenode07 extends DOMTestCase {

   /**
    * Constructor.
    * @param factory document factory, may not be null
    * @throws org.w3c.domts.DOMTestIncompatibleException Thrown if test is not compatible with parser configuration
    */
   public elementsetidattributenode07(final DOMTestDocumentBuilderFactory factory)  throws org.w3c.domts.DOMTestIncompatibleException {
      super(factory);

    //
    //   check if loaded documents are supported for content type
    //
    String contentType = getContentType();
    preload(contentType, "hc_staff", true);
    }

   /**
    * Runs the test case.
    * @throws Throwable Any uncaught exception causes test to fail
    */
   public void runTest() throws Throwable {
      Document doc;
      NodeList elemList1;
      NodeList elemList2;
      Element acronymElem1;
      Element acronymElem2;
      NamedNodeMap attributesMap;
      Attr attr;
      boolean id = false;
      Element elem;
      String elemName;
      doc = (Document) load("hc_staff", true);
      elemList1 = doc.getElementsByTagName("acronym");
      elemList2 = doc.getElementsByTagName("acronym");
      acronymElem1 = (Element) elemList1.item(1);
      acronymElem2 = (Element) elemList2.item(2);
      attributesMap = acronymElem1.getAttributes();
      attr = (Attr) attributesMap.getNamedItem("class");
      acronymElem1.setIdAttributeNode(attr, true);
      id = attr.isId();
      assertTrue("elementsetidattributenodeIsId1True07", id);
      attributesMap = acronymElem2.getAttributes();
      attr = (Attr) attributesMap.getNamedItem("class");
      acronymElem2.setIdAttributeNode(attr, true);
      id = attr.isId();
      assertTrue("elementsetidattributenodeIsId2True07", id);
      elem = doc.getElementById("No");
      elemName = elem.getTagName();
      assertEquals("elementsetidattributenode1GetElementById07", "acronym", elemName);
      elem = doc.getElementById("Yes");
      elemName = elem.getTagName();
      assertEquals("elementsetidattributenode2GetElementById07", "acronym", elemName);
      }
   /**
    *  Gets URI that identifies the test.
    *  @return uri identifier of test
    */
   public String getTargetURI() {
      return "http://www.w3.org/2001/DOM-Test-Suite/level3/core/elementsetidattributenode07";
   }
   /**
    * Runs this test from the command line.
    * @param args command line arguments
    */
   public static void main(final String[] args) {
        DOMTestCase.doMain(elementsetidattributenode07.class, args);
   }
}

