/*
 * Decompiled with CFR 0.152.
 */
package xni;

import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.util.Enumeration;
import org.apache.xerces.parsers.XMLDocumentParser;
import org.apache.xerces.xni.Augmentations;
import org.apache.xerces.xni.NamespaceContext;
import org.apache.xerces.xni.QName;
import org.apache.xerces.xni.XMLAttributes;
import org.apache.xerces.xni.XMLLocator;
import org.apache.xerces.xni.XMLResourceIdentifier;
import org.apache.xerces.xni.XMLString;
import org.apache.xerces.xni.XNIException;
import org.apache.xerces.xni.parser.XMLConfigurationException;
import org.apache.xerces.xni.parser.XMLErrorHandler;
import org.apache.xerces.xni.parser.XMLInputSource;
import org.apache.xerces.xni.parser.XMLParseException;
import org.apache.xerces.xni.parser.XMLParserConfiguration;
import xni.ObjectFactory;

public class DocumentTracer
extends XMLDocumentParser
implements XMLErrorHandler {
    protected static final String NAMESPACES_FEATURE_ID = "http://xml.org/sax/features/namespaces";
    protected static final String VALIDATION_FEATURE_ID = "http://xml.org/sax/features/validation";
    protected static final String SCHEMA_VALIDATION_FEATURE_ID = "http://apache.org/xml/features/validation/schema";
    protected static final String SCHEMA_FULL_CHECKING_FEATURE_ID = "http://apache.org/xml/features/validation/schema-full-checking";
    protected static final String HONOUR_ALL_SCHEMA_LOCATIONS_ID = "http://apache.org/xml/features/honour-all-schemaLocations";
    protected static final String NOTIFY_CHAR_REFS_FEATURE_ID = "http://apache.org/xml/features/scanner/notify-char-refs";
    protected static final String DEFAULT_PARSER_CONFIG = "org.apache.xerces.parsers.XIncludeAwareParserConfiguration";
    protected static final boolean DEFAULT_NAMESPACES = true;
    protected static final boolean DEFAULT_VALIDATION = false;
    protected static final boolean DEFAULT_SCHEMA_VALIDATION = false;
    protected static final boolean DEFAULT_SCHEMA_FULL_CHECKING = false;
    protected static final boolean DEFAULT_HONOUR_ALL_SCHEMA_LOCATIONS = false;
    protected static final boolean DEFAULT_NOTIFY_CHAR_REFS = false;
    private QName fQName = new QName();
    protected PrintWriter fOut;
    protected int fIndent;
    protected NamespaceContext fNamespaceContext;

    public DocumentTracer() {
        this(null);
    }

    public DocumentTracer(XMLParserConfiguration xMLParserConfiguration) {
        super(xMLParserConfiguration);
        this.setOutput(new PrintWriter(System.out));
        this.fConfiguration.setErrorHandler((XMLErrorHandler)this);
    }

    public void setOutput(OutputStream outputStream, String string) throws UnsupportedEncodingException {
        if (string == null) {
            string = "UTF8";
        }
        OutputStreamWriter outputStreamWriter = new OutputStreamWriter(outputStream, string);
        this.fOut = new PrintWriter(outputStreamWriter);
    }

    public void setOutput(Writer writer) {
        this.fOut = writer instanceof PrintWriter ? (PrintWriter)writer : new PrintWriter(writer);
    }

    public void startDocument(XMLLocator xMLLocator, String string, NamespaceContext namespaceContext, Augmentations augmentations) throws XNIException {
        this.fNamespaceContext = namespaceContext;
        this.fIndent = 0;
        this.printIndent();
        this.fOut.print("startDocument(");
        this.fOut.print("locator=");
        if (xMLLocator == null) {
            this.fOut.print("null");
        } else {
            this.fOut.print('{');
            this.fOut.print("publicId=");
            this.printQuotedString(xMLLocator.getPublicId());
            this.fOut.print(',');
            this.fOut.print("literal systemId=");
            this.printQuotedString(xMLLocator.getLiteralSystemId());
            this.fOut.print(',');
            this.fOut.print("baseSystemId=");
            this.printQuotedString(xMLLocator.getBaseSystemId());
            this.fOut.print(',');
            this.fOut.print("expanded systemId=");
            this.printQuotedString(xMLLocator.getExpandedSystemId());
            this.fOut.print(',');
            this.fOut.print("lineNumber=");
            this.fOut.print(xMLLocator.getLineNumber());
            this.fOut.print(',');
            this.fOut.print("columnNumber=");
            this.fOut.print(xMLLocator.getColumnNumber());
            this.fOut.print('}');
        }
        this.fOut.print(',');
        this.fOut.print("encoding=");
        this.printQuotedString(string);
        if (augmentations != null) {
            this.fOut.print(',');
            this.printAugmentations(augmentations);
        }
        this.fOut.println(')');
        this.fOut.flush();
        ++this.fIndent;
    }

    public void xmlDecl(String string, String string2, String string3, Augmentations augmentations) throws XNIException {
        this.printIndent();
        this.fOut.print("xmlDecl(");
        this.fOut.print("version=");
        this.printQuotedString(string);
        this.fOut.print(',');
        this.fOut.print("encoding=");
        this.printQuotedString(string2);
        this.fOut.print(',');
        this.fOut.print("standalone=");
        this.printQuotedString(string3);
        if (augmentations != null) {
            this.fOut.print(',');
            this.printAugmentations(augmentations);
        }
        this.fOut.println(')');
    }

    public void doctypeDecl(String string, String string2, String string3, Augmentations augmentations) throws XNIException {
        this.printIndent();
        this.fOut.print("doctypeDecl(");
        this.fOut.print("rootElement=");
        this.printQuotedString(string);
        this.fOut.print(',');
        this.fOut.print("publicId=");
        this.printQuotedString(string2);
        this.fOut.print(',');
        this.fOut.print("systemId=");
        this.printQuotedString(string3);
        this.fOut.println(')');
        if (augmentations != null) {
            this.fOut.print(',');
            this.printAugmentations(augmentations);
        }
        this.fOut.flush();
    }

    public void startElement(QName qName, XMLAttributes xMLAttributes, Augmentations augmentations) throws XNIException {
        this.printInScopeNamespaces();
        this.printIndent();
        this.fOut.print("startElement(");
        this.printElement(qName, xMLAttributes);
        if (augmentations != null) {
            this.fOut.print(',');
            this.printAugmentations(augmentations);
        }
        this.fOut.println(')');
        this.fOut.flush();
        ++this.fIndent;
    }

    public void emptyElement(QName qName, XMLAttributes xMLAttributes, Augmentations augmentations) throws XNIException {
        this.printInScopeNamespaces();
        this.printIndent();
        this.fOut.print("emptyElement(");
        this.printElement(qName, xMLAttributes);
        if (augmentations != null) {
            this.fOut.print(',');
            this.printAugmentations(augmentations);
        }
        this.fOut.println(')');
        this.fOut.flush();
        this.printEndNamespaceMapping();
    }

    public void characters(XMLString xMLString, Augmentations augmentations) throws XNIException {
        this.printIndent();
        this.fOut.print("characters(");
        this.fOut.print("text=");
        this.printQuotedString(xMLString.ch, xMLString.offset, xMLString.length);
        if (augmentations != null) {
            this.fOut.print(',');
            this.printAugmentations(augmentations);
        }
        this.fOut.println(')');
        this.fOut.flush();
    }

    public void ignorableWhitespace(XMLString xMLString, Augmentations augmentations) throws XNIException {
        this.printIndent();
        this.fOut.print("ignorableWhitespace(");
        this.fOut.print("text=");
        this.printQuotedString(xMLString.ch, xMLString.offset, xMLString.length);
        if (augmentations != null) {
            this.fOut.print(',');
            this.printAugmentations(augmentations);
        }
        this.fOut.println(')');
        this.fOut.flush();
    }

    public void endElement(QName qName, Augmentations augmentations) throws XNIException {
        --this.fIndent;
        this.printIndent();
        this.fOut.print("endElement(");
        this.fOut.print("element=");
        this.fOut.print('{');
        this.fOut.print("prefix=");
        this.printQuotedString(qName.prefix);
        this.fOut.print(',');
        this.fOut.print("localpart=");
        this.printQuotedString(qName.localpart);
        this.fOut.print(',');
        this.fOut.print("rawname=");
        this.printQuotedString(qName.rawname);
        this.fOut.print(',');
        this.fOut.print("uri=");
        this.printQuotedString(qName.uri);
        this.fOut.print('}');
        if (augmentations != null) {
            this.fOut.print(',');
            this.printAugmentations(augmentations);
        }
        this.fOut.println(')');
        this.fOut.flush();
        this.printEndNamespaceMapping();
    }

    public void startCDATA(Augmentations augmentations) throws XNIException {
        this.printIndent();
        this.fOut.print("startCDATA(");
        if (augmentations != null) {
            this.printAugmentations(augmentations);
        }
        this.fOut.println(')');
        this.fOut.flush();
        ++this.fIndent;
    }

    public void endCDATA(Augmentations augmentations) throws XNIException {
        --this.fIndent;
        this.printIndent();
        this.fOut.print("endCDATA(");
        if (augmentations != null) {
            this.fOut.print(',');
            this.printAugmentations(augmentations);
        }
        this.fOut.println(')');
        this.fOut.flush();
    }

    public void startGeneralEntity(String string, XMLResourceIdentifier xMLResourceIdentifier, String string2, Augmentations augmentations) throws XNIException {
        this.printIndent();
        this.fOut.print("startGeneralEntity(");
        this.fOut.print("name=");
        this.printQuotedString(string);
        this.fOut.print(',');
        this.fOut.print("identifier=");
        this.fOut.print(xMLResourceIdentifier);
        this.fOut.print(',');
        this.fOut.print("encoding=");
        this.printQuotedString(string2);
        if (augmentations != null) {
            this.fOut.print(',');
            this.printAugmentations(augmentations);
        }
        this.fOut.println(')');
        this.fOut.flush();
        ++this.fIndent;
    }

    public void textDecl(String string, String string2, Augmentations augmentations) throws XNIException {
        this.printIndent();
        this.fOut.print("textDecl(");
        this.fOut.print("version=");
        this.printQuotedString(string);
        this.fOut.print(',');
        this.fOut.print("encoding=");
        this.printQuotedString(string2);
        if (augmentations != null) {
            this.fOut.print(',');
            this.printAugmentations(augmentations);
        }
        this.fOut.println(')');
        this.fOut.flush();
    }

    public void comment(XMLString xMLString, Augmentations augmentations) throws XNIException {
        this.printIndent();
        this.fOut.print("comment(");
        this.fOut.print("text=");
        this.printQuotedString(xMLString.ch, xMLString.offset, xMLString.length);
        if (augmentations != null) {
            this.fOut.print(',');
            this.printAugmentations(augmentations);
        }
        this.fOut.println(')');
        this.fOut.flush();
    }

    public void processingInstruction(String string, XMLString xMLString, Augmentations augmentations) throws XNIException {
        this.printIndent();
        this.fOut.print("processingInstruction(");
        this.fOut.print("target=");
        this.printQuotedString(string);
        this.fOut.print(',');
        this.fOut.print("data=");
        this.printQuotedString(xMLString.ch, xMLString.offset, xMLString.length);
        if (augmentations != null) {
            this.fOut.print(',');
            this.printAugmentations(augmentations);
        }
        this.fOut.println(')');
        this.fOut.flush();
    }

    public void endGeneralEntity(String string, Augmentations augmentations) throws XNIException {
        --this.fIndent;
        this.printIndent();
        this.fOut.print("endGeneralEntity(");
        this.fOut.print("name=");
        this.printQuotedString(string);
        if (augmentations != null) {
            this.fOut.print(',');
            this.printAugmentations(augmentations);
        }
        this.fOut.println(')');
        this.fOut.flush();
    }

    public void endDocument(Augmentations augmentations) throws XNIException {
        --this.fIndent;
        this.printIndent();
        this.fOut.print("endDocument(");
        if (augmentations != null) {
            this.fOut.print(',');
            this.printAugmentations(augmentations);
        }
        this.fOut.println(')');
        this.fOut.flush();
    }

    public void startDTD(XMLLocator xMLLocator, Augmentations augmentations) throws XNIException {
        this.printIndent();
        this.fOut.print("startDTD(");
        this.fOut.print("locator=");
        if (xMLLocator == null) {
            this.fOut.print("null");
        } else {
            this.fOut.print('{');
            this.fOut.print("publicId=");
            this.printQuotedString(xMLLocator.getPublicId());
            this.fOut.print(',');
            this.fOut.print("literal systemId=");
            this.printQuotedString(xMLLocator.getLiteralSystemId());
            this.fOut.print(',');
            this.fOut.print("baseSystemId=");
            this.printQuotedString(xMLLocator.getBaseSystemId());
            this.fOut.print(',');
            this.fOut.print("expanded systemId=");
            this.printQuotedString(xMLLocator.getExpandedSystemId());
            this.fOut.print(',');
            this.fOut.print("lineNumber=");
            this.fOut.print(xMLLocator.getLineNumber());
            this.fOut.print(',');
            this.fOut.print("columnNumber=");
            this.fOut.print(xMLLocator.getColumnNumber());
            this.fOut.print('}');
        }
        if (augmentations != null) {
            this.fOut.print(',');
            this.printAugmentations(augmentations);
        }
        this.fOut.println(')');
        this.fOut.flush();
        ++this.fIndent;
    }

    public void startExternalSubset(XMLResourceIdentifier xMLResourceIdentifier, Augmentations augmentations) throws XNIException {
        this.printIndent();
        this.fOut.print("startExternalSubset(");
        if (augmentations != null) {
            this.fOut.print(',');
            this.printAugmentations(augmentations);
        }
        this.fOut.println(')');
        this.fOut.flush();
        ++this.fIndent;
    }

    public void endExternalSubset(Augmentations augmentations) throws XNIException {
        --this.fIndent;
        this.printIndent();
        this.fOut.print("endExternalSubset(");
        if (augmentations != null) {
            this.fOut.print(',');
            this.printAugmentations(augmentations);
        }
        this.fOut.println(')');
        this.fOut.flush();
    }

    public void ignoredCharacters(XMLString xMLString, Augmentations augmentations) throws XNIException {
        this.printIndent();
        this.fOut.print("ignoredCharacters(");
        this.fOut.print("text=");
        this.printQuotedString(xMLString.ch, xMLString.offset, xMLString.length);
        if (augmentations != null) {
            this.fOut.print(',');
            this.printAugmentations(augmentations);
        }
        this.fOut.println(')');
        this.fOut.flush();
    }

    public void startParameterEntity(String string, XMLResourceIdentifier xMLResourceIdentifier, String string2, Augmentations augmentations) throws XNIException {
        this.printIndent();
        this.fOut.print("startParameterEntity(");
        this.fOut.print("name=");
        this.printQuotedString(string);
        this.fOut.print(',');
        this.fOut.print("identifier=");
        this.fOut.print(xMLResourceIdentifier);
        this.fOut.print(',');
        this.fOut.print("encoding=");
        this.printQuotedString(string2);
        if (augmentations != null) {
            this.fOut.print(',');
            this.printAugmentations(augmentations);
        }
        this.fOut.println(')');
        this.fOut.flush();
        ++this.fIndent;
    }

    public void endParameterEntity(String string, Augmentations augmentations) throws XNIException {
        --this.fIndent;
        this.printIndent();
        this.fOut.print("endParameterEntity(");
        this.fOut.print("name=");
        this.printQuotedString(string);
        if (augmentations != null) {
            this.fOut.print(',');
            this.printAugmentations(augmentations);
        }
        this.fOut.println(')');
        this.fOut.flush();
    }

    public void elementDecl(String string, String string2, Augmentations augmentations) throws XNIException {
        this.printIndent();
        this.fOut.print("elementDecl(");
        this.fOut.print("name=");
        this.printQuotedString(string);
        this.fOut.print(',');
        this.fOut.print("contentModel=");
        this.printQuotedString(string2);
        if (augmentations != null) {
            this.fOut.print(',');
            this.printAugmentations(augmentations);
        }
        this.fOut.println(')');
        this.fOut.flush();
    }

    public void startAttlist(String string, Augmentations augmentations) throws XNIException {
        this.printIndent();
        this.fOut.print("startAttlist(");
        this.fOut.print("elementName=");
        this.printQuotedString(string);
        if (augmentations != null) {
            this.fOut.print(',');
            this.printAugmentations(augmentations);
        }
        this.fOut.println(')');
        this.fOut.flush();
        ++this.fIndent;
    }

    public void attributeDecl(String string, String string2, String string3, String[] stringArray, String string4, XMLString xMLString, XMLString xMLString2, Augmentations augmentations) throws XNIException {
        this.printIndent();
        this.fOut.print("attributeDecl(");
        this.fOut.print("elementName=");
        this.printQuotedString(string);
        this.fOut.print(',');
        this.fOut.print("attributeName=");
        this.printQuotedString(string2);
        this.fOut.print(',');
        this.fOut.print("type=");
        this.printQuotedString(string3);
        this.fOut.print(',');
        this.fOut.print("enumeration=");
        if (stringArray == null) {
            this.fOut.print("null");
        } else {
            this.fOut.print('{');
            for (int i = 0; i < stringArray.length; ++i) {
                this.printQuotedString(stringArray[i]);
                if (i >= stringArray.length - 1) continue;
                this.fOut.print(',');
            }
            this.fOut.print('}');
        }
        this.fOut.print(',');
        this.fOut.print("defaultType=");
        this.printQuotedString(string4);
        this.fOut.print(',');
        this.fOut.print("defaultValue=");
        if (xMLString == null) {
            this.fOut.print("null");
        } else {
            this.printQuotedString(xMLString.ch, xMLString.offset, xMLString.length);
        }
        this.fOut.print(',');
        this.fOut.print("nonNormalizedDefaultValue=");
        if (xMLString2 == null) {
            this.fOut.print("null");
        } else {
            this.printQuotedString(xMLString2.ch, xMLString2.offset, xMLString2.length);
        }
        if (augmentations != null) {
            this.fOut.print(',');
            this.printAugmentations(augmentations);
        }
        this.fOut.println(')');
        this.fOut.flush();
    }

    public void endAttlist(Augmentations augmentations) throws XNIException {
        --this.fIndent;
        this.printIndent();
        this.fOut.print("endAttlist(");
        if (augmentations != null) {
            this.fOut.print(',');
            this.printAugmentations(augmentations);
        }
        this.fOut.println(')');
        this.fOut.flush();
    }

    public void internalEntityDecl(String string, XMLString xMLString, XMLString xMLString2, Augmentations augmentations) throws XNIException {
        this.printIndent();
        this.fOut.print("internalEntityDecl(");
        this.fOut.print("name=");
        this.printQuotedString(string);
        this.fOut.print(',');
        this.fOut.print("text=");
        this.printQuotedString(xMLString.ch, xMLString.offset, xMLString.length);
        this.fOut.print(',');
        this.fOut.print("nonNormalizedText=");
        this.printQuotedString(xMLString2.ch, xMLString2.offset, xMLString2.length);
        if (augmentations != null) {
            this.fOut.print(',');
            this.printAugmentations(augmentations);
        }
        this.fOut.println(')');
        this.fOut.flush();
    }

    public void externalEntityDecl(String string, XMLResourceIdentifier xMLResourceIdentifier, Augmentations augmentations) throws XNIException {
        this.printIndent();
        this.fOut.print("externalEntityDecl(");
        this.fOut.print("name=");
        this.printQuotedString(string);
        this.fOut.print(',');
        this.fOut.print("publicId=");
        this.printQuotedString(xMLResourceIdentifier.getPublicId());
        this.fOut.print(',');
        this.fOut.print("systemId=");
        this.printQuotedString(xMLResourceIdentifier.getLiteralSystemId());
        this.fOut.print(',');
        this.fOut.print("baseSystemId=");
        this.printQuotedString(xMLResourceIdentifier.getBaseSystemId());
        if (augmentations != null) {
            this.fOut.print(',');
            this.printAugmentations(augmentations);
        }
        this.fOut.println(')');
        this.fOut.flush();
    }

    public void unparsedEntityDecl(String string, XMLResourceIdentifier xMLResourceIdentifier, String string2, Augmentations augmentations) throws XNIException {
        this.printIndent();
        this.fOut.print("unparsedEntityDecl(");
        this.fOut.print("name=");
        this.printQuotedString(string);
        this.fOut.print(',');
        this.fOut.print("publicId=");
        this.printQuotedString(xMLResourceIdentifier.getPublicId());
        this.fOut.print(',');
        this.fOut.print("systemId=");
        this.printQuotedString(xMLResourceIdentifier.getLiteralSystemId());
        this.fOut.print(',');
        this.fOut.print("baseSystemId=");
        this.printQuotedString(xMLResourceIdentifier.getBaseSystemId());
        this.fOut.print(',');
        this.fOut.print("notation=");
        this.printQuotedString(string2);
        if (augmentations != null) {
            this.fOut.print(',');
            this.printAugmentations(augmentations);
        }
        this.fOut.println(')');
        this.fOut.flush();
    }

    public void notationDecl(String string, XMLResourceIdentifier xMLResourceIdentifier, Augmentations augmentations) throws XNIException {
        this.printIndent();
        this.fOut.print("notationDecl(");
        this.fOut.print("name=");
        this.printQuotedString(string);
        this.fOut.print(',');
        this.fOut.print("publicId=");
        this.printQuotedString(xMLResourceIdentifier.getPublicId());
        this.fOut.print(',');
        this.fOut.print("systemId=");
        this.printQuotedString(xMLResourceIdentifier.getLiteralSystemId());
        this.fOut.print(',');
        this.fOut.print("baseSystemId=");
        this.printQuotedString(xMLResourceIdentifier.getBaseSystemId());
        if (augmentations != null) {
            this.fOut.print(',');
            this.printAugmentations(augmentations);
        }
        this.fOut.println(')');
        this.fOut.flush();
    }

    public void startConditional(short s, Augmentations augmentations) throws XNIException {
        this.printIndent();
        this.fOut.print("startConditional(");
        this.fOut.print("type=");
        switch (s) {
            case 1: {
                this.fOut.print("CONDITIONAL_IGNORE");
                break;
            }
            case 0: {
                this.fOut.print("CONDITIONAL_INCLUDE");
                break;
            }
            default: {
                this.fOut.print("??? (" + s + ')');
            }
        }
        if (augmentations != null) {
            this.fOut.print(',');
            this.printAugmentations(augmentations);
        }
        this.fOut.println(')');
        this.fOut.flush();
        ++this.fIndent;
    }

    public void endConditional(Augmentations augmentations) throws XNIException {
        --this.fIndent;
        this.printIndent();
        this.fOut.print("endConditional(");
        if (augmentations != null) {
            this.fOut.print(',');
            this.printAugmentations(augmentations);
        }
        this.fOut.println(')');
        this.fOut.flush();
    }

    public void endDTD(Augmentations augmentations) throws XNIException {
        --this.fIndent;
        this.printIndent();
        this.fOut.print("endDTD(");
        if (augmentations != null) {
            this.fOut.print(',');
            this.printAugmentations(augmentations);
        }
        this.fOut.println(')');
        this.fOut.flush();
    }

    public void startContentModel(String string, Augmentations augmentations) throws XNIException {
        this.printIndent();
        this.fOut.print("startContentModel(");
        this.fOut.print("elementName=");
        this.printQuotedString(string);
        if (augmentations != null) {
            this.fOut.print(',');
            this.printAugmentations(augmentations);
        }
        this.fOut.println(')');
        this.fOut.flush();
        ++this.fIndent;
    }

    public void any(Augmentations augmentations) throws XNIException {
        this.printIndent();
        this.fOut.print("any(");
        if (augmentations != null) {
            this.fOut.print(',');
            this.printAugmentations(augmentations);
        }
        this.fOut.println(')');
        this.fOut.flush();
    }

    public void empty(Augmentations augmentations) throws XNIException {
        this.printIndent();
        this.fOut.print("empty(");
        if (augmentations != null) {
            this.fOut.print(',');
            this.printAugmentations(augmentations);
        }
        this.fOut.println(')');
        this.fOut.flush();
    }

    public void startGroup(Augmentations augmentations) throws XNIException {
        this.printIndent();
        this.fOut.print("startGroup(");
        if (augmentations != null) {
            this.fOut.print(',');
            this.printAugmentations(augmentations);
        }
        this.fOut.println(')');
        this.fOut.flush();
        ++this.fIndent;
    }

    public void pcdata(Augmentations augmentations) throws XNIException {
        this.printIndent();
        this.fOut.print("pcdata(");
        if (augmentations != null) {
            this.fOut.print(',');
            this.printAugmentations(augmentations);
        }
        this.fOut.println(')');
        this.fOut.flush();
    }

    public void element(String string, Augmentations augmentations) throws XNIException {
        this.printIndent();
        this.fOut.print("element(");
        this.fOut.print("elementName=");
        this.printQuotedString(string);
        if (augmentations != null) {
            this.fOut.print(',');
            this.printAugmentations(augmentations);
        }
        this.fOut.println(')');
        this.fOut.flush();
    }

    public void separator(short s, Augmentations augmentations) throws XNIException {
        this.printIndent();
        this.fOut.print("separator(");
        this.fOut.print("separator=");
        switch (s) {
            case 0: {
                this.fOut.print("SEPARATOR_CHOICE");
                break;
            }
            case 1: {
                this.fOut.print("SEPARATOR_SEQUENCE");
                break;
            }
            default: {
                this.fOut.print("??? (" + s + ')');
            }
        }
        if (augmentations != null) {
            this.fOut.print(',');
            this.printAugmentations(augmentations);
        }
        this.fOut.println(')');
        this.fOut.flush();
    }

    public void occurrence(short s, Augmentations augmentations) throws XNIException {
        this.printIndent();
        this.fOut.print("occurrence(");
        this.fOut.print("occurrence=");
        switch (s) {
            case 4: {
                this.fOut.print("OCCURS_ONE_OR_MORE");
                break;
            }
            case 3: {
                this.fOut.print("OCCURS_ZERO_OR_MORE");
                break;
            }
            case 2: {
                this.fOut.print("OCCURS_ZERO_OR_ONE");
                break;
            }
            default: {
                this.fOut.print("??? (" + s + ')');
            }
        }
        if (augmentations != null) {
            this.fOut.print(',');
            this.printAugmentations(augmentations);
        }
        this.fOut.println(')');
        this.fOut.flush();
    }

    public void endGroup(Augmentations augmentations) throws XNIException {
        --this.fIndent;
        this.printIndent();
        this.fOut.print("endGroup(");
        if (augmentations != null) {
            this.fOut.print(',');
            this.printAugmentations(augmentations);
        }
        this.fOut.println(')');
        this.fOut.flush();
    }

    public void endContentModel(Augmentations augmentations) throws XNIException {
        --this.fIndent;
        this.printIndent();
        this.fOut.print("endContentModel(");
        if (augmentations != null) {
            this.fOut.print(',');
            this.printAugmentations(augmentations);
        }
        this.fOut.println(')');
        this.fOut.flush();
    }

    public void warning(String string, String string2, XMLParseException xMLParseException) throws XNIException {
        this.printError("Warning", xMLParseException);
    }

    public void error(String string, String string2, XMLParseException xMLParseException) throws XNIException {
        this.printError("Error", xMLParseException);
    }

    public void fatalError(String string, String string2, XMLParseException xMLParseException) throws XNIException {
        this.printError("Fatal Error", xMLParseException);
        throw xMLParseException;
    }

    protected void printInScopeNamespaces() {
        int n = this.fNamespaceContext.getDeclaredPrefixCount();
        if (n > 0) {
            for (int i = 0; i < n; ++i) {
                this.printIndent();
                this.fOut.print("declaredPrefix(");
                this.fOut.print("prefix=");
                String string = this.fNamespaceContext.getDeclaredPrefixAt(i);
                this.printQuotedString(string);
                this.fOut.print(',');
                this.fOut.print("uri=");
                this.printQuotedString(this.fNamespaceContext.getURI(string));
                this.fOut.println(')');
                this.fOut.flush();
            }
        }
    }

    protected void printEndNamespaceMapping() {
        int n = this.fNamespaceContext.getDeclaredPrefixCount();
        if (n > 0) {
            for (int i = 0; i < n; ++i) {
                this.printIndent();
                this.fOut.print("endPrefix(");
                this.fOut.print("prefix=");
                String string = this.fNamespaceContext.getDeclaredPrefixAt(i);
                this.printQuotedString(string);
                this.fOut.println(')');
                this.fOut.flush();
            }
        }
    }

    protected void printElement(QName qName, XMLAttributes xMLAttributes) {
        this.fOut.print("element=");
        this.fOut.print('{');
        this.fOut.print("prefix=");
        this.printQuotedString(qName.prefix);
        this.fOut.print(',');
        this.fOut.print("localpart=");
        this.printQuotedString(qName.localpart);
        this.fOut.print(',');
        this.fOut.print("rawname=");
        this.printQuotedString(qName.rawname);
        this.fOut.print(',');
        this.fOut.print("uri=");
        this.printQuotedString(qName.uri);
        this.fOut.print('}');
        this.fOut.print(',');
        this.fOut.print("attributes=");
        if (xMLAttributes == null) {
            this.fOut.println("null");
        } else {
            this.fOut.print('{');
            int n = xMLAttributes.getLength();
            for (int i = 0; i < n; ++i) {
                if (i > 0) {
                    this.fOut.print(',');
                }
                xMLAttributes.getName(i, this.fQName);
                String string = xMLAttributes.getType(i);
                String string2 = xMLAttributes.getValue(i);
                String string3 = xMLAttributes.getNonNormalizedValue(i);
                Augmentations augmentations = xMLAttributes.getAugmentations(i);
                this.fOut.print("name=");
                this.fOut.print('{');
                this.fOut.print("prefix=");
                this.printQuotedString(this.fQName.prefix);
                this.fOut.print(',');
                this.fOut.print("localpart=");
                this.printQuotedString(this.fQName.localpart);
                this.fOut.print(',');
                this.fOut.print("rawname=");
                this.printQuotedString(this.fQName.rawname);
                this.fOut.print(',');
                this.fOut.print("uri=");
                this.printQuotedString(this.fQName.uri);
                this.fOut.print('}');
                this.fOut.print(',');
                this.fOut.print("type=");
                this.printQuotedString(string);
                this.fOut.print(',');
                this.fOut.print("value=");
                this.printQuotedString(string2);
                this.fOut.print(',');
                this.fOut.print("nonNormalizedValue=");
                this.printQuotedString(string3);
                if (!xMLAttributes.isSpecified(i)) {
                    this.fOut.print("(default)");
                }
                if (augmentations != null) {
                    this.fOut.print(',');
                    this.printAugmentations(augmentations);
                }
                this.fOut.print('}');
            }
            this.fOut.print('}');
        }
    }

    protected void printAugmentations(Augmentations augmentations) {
        this.fOut.print("augs={");
        Enumeration enumeration = augmentations.keys();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            Object object = augmentations.getItem(string);
            this.fOut.print(string);
            this.fOut.print('#');
            this.fOut.print(String.valueOf(object));
        }
        this.fOut.print('}');
    }

    protected void printQuotedString(String string) {
        if (string == null) {
            this.fOut.print("null");
            return;
        }
        this.fOut.print('\"');
        int n = string.length();
        for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            this.normalizeAndPrint(c);
        }
        this.fOut.print('\"');
    }

    protected void printQuotedString(char[] cArray, int n, int n2) {
        this.fOut.print('\"');
        for (int i = 0; i < n2; ++i) {
            this.normalizeAndPrint(cArray[n + i]);
        }
        this.fOut.print('\"');
    }

    protected void normalizeAndPrint(char c) {
        switch (c) {
            case '\n': {
                this.fOut.print("\\n");
                break;
            }
            case '\r': {
                this.fOut.print("\\r");
                break;
            }
            case '\t': {
                this.fOut.print("\\t");
                break;
            }
            case '\\': {
                this.fOut.print("\\\\");
                break;
            }
            case '\"': {
                this.fOut.print("\\\"");
                break;
            }
            default: {
                this.fOut.print(c);
            }
        }
    }

    protected void printError(String string, XMLParseException xMLParseException) {
        System.err.print("[");
        System.err.print(string);
        System.err.print("] ");
        String string2 = xMLParseException.getExpandedSystemId();
        if (string2 != null) {
            int n = string2.lastIndexOf(47);
            if (n != -1) {
                string2 = string2.substring(n + 1);
            }
            System.err.print(string2);
        }
        System.err.print(':');
        System.err.print(xMLParseException.getLineNumber());
        System.err.print(':');
        System.err.print(xMLParseException.getColumnNumber());
        System.err.print(": ");
        System.err.print(xMLParseException.getMessage());
        System.err.println();
        System.err.flush();
    }

    protected void printIndent() {
        for (int i = 0; i < this.fIndent; ++i) {
            this.fOut.print(' ');
        }
    }

    public static void main(String[] stringArray) throws Exception {
        if (stringArray.length == 0) {
            DocumentTracer.printUsage();
            System.exit(1);
        }
        DocumentTracer documentTracer = null;
        XMLParserConfiguration xMLParserConfiguration = null;
        boolean bl = true;
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = false;
        boolean bl5 = false;
        boolean bl6 = false;
        for (int i = 0; i < stringArray.length; ++i) {
            Object object;
            String string;
            block37: {
                block36: {
                    block35: {
                        string = stringArray[i];
                        if (string.startsWith("-")) {
                            object = string.substring(1);
                            if (((String)object).equals("p")) {
                                if (++i == stringArray.length) {
                                    System.err.println("error: Missing argument to -p option.");
                                    continue;
                                }
                                String string2 = stringArray[i];
                                try {
                                    xMLParserConfiguration = (XMLParserConfiguration)ObjectFactory.newInstance(string2, ObjectFactory.findClassLoader(), true);
                                    documentTracer = null;
                                }
                                catch (Exception exception) {
                                    xMLParserConfiguration = null;
                                    System.err.println("error: Unable to instantiate parser configuration (" + string2 + ")");
                                }
                                continue;
                            }
                            if (((String)object).equalsIgnoreCase("n")) {
                                bl = ((String)object).equals("n");
                                continue;
                            }
                            if (((String)object).equalsIgnoreCase("v")) {
                                bl2 = ((String)object).equals("v");
                                continue;
                            }
                            if (((String)object).equalsIgnoreCase("s")) {
                                bl3 = ((String)object).equals("s");
                                continue;
                            }
                            if (((String)object).equalsIgnoreCase("f")) {
                                bl4 = ((String)object).equals("f");
                                continue;
                            }
                            if (((String)object).equalsIgnoreCase("hs")) {
                                bl5 = ((String)object).equals("hs");
                                continue;
                            }
                            if (((String)object).equalsIgnoreCase("c")) {
                                bl6 = ((String)object).equals("c");
                                continue;
                            }
                            if (((String)object).equals("h")) {
                                DocumentTracer.printUsage();
                                continue;
                            }
                        }
                        if (xMLParserConfiguration == null) {
                            try {
                                xMLParserConfiguration = (XMLParserConfiguration)ObjectFactory.newInstance(DEFAULT_PARSER_CONFIG, ObjectFactory.findClassLoader(), true);
                            }
                            catch (Exception exception) {
                                System.err.println("error: Unable to instantiate parser configuration (org.apache.xerces.parsers.XIncludeAwareParserConfiguration)");
                                continue;
                            }
                        }
                        if (documentTracer == null) {
                            documentTracer = new DocumentTracer(xMLParserConfiguration);
                        }
                        try {
                            xMLParserConfiguration.setFeature(NAMESPACES_FEATURE_ID, bl);
                        }
                        catch (XMLConfigurationException xMLConfigurationException) {
                            System.err.println("warning: Parser does not support feature (http://xml.org/sax/features/namespaces)");
                        }
                        try {
                            xMLParserConfiguration.setFeature(VALIDATION_FEATURE_ID, bl2);
                        }
                        catch (XMLConfigurationException xMLConfigurationException) {
                            System.err.println("warning: Parser does not support feature (http://xml.org/sax/features/validation)");
                        }
                        try {
                            xMLParserConfiguration.setFeature(SCHEMA_VALIDATION_FEATURE_ID, bl3);
                        }
                        catch (XMLConfigurationException xMLConfigurationException) {
                            if (xMLConfigurationException.getType() != 1) break block35;
                            System.err.println("warning: Parser does not support feature (http://apache.org/xml/features/validation/schema)");
                        }
                    }
                    try {
                        xMLParserConfiguration.setFeature(SCHEMA_FULL_CHECKING_FEATURE_ID, bl4);
                    }
                    catch (XMLConfigurationException xMLConfigurationException) {
                        if (xMLConfigurationException.getType() != 1) break block36;
                        System.err.println("warning: Parser does not support feature (http://apache.org/xml/features/validation/schema-full-checking)");
                    }
                }
                try {
                    xMLParserConfiguration.setFeature(HONOUR_ALL_SCHEMA_LOCATIONS_ID, bl5);
                }
                catch (XMLConfigurationException xMLConfigurationException) {
                    if (xMLConfigurationException.getType() != 1) break block37;
                    System.err.println("warning: Parser does not support feature (http://apache.org/xml/features/honour-all-schemaLocations)");
                }
            }
            try {
                xMLParserConfiguration.setFeature(NOTIFY_CHAR_REFS_FEATURE_ID, bl6);
            }
            catch (XMLConfigurationException xMLConfigurationException) {
                if (xMLConfigurationException.getType() == 0) {
                    System.err.println("warning: Parser does not recognize feature (http://apache.org/xml/features/scanner/notify-char-refs)");
                }
                System.err.println("warning: Parser does not support feature (http://apache.org/xml/features/scanner/notify-char-refs)");
            }
            try {
                documentTracer.parse(new XMLInputSource(null, string, null));
                continue;
            }
            catch (XMLParseException xMLParseException) {
                continue;
            }
            catch (Exception exception) {
                System.err.println("error: Parse error occurred - " + exception.getMessage());
                if (exception instanceof XNIException) {
                    object = ((XNIException)exception).getException();
                }
                ((Throwable)object).printStackTrace(System.err);
            }
        }
    }

    private static void printUsage() {
        System.err.println("usage: java xni.DocumentTracer (options) uri ...");
        System.err.println();
        System.err.println("options:");
        System.err.println("  -p name     Specify parser configuration by name.");
        System.err.println("  -n | -N     Turn on/off namespace processing.");
        System.err.println("  -v | -V     Turn on/off validation.");
        System.err.println("  -s | -S     Turn on/off Schema validation support.");
        System.err.println("              NOTE: Not supported by all parser configurations.");
        System.err.println("  -f  | -F    Turn on/off Schema full checking.");
        System.err.println("              NOTE: Requires use of -s and not supported by all parsers.");
        System.err.println("  -hs | -HS   Turn on/off honouring of all schema locations.");
        System.err.println("              NOTE: Requires use of -s and not supported by all parsers.");
        System.err.println("  -c | -C     Turn on/off character notifications");
        System.err.println("  -h          This help screen.");
        System.err.println();
        System.err.println("defaults:");
        System.err.println("  Config:     org.apache.xerces.parsers.XIncludeAwareParserConfiguration");
        System.err.print("  Namespaces: ");
        System.err.println("on");
        System.err.print("  Validation: ");
        System.err.println("off");
        System.err.print("  Schema:     ");
        System.err.println("off");
        System.err.print("  Schema full checking:     ");
        System.err.println("off");
        System.err.print("  Honour all schema locations:     ");
        System.err.println("off");
        System.err.print("  Char refs:  ");
        System.err.println("off");
    }
}

