/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xerces.impl.xpath;

import java.io.StringReader;
import org.apache.xerces.impl.xpath.XPath20Parser;
import org.apache.xerces.impl.xpath.XPathException;
import org.apache.xerces.impl.xpath.XPathSyntaxTreeNode;
import org.apache.xerces.util.SymbolTable;
import org.apache.xerces.xni.NamespaceContext;
import org.apache.xerces.xni.QName;
import org.apache.xerces.xni.XMLAttributes;

public class XPath20 {
    protected final String fExpression;
    protected final NamespaceContext fNsContext;
    private XPathSyntaxTreeNode fRootNode;

    public XPath20(String string, SymbolTable symbolTable, NamespaceContext namespaceContext) throws XPathException {
        this.fExpression = string;
        this.fNsContext = namespaceContext;
        StringReader stringReader = new StringReader(this.fExpression + "\n");
        XPath20Parser xPath20Parser = new XPath20Parser(stringReader, namespaceContext);
        this.fRootNode = xPath20Parser.parseExpression();
    }

    public boolean evaluateTest(QName qName, XMLAttributes xMLAttributes) {
        try {
            return this.fRootNode.evaluate(qName, xMLAttributes, this.fNsContext);
        }
        catch (Exception exception) {
            return false;
        }
    }

    public String getXPathStrValue() {
        return this.fExpression;
    }
}

