/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.io.output;

import com.sun.electric.database.geometry.EPoint;
import com.sun.electric.database.hierarchy.Cell;
import com.sun.electric.database.hierarchy.Export;
import com.sun.electric.database.hierarchy.Library;
import com.sun.electric.database.hierarchy.View;
import com.sun.electric.database.prototype.NodeProto;
import com.sun.electric.database.prototype.PortProto;
import com.sun.electric.database.text.Pref;
import com.sun.electric.database.text.TextUtils;
import com.sun.electric.database.text.Version;
import com.sun.electric.database.topology.ArcInst;
import com.sun.electric.database.topology.Connection;
import com.sun.electric.database.topology.NodeInst;
import com.sun.electric.database.topology.PortInst;
import com.sun.electric.database.variable.ElectricObject;
import com.sun.electric.database.variable.ImmutableTextDescriptor;
import com.sun.electric.database.variable.TextDescriptor;
import com.sun.electric.database.variable.Variable;
import com.sun.electric.technology.ArcProto;
import com.sun.electric.technology.PrimitiveNode;
import com.sun.electric.technology.PrimitivePort;
import com.sun.electric.technology.Technology;
import com.sun.electric.tool.Tool;
import com.sun.electric.tool.io.ELIBConstants;
import com.sun.electric.tool.io.output.Output;
import com.sun.electric.tool.user.ui.TopLevel;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.JOptionPane;

public class ELIB
extends Output {
    private HashMap cellInSameGroup = new HashMap();
    private boolean compatibleWith6;
    private TreeMap cellIndexMap = new TreeMap(TextUtils.STRING_NUMBER_ORDER);

    ELIB() {
    }

    public void write6Compatible() {
        this.compatibleWith6 = true;
    }

    protected boolean writeLib(Library lib) {
        try {
            return this.writeTheLibrary(lib);
        }
        catch (IOException e) {
            System.out.println("End of file reached while writing " + this.filePath);
            return true;
        }
    }

    private boolean writeTheLibrary(Library lib) throws IOException {
        Cell cell;
        Tool tool;
        Technology tech;
        View view;
        this.gatherReferencedObjects(lib, true);
        int magic = -1597;
        if (this.compatibleWith6) {
            magic = -1593;
        }
        this.writeBigInteger(magic);
        this.writeByte((byte)2);
        this.writeByte((byte)4);
        this.writeByte((byte)1);
        int nodeIndex = 0;
        int portProtoIndex = 0;
        int nodeProtoIndex = 0;
        int arcIndex = 0;
        HashSet<Cell.CellGroup> cellGroups = new HashSet<Cell.CellGroup>();
        Iterator it = lib.getCells();
        while (it.hasNext()) {
            String protoName;
            Cell cell2 = (Cell)it.next();
            this.putObjIndex(cell2, nodeProtoIndex++);
            Iterator pit = cell2.getPorts();
            while (pit.hasNext()) {
                Export e = (Export)pit.next();
                this.putObjIndex(e, portProtoIndex++);
            }
            Iterator nit = cell2.getNodes();
            while (nit.hasNext()) {
                NodeInst ni = (NodeInst)nit.next();
                this.putObjIndex(ni, nodeIndex++);
            }
            Iterator ait = cell2.getArcs();
            while (ait.hasNext()) {
                ArcInst ai = (ArcInst)ait.next();
                this.putObjIndex(ai, arcIndex++);
            }
            Cell.CellGroup cellGroup = cell2.getCellGroup();
            if (!cellGroups.contains(cellGroup)) {
                Cell firstCellInGroup;
                cellGroups.add(cellGroup);
                Iterator git = cellGroup.getCells();
                Cell lastCellInGroup = firstCellInGroup = (Cell)git.next();
                while (git.hasNext()) {
                    Cell cellInGroup = (Cell)git.next();
                    this.cellInSameGroup.put(lastCellInGroup, cellInGroup);
                    lastCellInGroup = cellInGroup;
                }
                this.cellInSameGroup.put(lastCellInGroup, firstCellInGroup);
            }
            if (!this.compatibleWith6 || this.cellIndexMap.containsKey(protoName = cell2.getName())) continue;
            this.cellIndexMap.put(protoName, null);
        }
        int cellsHere = nodeProtoIndex;
        Iterator it2 = Library.getLibraries();
        while (it2.hasNext()) {
            Library olib = (Library)it2.next();
            if (olib == lib) continue;
            if (!this.objInfo.containsKey(olib)) {
                // empty if block
            }
            Iterator cit = olib.getCells();
            while (cit.hasNext()) {
                String protoName;
                Cell cell3 = (Cell)cit.next();
                if (!this.objInfo.containsKey(cell3)) continue;
                this.putObjIndex(cell3, nodeProtoIndex++);
                Iterator pit = cell3.getPorts();
                while (pit.hasNext()) {
                    Export e = (Export)pit.next();
                    this.putObjIndex(e, portProtoIndex++);
                }
                if (!this.compatibleWith6 || this.cellIndexMap.containsKey(protoName = cell3.getName())) continue;
                this.cellIndexMap.put(protoName, null);
            }
        }
        int techCount = 0;
        int primNodeProtoIndex = 0;
        int primPortProtoIndex = 0;
        int arcProtoIndex = 0;
        int[] primNodeCounts = new int[Technology.getNumTechnologies()];
        int[] primArcCounts = new int[Technology.getNumTechnologies()];
        Iterator it3 = Technology.getTechnologies();
        while (it3.hasNext()) {
            Technology tech2 = (Technology)it3.next();
            if (!this.objInfo.containsKey(tech2)) continue;
            int primNodeStart = primNodeProtoIndex;
            Iterator nit = tech2.getNodes();
            while (nit.hasNext()) {
                PrimitiveNode np = (PrimitiveNode)nit.next();
                if (!this.objInfo.containsKey(np)) continue;
                this.putObjIndex(np, -2 - primNodeProtoIndex++);
                Iterator pit = np.getPorts();
                while (pit.hasNext()) {
                    PrimitivePort pp = (PrimitivePort)pit.next();
                    this.putObjIndex(pp, -2 - primPortProtoIndex++);
                }
            }
            primNodeCounts[techCount] = primNodeProtoIndex - primNodeStart;
            int primArcStart = arcProtoIndex;
            Iterator ait = tech2.getArcs();
            while (ait.hasNext()) {
                ArcProto ap = (ArcProto)ait.next();
                if (!this.objInfo.containsKey(ap)) continue;
                this.putObjIndex(ap, -2 - arcProtoIndex++);
            }
            primArcCounts[techCount] = arcProtoIndex - primArcStart;
            ++techCount;
        }
        int toolCount = 0;
        Iterator it4 = Tool.getTools();
        while (it4.hasNext()) {
            Tool tool2 = (Tool)it4.next();
            if (!this.objInfo.containsKey(tool2)) continue;
            ++toolCount;
        }
        this.writeBigInteger(toolCount);
        this.writeBigInteger(techCount);
        this.writeBigInteger(primNodeProtoIndex);
        this.writeBigInteger(primPortProtoIndex);
        this.writeBigInteger(arcProtoIndex);
        this.writeBigInteger(nodeProtoIndex);
        this.writeBigInteger(nodeIndex);
        this.writeBigInteger(portProtoIndex);
        this.writeBigInteger(arcIndex);
        this.writeBigInteger(0);
        int cellCount = 0;
        if (this.compatibleWith6) {
            Iterator it5 = this.cellIndexMap.entrySet().iterator();
            while (it5.hasNext()) {
                Map.Entry e = it5.next();
                e.setValue(new Integer(cellCount++));
            }
            this.writeBigInteger(cellCount);
        }
        this.writeObj(null);
        this.writeString(Version.getVersion().toString());
        this.putObjIndex(View.UNKNOWN, -1);
        this.putObjIndex(View.LAYOUT, -2);
        this.putObjIndex(View.SCHEMATIC, -3);
        this.putObjIndex(View.ICON, -4);
        this.putObjIndex(View.DOCWAVE, -5);
        this.putObjIndex(View.LAYOUTSKEL, -6);
        this.putObjIndex(View.VHDL, -7);
        this.putObjIndex(View.NETLIST, -8);
        this.putObjIndex(View.DOC, -9);
        this.putObjIndex(View.NETLISTNETLISP, -10);
        this.putObjIndex(View.NETLISTALS, -11);
        this.putObjIndex(View.NETLISTQUISC, -12);
        this.putObjIndex(View.NETLISTRSIM, -13);
        this.putObjIndex(View.NETLISTSILOS, -14);
        this.putObjIndex(View.VERILOG, -15);
        ArrayList<View> viewsToSave = new ArrayList<View>();
        Iterator it6 = View.getViews();
        while (it6.hasNext()) {
            view = (View)it6.next();
            if (this.objInfo.get(view) != null || !this.objInfo.containsKey(view)) continue;
            viewsToSave.add(view);
            this.putObjIndex(view, viewsToSave.size());
        }
        this.writeBigInteger(viewsToSave.size());
        it6 = viewsToSave.iterator();
        while (it6.hasNext()) {
            view = (View)it6.next();
            this.writeString(view.getFullName());
            this.writeString(view.getAbbreviation());
        }
        it6 = lib.getCells();
        while (it6.hasNext()) {
            Cell cell4 = (Cell)it6.next();
            this.writeBigInteger(cell4.getNumArcs());
            this.writeBigInteger(cell4.getNumNodes());
            this.writeBigInteger(cell4.getNumPorts());
        }
        it6 = Library.getLibraries();
        while (it6.hasNext()) {
            Library olib = (Library)it6.next();
            if (olib == lib || !this.objInfo.containsKey(olib)) continue;
            Iterator cit = olib.getCells();
            while (cit.hasNext()) {
                Cell cell5 = (Cell)cit.next();
                if (!this.objInfo.containsKey(cell5)) continue;
                this.writeBigInteger(-1);
                this.writeBigInteger(-1);
                this.writeBigInteger(cell5.getNumPorts());
            }
        }
        techCount = 0;
        it6 = Technology.getTechnologies();
        while (it6.hasNext()) {
            tech = (Technology)it6.next();
            if (!this.objInfo.containsKey(tech)) continue;
            this.writeString(tech.getTechName());
            this.writeBigInteger(primNodeCounts[techCount]);
            Iterator nit = tech.getNodes();
            while (nit.hasNext()) {
                PrimitiveNode np = (PrimitiveNode)nit.next();
                if (!this.objInfo.containsKey(np)) continue;
                this.writeString(np.getName());
                this.writeBigInteger(np.getNumPorts());
                Iterator pit = np.getPorts();
                while (pit.hasNext()) {
                    PrimitivePort pp = (PrimitivePort)pit.next();
                    this.writeString(pp.getName());
                }
            }
            this.writeBigInteger(primArcCounts[techCount]);
            Iterator ait = tech.getArcs();
            while (ait.hasNext()) {
                ArcProto ap = (ArcProto)ait.next();
                if (!this.objInfo.containsKey(ap)) continue;
                this.writeString(ap.getName());
            }
            ++techCount;
        }
        it6 = Tool.getTools();
        while (it6.hasNext()) {
            tool = (Tool)it6.next();
            if (!this.objInfo.containsKey(tool)) continue;
            this.writeString(tool.getName());
        }
        this.writeBigInteger(0);
        it6 = Technology.getTechnologies();
        while (it6.hasNext()) {
            tech = (Technology)it6.next();
            if (!this.objInfo.containsKey(tech)) continue;
            this.writeBigInteger((int)Math.round(tech.getScale() * 2.0));
        }
        this.writeNameSpace();
        this.writeVariables(lib, 0.0);
        it6 = Tool.getTools();
        while (it6.hasNext()) {
            tool = (Tool)it6.next();
            if (!this.objInfo.containsKey(tool)) continue;
            this.writeMeaningPrefs(tool);
        }
        it6 = Technology.getTechnologies();
        while (it6.hasNext()) {
            tech = (Technology)it6.next();
            if (!this.objInfo.containsKey(tech)) continue;
            this.writeMeaningPrefs(tech);
        }
        int numDummyVariables = arcProtoIndex + primNodeProtoIndex + primPortProtoIndex;
        for (int i = 0; i < numDummyVariables; ++i) {
            this.writeNoVariables();
        }
        this.writeBigInteger(0);
        if (this.compatibleWith6) {
            String[] cellNames = new String[cellCount];
            Iterator it7 = this.cellIndexMap.keySet().iterator();
            while (it7.hasNext()) {
                String cellName = (String)it7.next();
                this.writeString(cellName);
                this.writeNoVariables();
            }
        }
        Iterator it8 = lib.getCells();
        while (it8.hasNext()) {
            cell = (Cell)it8.next();
            this.writeNodeProto(cell, true);
        }
        it8 = Library.getLibraries();
        while (it8.hasNext()) {
            Library olib = (Library)it8.next();
            if (olib == lib || !this.objInfo.containsKey(olib)) continue;
            Iterator cit = olib.getCells();
            while (cit.hasNext()) {
                Cell cell6 = (Cell)cit.next();
                if (!this.objInfo.containsKey(cell6)) continue;
                this.writeNodeProto(cell6, false);
            }
        }
        it8 = lib.getCells();
        while (it8.hasNext()) {
            cell = (Cell)it8.next();
            Iterator ait = cell.getArcs();
            while (ait.hasNext()) {
                ArcInst ai = (ArcInst)ait.next();
                this.writeArcInst(ai);
            }
            Iterator nit = cell.getNodes();
            while (nit.hasNext()) {
                NodeInst ni = (NodeInst)nit.next();
                this.writeNodeInst(ni);
            }
        }
        if (!lib.isHidden()) {
            System.out.println(this.filePath + " written (" + cellsHere + " cells)");
        }
        lib.clearChangedMinor();
        lib.clearChangedMajor();
        lib.setFromDisk();
        return false;
    }

    private void writeNodeProto(Cell cell, boolean thislib) throws IOException {
        if (this.compatibleWith6) {
            Integer cellIndex = (Integer)this.cellIndexMap.get(cell.getName());
            this.writeBigInteger(cellIndex);
        } else {
            this.writeString(cell.getName());
            this.writeObj(this.cellInSameGroup.get(cell));
            this.writeObj(null);
        }
        this.writeObj(cell.getView());
        this.writeBigInteger(cell.getVersion());
        this.writeBigInteger((int)ELIBConstants.dateToSeconds(cell.getCreationDate()));
        this.writeBigInteger((int)ELIBConstants.dateToSeconds(cell.getRevisionDate()));
        Technology tech = cell.getTechnology();
        Rectangle2D bounds = cell.getBounds();
        int lowX = (int)Math.round(bounds.getMinX() * tech.getScale() * 2.0);
        int highX = (int)Math.round(bounds.getMaxX() * tech.getScale() * 2.0);
        int lowY = (int)Math.round(bounds.getMinY() * tech.getScale() * 2.0);
        int highY = (int)Math.round(bounds.getMaxY() * tech.getScale() * 2.0);
        this.writeBigInteger(lowX);
        this.writeBigInteger(highX);
        this.writeBigInteger(lowY);
        this.writeBigInteger(highY);
        if (!thislib) {
            Library instlib = cell.getLibrary();
            URL fileUrl = instlib.getLibFile();
            String filePath = fileUrl != null ? fileUrl.getPath() : instlib.getName();
            this.writeString(filePath);
        }
        this.writeBigInteger(cell.getNumPorts());
        Iterator it = cell.getPorts();
        while (it.hasNext()) {
            Export pp = (Export)it.next();
            if (thislib) {
                PortInst pi = pp.getOriginalPort();
                this.writeObj(pi.getNodeInst());
                this.writeObj(pi.getPortProto());
            }
            this.writeString(pp.getName());
            if (!thislib) continue;
            this.writeTextDescriptor(pp.getTextDescriptor(Export.EXPORT_NAME_TD), true);
            this.writeBigInteger(pp.lowLevelGetUserbits());
            this.writeVariables(pp, 0.0);
        }
        if (thislib) {
            this.writeBigInteger(0);
            this.writeBigInteger(cell.lowLevelGetUserbits() & 0xF00002);
            this.writeVariables(cell, 0.0);
        }
    }

    private void writeNodeInst(NodeInst ni) throws IOException {
        int highY;
        int lowY;
        int highX;
        int lowX;
        NodeProto np = ni.getProto();
        Technology tech = ni.getParent().getTechnology();
        this.writeObj(np);
        if (np instanceof Cell) {
            lowX = (int)Math.round((ni.getTrueCenterX() - ni.getXSize() / 2.0) * tech.getScale() * 2.0);
            highX = (int)Math.round((ni.getTrueCenterX() + ni.getXSize() / 2.0) * tech.getScale() * 2.0);
            lowY = (int)Math.round((ni.getTrueCenterY() - ni.getYSize() / 2.0) * tech.getScale() * 2.0);
            highY = (int)Math.round((ni.getTrueCenterY() + ni.getYSize() / 2.0) * tech.getScale() * 2.0);
        } else {
            lowX = (int)Math.round((ni.getAnchorCenterX() - ni.getXSize() / 2.0) * tech.getScale() * 2.0);
            highX = (int)Math.round((ni.getAnchorCenterX() + ni.getXSize() / 2.0) * tech.getScale() * 2.0);
            lowY = (int)Math.round((ni.getAnchorCenterY() - ni.getYSize() / 2.0) * tech.getScale() * 2.0);
            highY = (int)Math.round((ni.getAnchorCenterY() + ni.getYSize() / 2.0) * tech.getScale() * 2.0);
        }
        this.writeBigInteger(lowX);
        this.writeBigInteger(lowY);
        this.writeBigInteger(highX);
        this.writeBigInteger(highY);
        if (np instanceof Cell && !this.compatibleWith6) {
            int anchorX = (int)Math.round(ni.getAnchorCenterX() * tech.getScale() * 2.0);
            int anchorY = (int)Math.round(ni.getAnchorCenterY() * tech.getScale() * 2.0);
            this.writeBigInteger(anchorX);
            this.writeBigInteger(anchorY);
        }
        int transpose = 0;
        int rotation = ni.getAngle();
        if (this.compatibleWith6) {
            NodeInst.OldStyleTransform ost = new NodeInst.OldStyleTransform(ni);
            rotation = ost.getCAngle();
            transpose = ost.isCTranspose() ? 1 : 0;
        } else {
            if (ni.isXMirrored()) {
                transpose |= 2;
            }
            if (ni.isYMirrored()) {
                transpose |= 4;
            }
        }
        this.writeBigInteger(transpose);
        this.writeBigInteger(rotation);
        ImmutableTextDescriptor td = np instanceof Cell ? ni.getTextDescriptor(NodeInst.NODE_PROTO_TD) : null;
        this.writeTextDescriptor(td, true);
        int numConnections = ni.getNumConnections();
        this.writeBigInteger(numConnections);
        if (numConnections > 0) {
            ArrayList sortedList = new ArrayList();
            Iterator it = ni.getConnections();
            while (it.hasNext()) {
                sortedList.add(it.next());
            }
            Collections.sort(sortedList, CONNECTIONS_ORDER);
            it = sortedList.iterator();
            while (it.hasNext()) {
                Connection con = (Connection)it.next();
                ArcInst ai = con.getArc();
                int i = (Integer)this.objInfo.get(ai) << 1;
                if (con.getEndIndex() == 1) {
                    ++i;
                }
                this.writeBigInteger(i);
                this.writeObj(con.getPortInst().getPortProto());
                this.writeNoVariables();
            }
        }
        int numExports = ni.getNumExports();
        this.writeBigInteger(numExports);
        if (numExports > 0) {
            ArrayList sortedList = new ArrayList();
            Iterator it = ni.getExports();
            while (it.hasNext()) {
                sortedList.add(it.next());
            }
            Collections.sort(sortedList, EXPORTS_ORDER);
            it = sortedList.iterator();
            while (it.hasNext()) {
                Export pp = (Export)it.next();
                this.writeObj(pp);
                this.writeObj(pp.getOriginalPort().getPortProto());
                this.writeNoVariables();
            }
        }
        this.writeBigInteger(ni.lowLevelGetUserbits());
        this.writeVariables(ni, tech.getScale() * 2.0);
    }

    private void writeArcInst(ArcInst ai) throws IOException {
        this.writeObj(ai.getProto());
        Technology tech = ai.getParent().getTechnology();
        this.writeBigInteger((int)Math.round(ai.getWidth() * tech.getScale() * 2.0));
        EPoint location = ai.getTailLocation();
        this.writeBigInteger((int)Math.round(((Point2D)location).getX() * tech.getScale() * 2.0));
        this.writeBigInteger((int)Math.round(((Point2D)location).getY() * tech.getScale() * 2.0));
        this.writeObj(ai.getTailPortInst().getNodeInst());
        location = ai.getHeadLocation();
        this.writeBigInteger((int)Math.round(((Point2D)location).getX() * tech.getScale() * 2.0));
        this.writeBigInteger((int)Math.round(((Point2D)location).getY() * tech.getScale() * 2.0));
        this.writeObj(ai.getHeadPortInst().getNodeInst());
        int userBits = ai.makeELIBArcBits();
        this.writeBigInteger(userBits);
        this.writeVariables(ai, 0.0);
    }

    private void writeNameSpace() throws IOException {
        if (this.nameSpace.size() > Short.MAX_VALUE) {
            JOptionPane.showMessageDialog(TopLevel.getCurrentJFrame(), new String[]{"ERROR! Too many unique variable names", "The ELIB format cannot handle this many unique variables names", "Either delete the excess variables, or save to a readable dump"}, "Error saving ELIB file", 0);
            throw new IOException("Variable.Key index too large");
        }
        this.writeBigInteger(this.nameSpace.size());
        boolean keyIndex = false;
        Iterator it = this.nameSpace.keySet().iterator();
        while (it.hasNext()) {
            this.writeString((String)it.next());
        }
    }

    private void writeNoVariables() throws IOException {
        this.writeBigInteger(0);
    }

    private void writeVariables(ElectricObject obj, double scale) throws IOException {
        String[] fontAssociation;
        PortInst pi;
        Iterator pit;
        NodeInst ni;
        int count = obj.getNumVariables();
        String additionalVarName = null;
        int additionalVarType = 4;
        String[] additionalVarValue = null;
        if (obj instanceof NodeInst) {
            ni = (NodeInst)obj;
            pit = ni.getPortInsts();
            while (pit.hasNext()) {
                pi = (PortInst)pit.next();
                count += pi.getNumVariables();
            }
            additionalVarName = NodeInst.NODE_NAME_TD;
            if (ni.isUsernamed()) {
                additionalVarType |= 0x40;
            }
            additionalVarValue = ni.getName();
        } else if (obj instanceof ArcInst) {
            ArcInst ai = (ArcInst)obj;
            additionalVarName = ArcInst.ARC_NAME_TD;
            if (ai.isUsernamed()) {
                additionalVarType |= 0x40;
            }
            additionalVarValue = ai.getName();
        } else if (obj instanceof Library && (fontAssociation = this.createFontAssociation()) != null) {
            additionalVarName = Library.FONT_ASSOCIATIONS.getName();
            additionalVarType |= 0x80 | fontAssociation.length << 9;
            additionalVarValue = fontAssociation;
        }
        if (additionalVarName != null) {
            ++count;
        }
        this.writeBigInteger(count);
        Iterator it = obj.getVariables();
        while (it.hasNext()) {
            Variable var = (Variable)it.next();
            this.writeVariable(var, scale);
        }
        if (obj instanceof NodeInst) {
            ni = (NodeInst)obj;
            pit = ni.getPortInsts();
            while (pit.hasNext()) {
                pi = (PortInst)pit.next();
                if (pi.getNumVariables() == 0) continue;
                Iterator it2 = pi.getVariables();
                while (it2.hasNext()) {
                    Variable var = (Variable)it2.next();
                    this.writeVariable(var, scale);
                }
            }
        }
        if (additionalVarName != null) {
            this.writeVariableName(additionalVarName);
            this.writeBigInteger(additionalVarType);
            ImmutableTextDescriptor td = (additionalVarType & 0x40) != 0 ? obj.getTextDescriptor(additionalVarName) : null;
            this.writeTextDescriptor(td, true);
            if (additionalVarValue instanceof Object[]) {
                Object[] objList = additionalVarValue;
                int len = objList.length;
                this.writeBigInteger(len);
                for (int i = 0; i < len; ++i) {
                    Object oneObj = objList[i];
                    this.putOutVar(oneObj);
                }
            } else {
                this.putOutVar(additionalVarValue);
            }
        }
    }

    private void writeVariable(Variable var, double scale) throws IOException {
        int len;
        Object[] objList;
        this.writeVariableName(this.diskName(var));
        Float[] varObj = var.getObject();
        int type = var.getTextDescriptor().getCFlags();
        if (varObj instanceof Object[]) {
            objList = varObj;
            if (objList.length > 0) {
                type |= ELIBConstants.getVarType(objList[0]) | 0x80 | objList.length << 9;
            }
        } else {
            if (this.compatibleWith6 && varObj instanceof Double) {
                varObj = new Float((Double)varObj);
            }
            type |= ELIBConstants.getVarType(varObj);
        }
        if ((type & 0x1F) != 4 && (type & 0x20000020) != 0) {
            System.out.println("Variable " + var + " on " + var.getOwner() + " is not a string. Language bits are cleared.");
            type &= 0xDFFFFFDF;
        }
        if (var.getOwner() instanceof NodeInst && var.getKey() == NodeInst.TRACE && varObj instanceof Point2D[]) {
            Point2D[] points = (Point2D[])varObj;
            type = var.getTextDescriptor().getCFlags();
            len = points.length * 2;
            type |= 0x85 | len << 9;
            Float[] newPoints = new Float[len];
            for (int i = 0; i < points.length; ++i) {
                newPoints[i * 2] = new Float(points[i].getX());
                newPoints[i * 2 + 1] = new Float(points[i].getY());
            }
            varObj = newPoints;
        }
        if (type == 0) {
            System.out.println("Wrote Type 0 for Variable " + var + ", value " + varObj);
        }
        this.writeBigInteger(type);
        this.writeTextDescriptor(var.getTextDescriptor(), var.isDisplay());
        if (varObj instanceof Object[]) {
            objList = varObj;
            len = objList.length;
            this.writeBigInteger(len);
            for (int i = 0; i < len; ++i) {
                Object oneObj = objList[i];
                this.putOutVar(oneObj);
            }
        } else {
            this.putOutVar(varObj);
        }
    }

    private void writeMeaningPrefs(Object obj) throws IOException {
        List prefs = Pref.getMeaningVariables(obj);
        this.writeBigInteger(prefs.size());
        Iterator it = prefs.iterator();
        while (it.hasNext()) {
            Pref pref = (Pref)it.next();
            this.writeVariableName(pref.getPrefName());
            Object varObj = pref.getValue();
            int type = ELIBConstants.getVarType(varObj);
            if (type == 0) {
                System.out.println("Wrote Type 0 for Variable " + pref.getPrefName() + ", value " + varObj);
            }
            this.writeBigInteger(type);
            this.writeBigInteger(0);
            this.writeBigInteger(0);
            this.putOutVar(varObj);
        }
    }

    private void putOutVar(Object obj) throws IOException {
        if (obj == null) {
            this.writeObj(obj);
            return;
        }
        if (obj instanceof Integer) {
            this.writeBigInteger((Integer)obj);
            return;
        }
        if (obj instanceof Short) {
            this.writeSmallInteger((Short)obj);
            return;
        }
        if (obj instanceof Byte) {
            this.writeByte((Byte)obj);
            return;
        }
        if (obj instanceof String) {
            this.writeString((String)obj);
            return;
        }
        if (obj instanceof Float) {
            this.writeFloat(((Float)obj).floatValue());
            return;
        }
        if (obj instanceof Double) {
            this.writeDouble((Double)obj);
            return;
        }
        if (obj instanceof Point2D) {
            this.writeFloat((float)((Point2D)obj).getX());
            this.writeFloat((float)((Point2D)obj).getY());
            return;
        }
        if (obj instanceof Technology) {
            Technology tech = (Technology)obj;
            this.writeBigInteger(tech.getIndex());
            return;
        }
        if (obj instanceof Library) {
            Library lib = (Library)obj;
            this.writeString(lib.getName());
            return;
        }
        if (obj instanceof Tool) {
            Tool tool = (Tool)obj;
            this.writeBigInteger(tool.getIndex());
            return;
        }
        if (obj instanceof NodeInst) {
            this.writeObj(obj);
            return;
        }
        if (obj instanceof ArcInst) {
            this.writeObj(obj);
            return;
        }
        if (obj instanceof NodeProto) {
            this.writeObj(obj);
            return;
        }
        if (obj instanceof ArcProto) {
            this.writeObj(obj);
            return;
        }
        if (obj instanceof PortProto) {
            this.writeObj(obj);
            return;
        }
        System.out.println("Error: Cannot write objects of type " + obj.getClass());
    }

    private void writeTextDescriptor(TextDescriptor td, boolean isDisplay) throws IOException {
        int td1;
        int td0;
        if (td != null) {
            td0 = td.lowLevelGet0();
            td1 = td.lowLevelGet1();
            if ((td1 & 0x3F8000) != 0) {
                int face = (td1 & 0x3F8000) >> 15;
                td1 = td1 & 0xFFC07FFF | this.faceMap[face] << 15;
            }
        } else {
            td0 = 0;
            td1 = 0;
        }
        this.writeBigInteger(td0);
        this.writeBigInteger(td1);
    }

    private void writeObj(Object obj) throws IOException {
        int objIndex = -1;
        if (obj != null) {
            objIndex = (Integer)this.objInfo.get(obj);
        }
        this.writeBigInteger(objIndex);
    }

    private void writeVariableName(String name) throws IOException {
        short varNameIndex = (Short)this.nameSpace.get(name);
        this.writeSmallInteger(varNameIndex);
    }

    private void writeByte(byte b) throws IOException {
        this.dataOutputStream.write(b);
    }

    private void writeBigInteger(int i) throws IOException {
        this.dataOutputStream.writeInt(i);
    }

    private void writeFloat(float f) throws IOException {
        this.dataOutputStream.writeFloat(f);
    }

    private void writeDouble(double d) throws IOException {
        this.dataOutputStream.writeDouble(d);
    }

    private void writeSmallInteger(short s) throws IOException {
        this.dataOutputStream.writeShort(s);
    }

    private void writeString(String s) throws IOException {
        int len = s.length();
        this.writeBigInteger(len);
        this.dataOutputStream.write(s.getBytes(), 0, len);
    }
}

