/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.user.ncc;

import com.sun.electric.database.hierarchy.Cell;
import com.sun.electric.database.variable.VarContext;
import com.sun.electric.tool.ncc.netlist.NetObject;
import com.sun.electric.tool.ncc.netlist.Port;
import java.util.ArrayList;
import java.util.Set;

public abstract class ExportMismatch {
    protected String[] desingNames = new String[2];
    protected Cell[] cells = new Cell[2];
    protected VarContext[] contexts = new VarContext[2];
    protected boolean topologyMatch;
    protected boolean nameMatch;
    protected boolean validOnlyWhenTopologyMismatch;

    public ExportMismatch() {
        this.init();
    }

    public ExportMismatch(String name1, String name2) {
        this.desingNames[0] = name1;
        this.desingNames[1] = name2;
        this.init();
    }

    private void init() {
        this.topologyMatch = true;
        this.nameMatch = true;
        this.validOnlyWhenTopologyMismatch = false;
    }

    public String getName(int index) {
        if (index != 0 && index != 1) {
            return null;
        }
        return this.desingNames[index];
    }

    public void setNames(String name1, String name2) {
        this.desingNames[0] = name1;
        this.desingNames[1] = name2;
    }

    public Cell getCell(int index) {
        if (index != 0 && index != 1) {
            return null;
        }
        return this.cells[index];
    }

    public void setCells(Cell cell1, Cell cell2) {
        this.cells[0] = cell1;
        this.cells[1] = cell2;
    }

    public VarContext getContext(int index) {
        if (index != 0 && index != 1) {
            return null;
        }
        return this.contexts[index];
    }

    public void setContexts(VarContext cnxt1, VarContext cnxt2) {
        this.contexts[0] = cnxt1;
        this.contexts[1] = cnxt2;
    }

    public boolean isTopologyMatch() {
        return this.topologyMatch;
    }

    public void setTopologyMatch(boolean topologyMatch) {
        this.topologyMatch = topologyMatch;
    }

    public boolean isNameMatch() {
        return this.nameMatch;
    }

    public void setNameMatch(boolean nameMatch) {
        this.nameMatch = nameMatch;
    }

    public boolean isValidOnlyWhenTopologyMismatch() {
        return this.validOnlyWhenTopologyMismatch;
    }

    public void setValidOnlyWhenTopologyMismatch(boolean valid) {
        this.validOnlyWhenTopologyMismatch = valid;
    }

    public static class TopologyMismatch
    extends ExportMismatch {
        private Port exp1;
        private Port exp2;
        private NetObject sug = null;

        public TopologyMismatch() {
            this.nameMatch = true;
            this.topologyMatch = false;
        }

        public TopologyMismatch(String name1, String name2) {
            this.desingNames[0] = name1;
            this.desingNames[1] = name2;
            this.nameMatch = true;
            this.topologyMatch = false;
        }

        public Port getFirstExport() {
            return this.exp1;
        }

        public Port getSecondExport() {
            return this.exp2;
        }

        public NetObject getSuggestion() {
            return this.sug;
        }

        public void setFirstExport(Port exp1) {
            this.exp1 = exp1;
        }

        public void setSecondExport(Port exp2) {
            this.exp2 = exp2;
        }

        public void setSuggestion(NetObject sug) {
            this.sug = sug;
        }
    }

    public static class NameMismatch
    extends ExportMismatch {
        private Port exp1;
        private NetObject exp2;

        public NameMismatch() {
            this.nameMatch = false;
            this.topologyMatch = true;
        }

        public NameMismatch(String name1, String name2) {
            this.desingNames[0] = name1;
            this.desingNames[1] = name2;
            this.nameMatch = false;
            this.topologyMatch = true;
        }

        public Port getFirstExport() {
            return this.exp1;
        }

        public NetObject getSuggestion() {
            return this.exp2;
        }

        public void setFirstExport(Port exp1) {
            this.exp1 = exp1;
        }

        public void setSuggestion(NetObject exp2) {
            this.exp2 = exp2;
        }
    }

    public static class MultiMatch
    extends ExportMismatch {
        private ArrayList[] ports = new ArrayList[]{new ArrayList(), new ArrayList()};

        public void add(int listIndex, Port port) {
            this.ports[listIndex].add(port);
        }

        public void add(int listIndex, Set portSet) {
            this.ports[listIndex].addAll(portSet);
        }

        public ArrayList getAll(int index) {
            return this.ports[index];
        }
    }
}

