/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.project;

import com.sun.electric.database.hierarchy.Cell;
import com.sun.electric.database.hierarchy.Library;
import com.sun.electric.tool.project.ProjectCell;
import com.sun.electric.tool.project.ProjectLibrary;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProjectDB
implements Serializable {
    private HashMap<Library, ProjectLibrary> libraryProjectInfo = new HashMap();

    List<ProjectLibrary> getProjectLibraries() {
        ArrayList<ProjectLibrary> pLibs = new ArrayList<ProjectLibrary>();
        for (Library lib : this.libraryProjectInfo.keySet()) {
            pLibs.add(this.libraryProjectInfo.get(lib));
        }
        return pLibs;
    }

    ProjectLibrary findProjectLibrary(Library lib) {
        ProjectLibrary pl = this.libraryProjectInfo.get(lib);
        if (pl != null) {
            return pl;
        }
        pl = ProjectLibrary.createProject(lib);
        this.libraryProjectInfo.put(lib, pl);
        return pl;
    }

    ProjectCell findProjectCell(Cell cell) {
        ProjectLibrary pl = this.findProjectLibrary(cell.getLibrary());
        ProjectCell pc = pl.findProjectCell(cell);
        return pc;
    }

    void clearDatabase() {
        this.libraryProjectInfo.clear();
    }
}

