/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.user.dialogs;

import com.sun.electric.database.change.DatabaseChangeEvent;
import com.sun.electric.database.change.DatabaseChangeListener;
import com.sun.electric.database.geometry.Dimension2D;
import com.sun.electric.database.geometry.Orientation;
import com.sun.electric.database.hierarchy.Cell;
import com.sun.electric.database.hierarchy.Export;
import com.sun.electric.database.text.Name;
import com.sun.electric.database.text.Pref;
import com.sun.electric.database.text.TextUtils;
import com.sun.electric.database.topology.ArcInst;
import com.sun.electric.database.topology.Geometric;
import com.sun.electric.database.topology.NodeInst;
import com.sun.electric.database.topology.PortInst;
import com.sun.electric.database.variable.ElectricObject;
import com.sun.electric.technology.Technology;
import com.sun.electric.tool.Job;
import com.sun.electric.tool.JobException;
import com.sun.electric.tool.drc.DRC;
import com.sun.electric.tool.drc.Quick;
import com.sun.electric.tool.user.CircuitChangeJobs;
import com.sun.electric.tool.user.ExportChanges;
import com.sun.electric.tool.user.HighlightListener;
import com.sun.electric.tool.user.Highlighter;
import com.sun.electric.tool.user.User;
import com.sun.electric.tool.user.UserInterfaceMain;
import com.sun.electric.tool.user.dialogs.EDialog;
import com.sun.electric.tool.user.dialogs.EModelessDialog;
import com.sun.electric.tool.user.ui.EditWindow;
import com.sun.electric.tool.user.ui.MeasureListener;
import com.sun.electric.tool.user.ui.ToolBar;
import com.sun.electric.tool.user.ui.TopLevel;
import com.sun.electric.tool.user.ui.WindowFrame;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EventListener;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JRadioButton;
import javax.swing.JSeparator;
import javax.swing.JTextField;

public class Array
extends EModelessDialog
implements HighlightListener,
DatabaseChangeListener {
    private static final int SPACING_EDGE = 1;
    private static final int SPACING_CENTER = 2;
    private static final int SPACING_ESSENTIALBND = 3;
    private static final int SPACING_MEASURED = 4;
    private static Cursor drawArrayCursor = ToolBar.readCursor("CursorArray.gif", 8, 8);
    private static Pref.Group prefs = Pref.groupForPackage(Array.class);
    private static Pref prefLinearDiagonal = Pref.makeBooleanPref("Array_LinearDiagonal", prefs, false);
    private static Pref prefAddNames = Pref.makeBooleanPref("Array_AddNames", prefs, false);
    private static Pref prefDRCGood = Pref.makeBooleanPref("Array_DRCGood", prefs, false);
    private static Pref prefTranspose = Pref.makeBooleanPref("Array_Transpose", prefs, false);
    private static Pref prefXFlip = Pref.makeBooleanPref("Array_XFlip", prefs, false);
    private static Pref prefYFlip = Pref.makeBooleanPref("Array_YFlip", prefs, false);
    private static Pref prefXStagger = Pref.makeBooleanPref("Array_XStagger", prefs, false);
    private static Pref prefYStagger = Pref.makeBooleanPref("Array_YStagger", prefs, false);
    private static Pref prefXCenter = Pref.makeBooleanPref("Array_XCenter", prefs, false);
    private static Pref prefYCenter = Pref.makeBooleanPref("Array_YCenter", prefs, false);
    private static Pref prefSpacingType = Pref.makeIntPref("Array_SpacingType", prefs, 1);
    private static Pref prefXRepeat = Pref.makeIntPref("Array_XRepeat", prefs, 1);
    private static Pref prefYRepeat = Pref.makeIntPref("Array_YRepeat", prefs, 1);
    private static Double lastEdgeOverlapX = null;
    private static Double lastEdgeOverlapY = null;
    private static Double lastCenterlineX = null;
    private static Double lastCenterlineY = null;
    private double spacingOverX;
    private double spacingOverY;
    private double spacingCenterlineX;
    private double spacingCenterlineY;
    private double essentialBndX;
    private double essentialBndY;
    private double spacingMeasuredX;
    private double spacingMeasuredY;
    private Set<Geometric> selected;
    private Set<Geometric> selectedAll;
    private Rectangle2D bounds;
    private Technology tech;
    private JButton apply;
    private JButton cancel;
    private JCheckBox centerXAboutOriginal;
    private JCheckBox centerYAboutOriginal;
    private JButton draw;
    private JCheckBox flipAlternateColumns;
    private JCheckBox flipAlternateRows;
    private JCheckBox generateArrayIndices;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JSeparator jSeparator1;
    private JCheckBox linearDiagonalArray;
    private JButton ok;
    private JCheckBox onlyDRCCorrect;
    private JRadioButton spaceByCenterlineDistance;
    private JRadioButton spaceByEdgeOverlap;
    private JRadioButton spaceByEssentialBnd;
    private JRadioButton spaceByMeasuredDistance;
    private ButtonGroup spacing;
    private JCheckBox staggerAlternateColumns;
    private JCheckBox staggerAlternateRows;
    private JCheckBox transposePlacement;
    private JLabel xOverlapLabel;
    private JTextField xRepeat;
    private JTextField xSpacing;
    private JLabel yOverlapLabel;
    private JTextField yRepeat;
    private JTextField ySpacing;

    public static void showArrayDialog() {
        EditWindow wnd = EditWindow.needCurrent();
        if (wnd == null) {
            return;
        }
        Highlighter highlighter = wnd.getHighlighter();
        if (highlighter == null) {
            JOptionPane.showMessageDialog(TopLevel.getCurrentJFrame(), "Cannot array: nothing is highlighted in this window.");
            return;
        }
        List<Geometric> highs = highlighter.getHighlightedEObjs(true, true);
        if (highs.size() == 0) {
            JOptionPane.showMessageDialog(TopLevel.getCurrentJFrame(), "Select some objects before arraying them.");
            return;
        }
        Array dialog = new Array(TopLevel.getCurrentJFrame());
        dialog.setVisible(true);
    }

    private Array(Frame parent) {
        super(parent, false);
        this.initComponents();
        this.getRootPane().setDefaultButton(this.ok);
        UserInterfaceMain.addDatabaseChangeListener(this);
        Highlighter.addHighlightListener(this);
        EDialog.makeTextFieldSelectAllOnTab(this.xRepeat);
        EDialog.makeTextFieldSelectAllOnTab(this.yRepeat);
        EDialog.makeTextFieldSelectAllOnTab(this.xSpacing);
        EDialog.makeTextFieldSelectAllOnTab(this.ySpacing);
        this.xRepeat.setText(Integer.toString(prefXRepeat.getInt()));
        this.flipAlternateColumns.setSelected(prefXFlip.getBoolean());
        this.staggerAlternateColumns.setSelected(prefXStagger.getBoolean());
        this.centerXAboutOriginal.setSelected(prefXCenter.getBoolean());
        this.yRepeat.setText(Integer.toString(prefYRepeat.getInt()));
        this.flipAlternateRows.setSelected(prefYFlip.getBoolean());
        this.staggerAlternateRows.setSelected(prefYStagger.getBoolean());
        this.centerYAboutOriginal.setSelected(prefYCenter.getBoolean());
        this.linearDiagonalArray.setSelected(prefLinearDiagonal.getBoolean());
        this.generateArrayIndices.setSelected(prefAddNames.getBoolean());
        this.onlyDRCCorrect.setSelected(prefDRCGood.getBoolean());
        this.transposePlacement.setSelected(prefTranspose.getBoolean());
        this.spaceByEdgeOverlap.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                Array.this.newSpacingSelected();
            }
        });
        this.spaceByCenterlineDistance.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                Array.this.newSpacingSelected();
            }
        });
        this.spaceByEssentialBnd.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                Array.this.newSpacingSelected();
            }
        });
        this.spaceByMeasuredDistance.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                Array.this.newSpacingSelected();
            }
        });
        this.updateDialogForSelection();
        this.finishInitialization();
        this.pack();
    }

    protected void escapePressed() {
        this.cancel(null);
    }

    public void highlightChanged(Highlighter which) {
        if (!this.isVisible()) {
            return;
        }
        this.updateDialogForSelection();
    }

    public void highlighterLostFocus(Highlighter highlighterGainedFocus) {
        if (!this.isVisible()) {
            return;
        }
        this.updateDialogForSelection();
    }

    public void databaseChanged(DatabaseChangeEvent e) {
        if (!this.isVisible()) {
            return;
        }
        this.updateDialogForSelection();
    }

    private void updateDialogForSelection() {
        Dimension2D dim;
        ElectricObject eObj;
        EventListener oldListener = WindowFrame.getListener();
        if (oldListener != null && oldListener instanceof DrawArrayListener) {
            return;
        }
        EditWindow wnd = EditWindow.getCurrent();
        if (wnd == null || wnd.getCell() == null) {
            return;
        }
        this.tech = wnd.getCell().getTechnology();
        List<Geometric> highs = wnd.getHighlighter().getHighlightedEObjs(true, true);
        this.onlyDRCCorrect.setEnabled(false);
        if (highs.size() == 1 && (eObj = (ElectricObject)highs.get(0)) instanceof NodeInst) {
            this.onlyDRCCorrect.setEnabled(true);
        }
        this.essentialBndY = 0.0;
        this.essentialBndX = 0.0;
        boolean haveEB = false;
        for (Geometric eObj2 : highs) {
            Cell subCell;
            Rectangle2D spacing;
            NodeInst ni;
            if (!(eObj2 instanceof NodeInst) || !(ni = (NodeInst)eObj2).isCellInstance() || (spacing = (subCell = (Cell)ni.getProto()).findEssentialBounds()) == null) continue;
            double thisDistX = spacing.getWidth();
            double thisDistY = spacing.getHeight();
            if (ni.getAngle() == 900 || ni.getAngle() == 2700) {
                double swap = thisDistX;
                thisDistX = thisDistY;
                thisDistY = swap;
            }
            if (haveEB && (this.essentialBndX != thisDistX || this.essentialBndY != thisDistY)) {
                haveEB = false;
                break;
            }
            this.essentialBndX = thisDistX;
            this.essentialBndY = thisDistY;
            haveEB = true;
        }
        this.spaceByEssentialBnd.setEnabled(haveEB);
        if (prefSpacingType.getInt() == 3 && !haveEB) {
            prefSpacingType.setInt(1);
        }
        if ((dim = MeasureListener.getLastMeasuredDistance()).getWidth() > 0.0 || dim.getHeight() > 0.0) {
            this.spaceByMeasuredDistance.setEnabled(true);
            this.spacingMeasuredX = dim.getWidth();
            this.spacingMeasuredY = dim.getHeight();
        } else {
            this.spaceByMeasuredDistance.setEnabled(false);
            if (prefSpacingType.getInt() == 4) {
                prefSpacingType.setInt(1);
            }
        }
        this.selected = new HashSet<Geometric>();
        this.selectedAll = new HashSet<Geometric>();
        for (Geometric eObj3 : highs) {
            this.selected.add(eObj3);
            this.selectedAll.add(eObj3);
            if (!(eObj3 instanceof ArcInst)) continue;
            ArcInst ai = (ArcInst)eObj3;
            NodeInst niHead = ai.getHeadPortInst().getNodeInst();
            this.selectedAll.add(niHead);
            NodeInst niTail = ai.getTailPortInst().getNodeInst();
            this.selectedAll.add(niTail);
        }
        boolean first = true;
        this.bounds = new Rectangle2D.Double();
        for (Geometric geom : this.selected) {
            if (first) {
                this.bounds.setRect(geom.getBounds());
                first = false;
                continue;
            }
            Rectangle2D.union(this.bounds, geom.getBounds(), this.bounds);
        }
        this.spacingCenterlineX = this.bounds.getWidth();
        this.spacingCenterlineY = this.bounds.getHeight();
        if (lastCenterlineX != null && lastCenterlineY != null) {
            this.spacingCenterlineX = lastCenterlineX;
            this.spacingCenterlineY = lastCenterlineY;
        }
        this.spacingOverY = 0.0;
        this.spacingOverX = 0.0;
        if (lastEdgeOverlapX != null && lastEdgeOverlapY != null) {
            this.spacingOverX = lastEdgeOverlapX;
            this.spacingOverY = lastEdgeOverlapY;
        }
        switch (prefSpacingType.getInt()) {
            case 1: {
                this.spaceByEdgeOverlap.setSelected(true);
                this.xSpacing.setText(TextUtils.formatDistance(this.spacingOverX, this.tech));
                this.ySpacing.setText(TextUtils.formatDistance(this.spacingOverY, this.tech));
                break;
            }
            case 2: {
                this.spaceByCenterlineDistance.setSelected(true);
                this.xSpacing.setText(TextUtils.formatDistance(this.spacingCenterlineX, this.tech));
                this.ySpacing.setText(TextUtils.formatDistance(this.spacingCenterlineY, this.tech));
                break;
            }
            case 3: {
                this.spaceByEssentialBnd.setSelected(true);
                this.xSpacing.setText(TextUtils.formatDistance(this.essentialBndX, this.tech));
                this.ySpacing.setText(TextUtils.formatDistance(this.essentialBndY, this.tech));
                break;
            }
            case 4: {
                this.spaceByMeasuredDistance.setSelected(true);
                this.xSpacing.setText(TextUtils.formatDistance(this.spacingMeasuredX, this.tech));
                this.ySpacing.setText(TextUtils.formatDistance(this.spacingMeasuredY, this.tech));
            }
        }
        if (prefSpacingType.getInt() == 1) {
            this.xOverlapLabel.setText("X edge overlap:");
            this.yOverlapLabel.setText("Y edge overlap:");
        } else {
            this.xOverlapLabel.setText("X centerline distance:");
            this.yOverlapLabel.setText("Y centerline distance:");
        }
    }

    private void newSpacingSelected() {
        double x = TextUtils.atofDistance(this.xSpacing.getText(), this.tech);
        double y = TextUtils.atofDistance(this.ySpacing.getText(), this.tech);
        switch (prefSpacingType.getInt()) {
            case 1: {
                this.spacingOverX = x;
                this.spacingOverY = y;
                break;
            }
            case 2: {
                this.spacingCenterlineX = x;
                this.spacingCenterlineY = y;
                break;
            }
            case 3: {
                this.essentialBndX = x;
                this.essentialBndY = y;
                break;
            }
            case 4: {
                this.spacingMeasuredX = x;
                this.spacingMeasuredY = y;
            }
        }
        if (this.spaceByEdgeOverlap.isSelected()) {
            prefSpacingType.setInt(1);
        } else if (this.spaceByCenterlineDistance.isSelected()) {
            prefSpacingType.setInt(2);
        } else if (this.spaceByEssentialBnd.isSelected()) {
            prefSpacingType.setInt(3);
        } else if (this.spaceByMeasuredDistance.isSelected()) {
            prefSpacingType.setInt(4);
        }
        if (prefSpacingType.getInt() == 1) {
            this.xOverlapLabel.setText("X edge overlap:");
            this.yOverlapLabel.setText("Y edge overlap:");
        } else {
            this.xOverlapLabel.setText("X centerline distance:");
            this.yOverlapLabel.setText("Y centerline distance:");
        }
        switch (prefSpacingType.getInt()) {
            case 1: {
                x = this.spacingOverX;
                y = this.spacingOverY;
                break;
            }
            case 2: {
                x = this.spacingCenterlineX;
                y = this.spacingCenterlineY;
                break;
            }
            case 3: {
                x = this.essentialBndX;
                y = this.essentialBndY;
                break;
            }
            case 4: {
                x = this.spacingMeasuredX;
                y = this.spacingMeasuredY;
            }
        }
        this.xSpacing.setText(TextUtils.formatDistance(x, this.tech));
        this.ySpacing.setText(TextUtils.formatDistance(y, this.tech));
    }

    private void rememberFields() {
        prefXRepeat.setInt((int)TextUtils.getValueOfExpression(this.xRepeat.getText()));
        prefXFlip.setBoolean(this.flipAlternateColumns.isSelected());
        prefXStagger.setBoolean(this.staggerAlternateColumns.isSelected());
        prefXCenter.setBoolean(this.centerXAboutOriginal.isSelected());
        prefYRepeat.setInt((int)TextUtils.getValueOfExpression(this.yRepeat.getText()));
        prefYFlip.setBoolean(this.flipAlternateRows.isSelected());
        prefYStagger.setBoolean(this.staggerAlternateRows.isSelected());
        prefYCenter.setBoolean(this.centerYAboutOriginal.isSelected());
        prefLinearDiagonal.setBoolean(this.linearDiagonalArray.isSelected());
        prefAddNames.setBoolean(this.generateArrayIndices.isSelected());
        prefDRCGood.setBoolean(this.onlyDRCCorrect.isSelected());
        prefTranspose.setBoolean(this.transposePlacement.isSelected());
        if (prefSpacingType.getInt() == 1) {
            lastEdgeOverlapX = new Double(TextUtils.atofDistance(this.xSpacing.getText()));
            lastEdgeOverlapY = new Double(TextUtils.atofDistance(this.ySpacing.getText()));
        } else {
            lastCenterlineX = new Double(TextUtils.atofDistance(this.xSpacing.getText()));
            lastCenterlineY = new Double(TextUtils.atofDistance(this.ySpacing.getText()));
        }
    }

    private void makeArray() {
        int xRepeat = Math.abs(prefXRepeat.getInt());
        int yRepeat = Math.abs(prefYRepeat.getInt());
        if (xRepeat <= 1 && yRepeat <= 1) {
            JOptionPane.showMessageDialog(TopLevel.getCurrentJFrame(), "One dimension of the array must be greater than 1");
            return;
        }
        if (prefLinearDiagonal.getBoolean() && xRepeat != 1 && yRepeat != 1) {
            JOptionPane.showMessageDialog(TopLevel.getCurrentJFrame(), "Diagonal arrays need one dimension to be 1");
            return;
        }
        HashSet<NodeInst> nodeSet = new HashSet<NodeInst>();
        ArrayList<ArcInst> arcList = new ArrayList<ArcInst>();
        ArrayList<Export> exportList = new ArrayList<Export>();
        Cell cell = null;
        for (Geometric geom : this.selected) {
            cell = geom.getParent();
            if (geom instanceof NodeInst) {
                nodeSet.add((NodeInst)geom);
                if (!User.isDupCopiesExports()) continue;
                NodeInst ni = (NodeInst)geom;
                Iterator<Export> eIt = ni.getExports();
                while (eIt.hasNext()) {
                    exportList.add(eIt.next());
                }
                continue;
            }
            ArcInst ai = (ArcInst)geom;
            arcList.add(ai);
            nodeSet.add(ai.getHead().getPortInst().getNodeInst());
            nodeSet.add(ai.getTail().getPortInst().getNodeInst());
        }
        ArrayList<NodeInst> nodeList = new ArrayList<NodeInst>();
        for (NodeInst ni : nodeSet) {
            nodeList.add(ni);
        }
        Collections.sort(nodeList);
        Collections.sort(arcList);
        Collections.sort(exportList);
        double xOverlap = TextUtils.atofDistance(this.xSpacing.getText());
        double yOverlap = TextUtils.atofDistance(this.ySpacing.getText());
        if (prefSpacingType.getInt() == 1) {
            xOverlap = this.bounds.getWidth() - xOverlap;
            yOverlap = this.bounds.getHeight() - yOverlap;
        }
        double cX = this.bounds.getCenterX();
        double cY = this.bounds.getCenterY();
        for (NodeInst ni : nodeList) {
            if (CircuitChangeJobs.cantEdit(cell, ni, true, false, false) == 0) continue;
            return;
        }
        new ArrayStuff(cell, nodeList, arcList, exportList, xRepeat, yRepeat, xOverlap, yOverlap, cX, cY, User.isArcsAutoIncremented());
    }

    private void initComponents() {
        this.spacing = new ButtonGroup();
        this.cancel = new JButton();
        this.ok = new JButton();
        this.jLabel1 = new JLabel();
        this.xRepeat = new JTextField();
        this.flipAlternateColumns = new JCheckBox();
        this.staggerAlternateColumns = new JCheckBox();
        this.centerXAboutOriginal = new JCheckBox();
        this.jLabel2 = new JLabel();
        this.yRepeat = new JTextField();
        this.flipAlternateRows = new JCheckBox();
        this.staggerAlternateRows = new JCheckBox();
        this.centerYAboutOriginal = new JCheckBox();
        this.jSeparator1 = new JSeparator();
        this.xOverlapLabel = new JLabel();
        this.xSpacing = new JTextField();
        this.spaceByEdgeOverlap = new JRadioButton();
        this.spaceByCenterlineDistance = new JRadioButton();
        this.yOverlapLabel = new JLabel();
        this.ySpacing = new JTextField();
        this.spaceByEssentialBnd = new JRadioButton();
        this.spaceByMeasuredDistance = new JRadioButton();
        this.linearDiagonalArray = new JCheckBox();
        this.generateArrayIndices = new JCheckBox();
        this.onlyDRCCorrect = new JCheckBox();
        this.transposePlacement = new JCheckBox();
        this.apply = new JButton();
        this.draw = new JButton();
        this.getContentPane().setLayout(new GridBagLayout());
        this.setTitle("Array");
        this.setName("");
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent evt) {
                Array.this.closeDialog(evt);
            }
        });
        this.cancel.setText("Cancel");
        this.cancel.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                Array.this.cancel(evt);
            }
        });
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 13;
        gridBagConstraints.gridheight = 2;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.getContentPane().add((Component)this.cancel, gridBagConstraints);
        this.ok.setText("OK");
        this.ok.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                Array.this.ok(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 13;
        gridBagConstraints.gridheight = 2;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.getContentPane().add((Component)this.ok, gridBagConstraints);
        this.jLabel1.setText("X repeat factor:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridheight = 3;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.getContentPane().add((Component)this.jLabel1, gridBagConstraints);
        this.xRepeat.setColumns(6);
        this.xRepeat.setText(" ");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridheight = 3;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.getContentPane().add((Component)this.xRepeat, gridBagConstraints);
        this.flipAlternateColumns.setText("Flip alternate columns");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 4, 0, 4);
        this.getContentPane().add((Component)this.flipAlternateColumns, gridBagConstraints);
        this.staggerAlternateColumns.setText("Stagger alternate columns");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 4, 0, 4);
        this.getContentPane().add((Component)this.staggerAlternateColumns, gridBagConstraints);
        this.centerXAboutOriginal.setText("Center about original");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 4, 4, 4);
        this.getContentPane().add((Component)this.centerXAboutOriginal, gridBagConstraints);
        this.jLabel2.setText("Y repeat factor:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridheight = 3;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.getContentPane().add((Component)this.jLabel2, gridBagConstraints);
        this.yRepeat.setColumns(6);
        this.yRepeat.setText(" ");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridheight = 3;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.getContentPane().add((Component)this.yRepeat, gridBagConstraints);
        this.flipAlternateRows.setText("Flip alternate rows");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 4, 0, 4);
        this.getContentPane().add((Component)this.flipAlternateRows, gridBagConstraints);
        this.staggerAlternateRows.setText("Stagger alternate rows");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 4, 0, 4);
        this.getContentPane().add((Component)this.staggerAlternateRows, gridBagConstraints);
        this.centerYAboutOriginal.setText("Center about original");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 4, 4, 4);
        this.getContentPane().add((Component)this.centerYAboutOriginal, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.gridwidth = 4;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.getContentPane().add((Component)this.jSeparator1, gridBagConstraints);
        this.xOverlapLabel.setText("X edge overlap:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.gridheight = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.getContentPane().add((Component)this.xOverlapLabel, gridBagConstraints);
        this.xSpacing.setColumns(6);
        this.xSpacing.setText(" ");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.gridheight = 2;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.getContentPane().add((Component)this.xSpacing, gridBagConstraints);
        this.spacing.add(this.spaceByEdgeOverlap);
        this.spaceByEdgeOverlap.setText("Space by edge overlap");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 17;
        this.getContentPane().add((Component)this.spaceByEdgeOverlap, gridBagConstraints);
        this.spacing.add(this.spaceByCenterlineDistance);
        this.spaceByCenterlineDistance.setText("Space by centerline distance");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 8;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 17;
        this.getContentPane().add((Component)this.spaceByCenterlineDistance, gridBagConstraints);
        this.yOverlapLabel.setText("Y edge overlap:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 9;
        gridBagConstraints.gridheight = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.getContentPane().add((Component)this.yOverlapLabel, gridBagConstraints);
        this.ySpacing.setColumns(6);
        this.ySpacing.setText(" ");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 9;
        gridBagConstraints.gridheight = 2;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.getContentPane().add((Component)this.ySpacing, gridBagConstraints);
        this.spacing.add(this.spaceByEssentialBnd);
        this.spaceByEssentialBnd.setText("Space by cell essential bound");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 9;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 17;
        this.getContentPane().add((Component)this.spaceByEssentialBnd, gridBagConstraints);
        this.spacing.add(this.spaceByMeasuredDistance);
        this.spaceByMeasuredDistance.setText("Space by last measured distance");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 10;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 17;
        this.getContentPane().add((Component)this.spaceByMeasuredDistance, gridBagConstraints);
        this.linearDiagonalArray.setText("Linear diagonal array");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 11;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 4, 2, 4);
        this.getContentPane().add((Component)this.linearDiagonalArray, gridBagConstraints);
        this.generateArrayIndices.setText("Generate array indices");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 12;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(2, 4, 2, 4);
        this.getContentPane().add((Component)this.generateArrayIndices, gridBagConstraints);
        this.onlyDRCCorrect.setText("Only place entries that are DRC correct");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 13;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(2, 4, 2, 4);
        this.getContentPane().add((Component)this.onlyDRCCorrect, gridBagConstraints);
        this.transposePlacement.setText("Transpose placement ordering");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 14;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(2, 4, 4, 4);
        this.getContentPane().add((Component)this.transposePlacement, gridBagConstraints);
        this.apply.setText("Apply");
        this.apply.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                Array.this.applyActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 11;
        gridBagConstraints.gridheight = 2;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.getContentPane().add((Component)this.apply, gridBagConstraints);
        this.draw.setText("Draw");
        this.draw.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                Array.this.drawActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 11;
        gridBagConstraints.gridheight = 2;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.getContentPane().add((Component)this.draw, gridBagConstraints);
        this.pack();
    }

    private void drawActionPerformed(ActionEvent evt) {
        this.rememberFields();
        EventListener oldListener = WindowFrame.getListener();
        Cursor oldCursor = TopLevel.getCurrentCursor();
        if (oldListener == null || !(oldListener instanceof DrawArrayListener)) {
            DrawArrayListener newListener = new DrawArrayListener();
            WindowFrame.setListener(newListener);
            newListener.oldListener = oldListener;
            newListener.oldCursor = oldCursor;
        }
        TopLevel.setCurrentCursor(drawArrayCursor);
        System.out.println("Click to draw the array");
    }

    private void applyActionPerformed(ActionEvent evt) {
        this.rememberFields();
        this.makeArray();
    }

    private void cancel(ActionEvent evt) {
        this.closeDialog(null);
    }

    private void ok(ActionEvent evt) {
        this.rememberFields();
        this.makeArray();
        this.closeDialog(null);
    }

    private void closeDialog(WindowEvent evt) {
        this.rememberFields();
        this.setVisible(false);
        this.dispose();
    }

    private class DrawArrayListener
    implements MouseMotionListener,
    MouseListener,
    MouseWheelListener,
    KeyListener {
        EventListener oldListener;
        Cursor oldCursor;

        private DrawArrayListener() {
        }

        public void mousePressed(MouseEvent evt) {
            this.determineArrayAmount(evt);
            this.showHighlight(evt, (EditWindow)evt.getSource());
        }

        public void mouseDragged(MouseEvent evt) {
            this.determineArrayAmount(evt);
            this.showHighlight(evt, (EditWindow)evt.getSource());
        }

        public void mouseReleased(MouseEvent evt) {
            EditWindow wnd = (EditWindow)evt.getSource();
            Highlighter highlighter = wnd.getHighlighter();
            Cell cell = wnd.getCell();
            highlighter.clear();
            for (Geometric geom : Array.this.selected) {
                highlighter.addElectricObject(geom, cell);
            }
            highlighter.finished();
            this.restoreOriginalSetup();
            Array.this.makeArray();
        }

        public void keyPressed(KeyEvent evt) {
            int chr = evt.getKeyCode();
            if (chr == 27) {
                this.restoreOriginalSetup();
                System.out.println("Array drawing aborted");
            }
        }

        private void restoreOriginalSetup() {
            WindowFrame.setListener(this.oldListener);
            TopLevel.setCurrentCursor(this.oldCursor);
        }

        private void determineArrayAmount(MouseEvent evt) {
            double dY;
            double dX;
            EditWindow wnd = (EditWindow)evt.getSource();
            int x = evt.getX();
            int y = evt.getY();
            Point2D pt = wnd.screenToDatabase(x, y);
            double xOverlap = TextUtils.atofDistance(Array.this.xSpacing.getText());
            double yOverlap = TextUtils.atofDistance(Array.this.ySpacing.getText());
            if (prefSpacingType.getInt() == 1) {
                xOverlap = Array.this.bounds.getWidth() - xOverlap;
                yOverlap = Array.this.bounds.getHeight() - yOverlap;
            }
            dX = (dX = pt.getX() - Array.this.bounds.getCenterX()) > 0.0 ? (dX -= Array.this.bounds.getWidth() / 2.0) : (dX += Array.this.bounds.getWidth() / 2.0);
            int xRep = (int)(dX / xOverlap);
            xRep = xRep == 0 ? 1 : (xRep < 0 ? --xRep : ++xRep);
            if (prefXCenter.getBoolean()) {
                xRep = (Math.abs(xRep) - 1) * 2 + 1;
            }
            dY = (dY = pt.getY() - Array.this.bounds.getCenterY()) > 0.0 ? (dY -= Array.this.bounds.getHeight() / 2.0) : (dY += Array.this.bounds.getHeight() / 2.0);
            int yRep = (int)(dY / yOverlap);
            yRep = yRep == 0 ? 1 : (yRep < 0 ? --yRep : ++yRep);
            if (prefYCenter.getBoolean()) {
                yRep = (Math.abs(yRep) - 1) * 2 + 1;
            }
            if (prefLinearDiagonal.getBoolean()) {
                if (Math.abs(xRep) > Math.abs(yRep)) {
                    xRep = 1;
                } else {
                    yRep = 1;
                }
            }
            prefXRepeat.setInt(xRep);
            Array.this.xRepeat.setText(Integer.toString(xRep));
            prefYRepeat.setInt(yRep);
            Array.this.yRepeat.setText(Integer.toString(yRep));
        }

        private void showHighlight(MouseEvent evt, EditWindow wnd) {
            double xOverlap = TextUtils.atofDistance(Array.this.xSpacing.getText());
            double yOverlap = TextUtils.atofDistance(Array.this.ySpacing.getText());
            if (prefSpacingType.getInt() == 1) {
                xOverlap = Array.this.bounds.getWidth() - xOverlap;
                yOverlap = Array.this.bounds.getHeight() - yOverlap;
            }
            Highlighter highlighter = wnd.getHighlighter();
            Cell cell = wnd.getCell();
            highlighter.clear();
            int xRepeat = Math.abs(prefXRepeat.getInt());
            int yRepeat = Math.abs(prefYRepeat.getInt());
            double cX = Array.this.bounds.getCenterX();
            double cY = Array.this.bounds.getCenterY();
            int total = yRepeat * xRepeat;
            for (int index = 0; index < total; ++index) {
                Point2D.Double tail2;
                Point2D.Double tail1;
                Point2D.Double tail;
                Point2D.Double head2;
                Point2D.Double head1;
                Point2D.Double head;
                int x = index % xRepeat;
                int y = index / xRepeat;
                if (prefTranspose.getBoolean()) {
                    y = index % yRepeat;
                    x = index / yRepeat;
                }
                int xIndex = x;
                int yIndex = y;
                if (prefXCenter.getBoolean()) {
                    xIndex = x - (xRepeat - 1) / 2;
                }
                if (prefYCenter.getBoolean()) {
                    yIndex = y - (yRepeat - 1) / 2;
                }
                if (prefXRepeat.getInt() < 0) {
                    xIndex = -xIndex;
                }
                if (prefYRepeat.getInt() < 0) {
                    yIndex = -yIndex;
                }
                double xPos = cX + xOverlap * (double)xIndex;
                if (prefLinearDiagonal.getBoolean() && xRepeat == 1) {
                    xPos = cX + xOverlap * (double)yIndex;
                }
                double yPos = cY + yOverlap * (double)yIndex;
                if (prefLinearDiagonal.getBoolean() && yRepeat == 1) {
                    yPos = cY + yOverlap * (double)xIndex;
                }
                if ((xIndex & 1) != 0 && prefXStagger.getBoolean()) {
                    yPos += yOverlap / 2.0;
                }
                if ((yIndex & 1) != 0 && prefYStagger.getBoolean()) {
                    xPos += xOverlap / 2.0;
                }
                double lX = xPos - Array.this.bounds.getWidth() / 2.0;
                double hX = lX + Array.this.bounds.getWidth();
                double lY = yPos - Array.this.bounds.getHeight() / 2.0;
                double hY = lY + Array.this.bounds.getHeight();
                Rectangle2D.Double area = new Rectangle2D.Double(lX, lY, hX - lX, hY - lY);
                highlighter.addArea(area, cell);
                double headSize = Math.min(Array.this.bounds.getWidth(), Array.this.bounds.getHeight()) / 5.0;
                if ((xIndex & 1) != 0 && prefXFlip.getBoolean()) {
                    head = new Point2D.Double(lX, yPos);
                    head1 = new Point2D.Double(lX + headSize, yPos + headSize);
                    head2 = new Point2D.Double(lX + headSize, yPos - headSize);
                    tail = new Point2D.Double(hX, yPos);
                    tail1 = new Point2D.Double(hX - headSize, yPos + headSize);
                    tail2 = new Point2D.Double(hX - headSize, yPos - headSize);
                    highlighter.addLine(head, tail, cell);
                    highlighter.addLine(head, head1, cell);
                    highlighter.addLine(head, head2, cell);
                    highlighter.addLine(tail, tail1, cell);
                    highlighter.addLine(tail, tail2, cell);
                }
                if ((yIndex & 1) == 0 || !prefYFlip.getBoolean()) continue;
                head = new Point2D.Double(xPos, lY);
                head1 = new Point2D.Double(xPos + headSize, lY + headSize);
                head2 = new Point2D.Double(xPos - headSize, lY + headSize);
                tail = new Point2D.Double(xPos, hY);
                tail1 = new Point2D.Double(xPos + headSize, hY - headSize);
                tail2 = new Point2D.Double(xPos - headSize, hY - headSize);
                highlighter.addLine(head, tail, cell);
                highlighter.addLine(head, head1, cell);
                highlighter.addLine(head, head2, cell);
                highlighter.addLine(tail, tail1, cell);
                highlighter.addLine(tail, tail2, cell);
            }
            highlighter.finished();
        }

        public void mouseClicked(MouseEvent evt) {
        }

        public void mouseMoved(MouseEvent evt) {
        }

        public void mouseEntered(MouseEvent evt) {
        }

        public void mouseExited(MouseEvent evt) {
        }

        public void mouseWheelMoved(MouseWheelEvent evt) {
        }

        public void keyReleased(KeyEvent evt) {
        }

        public void keyTyped(KeyEvent evt) {
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ArrayStuff
    extends Job {
        private List<NodeInst> nodeList;
        private List<ArcInst> arcList;
        private List<Export> exportList;
        private int xRepeat;
        private int yRepeat;
        private double xOverlap;
        private double yOverlap;
        private double cX;
        private double cY;
        private boolean arcsAutoIncrement;
        private boolean fromRight;
        private Cell cell;
        private DRC.DRCPreferences dp;

        protected ArrayStuff(Cell c, List<NodeInst> nodeList, List<ArcInst> arcList, List<Export> exportList, int xRepeat, int yRepeat, double xOverlap, double yOverlap, double cX, double cY, boolean arcsAutoIncrement) {
            super("Make Array", User.getUserTool(), Job.Type.CHANGE, null, null, Job.Priority.USER);
            this.cell = c;
            this.nodeList = nodeList;
            this.arcList = arcList;
            this.exportList = exportList;
            this.xRepeat = xRepeat;
            this.yRepeat = yRepeat;
            this.xOverlap = xOverlap;
            this.yOverlap = yOverlap;
            this.cX = cX;
            this.cY = cY;
            this.arcsAutoIncrement = arcsAutoIncrement;
            this.fromRight = User.isIncrementRightmostIndex();
            this.dp = new DRC.DRCPreferences(false);
            this.startJob();
        }

        @Override
        public boolean doIt() throws JobException {
            assert (this.cell != null);
            Geometric[] geomsToCheck = null;
            boolean[] validity = null;
            int checkNodeCount = 0;
            if (prefDRCGood.getBoolean()) {
                geomsToCheck = new NodeInst[this.xRepeat * this.yRepeat];
                validity = new boolean[this.xRepeat * this.yRepeat];
                if (this.nodeList.size() == 1) {
                    geomsToCheck[checkNodeCount++] = this.nodeList.get(0);
                }
            }
            int originalX = 0;
            int originalY = 0;
            int total = this.yRepeat * this.xRepeat;
            for (int index = 0; index < total; ++index) {
                int x = index % this.xRepeat;
                int y = index / this.xRepeat;
                if (prefTranspose.getBoolean()) {
                    y = index % this.yRepeat;
                    x = index / this.yRepeat;
                }
                int xIndex = x;
                int yIndex = y;
                if (prefXCenter.getBoolean()) {
                    xIndex = x - (this.xRepeat - 1) / 2;
                }
                if (prefYCenter.getBoolean()) {
                    yIndex = y - (this.yRepeat - 1) / 2;
                }
                if (prefXRepeat.getInt() < 0) {
                    xIndex = -xIndex;
                }
                if (prefYRepeat.getInt() < 0) {
                    yIndex = -yIndex;
                }
                if (xIndex == 0 && yIndex == 0) {
                    originalX = x;
                    originalY = y;
                    continue;
                }
                boolean firstNode = true;
                HashMap<NodeInst, NodeInst> nodeMap = new HashMap<NodeInst, NodeInst>();
                for (NodeInst ni : this.nodeList) {
                    double xPos = this.cX + this.xOverlap * (double)xIndex;
                    if (prefLinearDiagonal.getBoolean() && this.xRepeat == 1) {
                        xPos = this.cX + this.xOverlap * (double)yIndex;
                    }
                    double yPos = this.cY + this.yOverlap * (double)yIndex;
                    if (prefLinearDiagonal.getBoolean() && this.yRepeat == 1) {
                        yPos = this.cY + this.yOverlap * (double)xIndex;
                    }
                    double xOff = ni.getAnchorCenterX() - this.cX;
                    double yOff = ni.getAnchorCenterY() - this.cY;
                    if ((xIndex & 1) != 0 && prefXStagger.getBoolean()) {
                        yPos += this.yOverlap / 2.0;
                    }
                    if ((yIndex & 1) != 0 && prefYStagger.getBoolean()) {
                        xPos += this.xOverlap / 2.0;
                    }
                    boolean flipX = false;
                    boolean flipY = false;
                    if ((xIndex & 1) != 0 && prefXFlip.getBoolean()) {
                        flipX = true;
                        xOff = -xOff;
                    }
                    if ((yIndex & 1) != 0 && prefYFlip.getBoolean()) {
                        flipY = true;
                        yOff = -yOff;
                    }
                    Orientation orient = Orientation.fromJava(0, flipX, flipY).concatenate(ni.getOrient());
                    NodeInst newNi = NodeInst.makeInstance(ni.getProto(), new Point2D.Double(xPos += xOff, yPos += yOff), ni.getXSize(), ni.getYSize(), this.cell, orient, null);
                    if (newNi == null) continue;
                    newNi.copyTextDescriptorFrom(ni, NodeInst.NODE_PROTO);
                    newNi.copyTextDescriptorFrom(ni, NodeInst.NODE_NAME);
                    newNi.setExpanded(ni.isExpanded());
                    if (ni.isHardSelect()) {
                        newNi.setHardSelect();
                    } else {
                        newNi.clearHardSelect();
                    }
                    newNi.setTechSpecific(ni.getTechSpecific());
                    newNi.copyVarsFrom(ni);
                    if (prefAddNames.getBoolean()) {
                        this.setNewName(newNi, x, y);
                    } else {
                        Name nodeNameKey = ni.getNameKey();
                        if (!nodeNameKey.isTempname()) {
                            newNi.setName(ElectricObject.uniqueObjectName(ni.getName(), this.cell, NodeInst.class, false, this.fromRight));
                            newNi.copyTextDescriptorFrom(ni, NodeInst.NODE_NAME);
                        }
                    }
                    nodeMap.put(ni, newNi);
                    if (!prefDRCGood.getBoolean() || !firstNode) continue;
                    geomsToCheck[checkNodeCount++] = newNi;
                    firstNode = false;
                }
                for (ArcInst ai : this.arcList) {
                    NodeInst ni1;
                    NodeInst ni0;
                    double cX0 = ai.getHeadPortInst().getNodeInst().getAnchorCenterX();
                    double cY0 = ai.getHeadPortInst().getNodeInst().getAnchorCenterY();
                    double xOff0 = ai.getHeadLocation().getX() - cX0;
                    double yOff0 = ai.getHeadLocation().getY() - cY0;
                    double cX1 = ai.getTailPortInst().getNodeInst().getAnchorCenterX();
                    double cY1 = ai.getTailPortInst().getNodeInst().getAnchorCenterY();
                    double xOff1 = ai.getTailLocation().getX() - cX1;
                    double yOff1 = ai.getTailLocation().getY() - cY1;
                    if ((xIndex & 1) != 0 && prefXFlip.getBoolean()) {
                        xOff0 = -xOff0;
                        xOff1 = -xOff1;
                    }
                    if ((yIndex & 1) != 0 && prefYFlip.getBoolean()) {
                        yOff0 = -yOff0;
                        yOff1 = -yOff1;
                    }
                    if ((ni0 = (NodeInst)nodeMap.get(ai.getHeadPortInst().getNodeInst())) == null || (ni1 = (NodeInst)nodeMap.get(ai.getTailPortInst().getNodeInst())) == null) continue;
                    cX0 = ni0.getAnchorCenterX();
                    cY0 = ni0.getAnchorCenterY();
                    cX1 = ni1.getAnchorCenterX();
                    cY1 = ni1.getAnchorCenterY();
                    PortInst pi0 = ni0.findPortInstFromProto(ai.getHeadPortInst().getPortProto());
                    PortInst pi1 = ni1.findPortInstFromProto(ai.getTailPortInst().getPortProto());
                    ArcInst newAi = ArcInst.makeInstanceBase(ai.getProto(), ai.getLambdaBaseWidth(), pi0, pi1, new Point2D.Double(cX0 + xOff0, cY0 + yOff0), new Point2D.Double(cX1 + xOff1, cY1 + yOff1), null);
                    if (newAi == null) continue;
                    newAi.copyPropertiesFrom(ai);
                    if (prefAddNames.getBoolean()) {
                        this.setNewName(newAi, x, y);
                        continue;
                    }
                    Name arcNameKey = ai.getNameKey();
                    if (arcNameKey.isTempname()) continue;
                    String newName = ai.getName();
                    if (this.arcsAutoIncrement) {
                        newName = ElectricObject.uniqueObjectName(newName, this.cell, ArcInst.class, false, this.fromRight);
                    }
                    newAi.setName(newName);
                    newAi.copyTextDescriptorFrom(ai, ArcInst.ARC_NAME);
                }
                ArrayList<PortInst> portInstsToExport = new ArrayList<PortInst>();
                HashMap<PortInst, Export> originalExports = new HashMap<PortInst, Export>();
                for (Export pp : this.exportList) {
                    PortInst oldPI = pp.getOriginalPort();
                    NodeInst newNI = (NodeInst)nodeMap.get(oldPI.getNodeInst());
                    if (newNI == null) continue;
                    PortInst pi = newNI.findPortInstFromProto(oldPI.getPortProto());
                    portInstsToExport.add(pi);
                    originalExports.put(pi, pp);
                }
                ExportChanges.reExportPorts(this.cell, portInstsToExport, false, true, true, false, this.fromRight, originalExports);
            }
            if (prefAddNames.getBoolean()) {
                for (NodeInst ni : this.nodeList) {
                    this.setNewName(ni, originalX, originalY);
                }
                for (ArcInst ai : this.arcList) {
                    this.setNewName(ai, originalX, originalY);
                }
            }
            if (prefDRCGood.getBoolean()) {
                Quick.checkDesignRules(this.dp, this.cell, geomsToCheck, validity).termLogging(true);
                for (int i = 1; i < checkNodeCount; ++i) {
                    if (validity[i]) continue;
                    ((NodeInst)geomsToCheck[i]).kill();
                }
            }
            return true;
        }

        private void setNewName(Geometric geom, int x, int y) {
            String objName = "";
            Name geomNameKey = geom instanceof NodeInst ? ((NodeInst)geom).getNameKey() : ((ArcInst)geom).getNameKey();
            String geomName = geomNameKey.toString();
            if (geomNameKey.isTempname()) {
                geomName = null;
            }
            if (geomName != null && !geomName.equals("0") && !geomName.equals("0-0")) {
                objName = geomName.toString();
            }
            String totalName = objName + x + "-" + y;
            if (Math.abs(prefXRepeat.getInt()) <= 1 || Math.abs(prefYRepeat.getInt()) <= 1) {
                totalName = objName + (x + y);
            }
            if (geom instanceof NodeInst) {
                NodeInst ni = (NodeInst)geom;
                ni.setName(totalName);
                if (ni.isCellInstance()) {
                    ni.setOff(NodeInst.NODE_NAME, 0.0, ni.getYSize() / 4.0);
                }
            } else {
                ((ArcInst)geom).setName(totalName);
            }
        }
    }
}

