/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.user.menus;

import com.sun.electric.database.text.TextUtils;
import com.sun.electric.database.topology.ArcInst;
import com.sun.electric.database.topology.Geometric;
import com.sun.electric.database.topology.NodeInst;
import com.sun.electric.tool.Job;
import com.sun.electric.tool.user.Highlighter;
import com.sun.electric.tool.user.menus.CellMenu;
import com.sun.electric.tool.user.menus.EMenu;
import com.sun.electric.tool.user.menus.EMenuBar;
import com.sun.electric.tool.user.menus.EMenuItem;
import com.sun.electric.tool.user.menus.EditMenu;
import com.sun.electric.tool.user.menus.ExportMenu;
import com.sun.electric.tool.user.menus.FileMenu;
import com.sun.electric.tool.user.menus.HelpMenu;
import com.sun.electric.tool.user.menus.PublicDebugMenu;
import com.sun.electric.tool.user.menus.ToolMenu;
import com.sun.electric.tool.user.menus.ViewMenu;
import com.sun.electric.tool.user.menus.WindowMenu;
import com.sun.electric.tool.user.ui.ClickZoomWireListener;
import com.sun.electric.tool.user.ui.WindowFrame;
import com.sun.electric.util.CollectionFactory;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import javax.swing.KeyStroke;

public final class MenuCommands {
    private static List<EMenuItem> rtdefinedMenus = CollectionFactory.createArrayList();
    private static EMenuBar menuBar = null;

    private MenuCommands() {
    }

    public static void addRTDefinedMenu(EMenuItem menu) {
        rtdefinedMenus.add(menu);
    }

    public static EMenuBar menuBar() {
        if (menuBar == null) {
            ArrayList<EMenuItem> itemsList = new ArrayList<EMenuItem>(8);
            itemsList.add(FileMenu.makeMenu());
            itemsList.add(EditMenu.makeMenu());
            itemsList.add(CellMenu.makeMenu());
            itemsList.add(ExportMenu.makeMenu());
            itemsList.add(ViewMenu.makeMenu());
            itemsList.add(WindowMenu.makeMenu());
            itemsList.add(ToolMenu.makeMenu());
            itemsList.add(MenuCommands.makeExtraMenu("menus.SunAsyncMenu"));
            itemsList.add(HelpMenu.makeMenu());
            if (Job.getDebug()) {
                itemsList.addAll(MenuCommands.makeTestMenus());
            }
            if (rtdefinedMenus.size() != 0) {
                for (EMenuItem item : rtdefinedMenus) {
                    itemsList.add(item);
                }
            }
            menuBar = new EMenuBar("", MenuCommands.wiringShortcuts(), itemsList);
            menuBar.restoreSavedBindings(true);
        }
        return menuBar;
    }

    private static List<EMenuItem> makeTestMenus() {
        ArrayList<EMenuItem> list2 = new ArrayList<EMenuItem>(5);
        list2.add(MenuCommands.makeExtraMenu("tests.TestMenu"));
        list2.add(PublicDebugMenu.makeMenu());
        try {
            Class<?> menuClass = Class.forName("com.sun.electric.plugins.tests.DevelopersMenus");
            Method makeMenus = menuClass.getMethod("makeMenus", new Class[0]);
            Object menus = makeMenus.invoke(null, new Object[0]);
            if (menus != null) {
                list2.addAll((List)menus);
            }
        }
        catch (Exception e) {
            TextUtils.recordMissingPrivateComponent("Developers menus");
        }
        return list2;
    }

    static EMenu makeExtraMenu(String plugin) {
        try {
            Class<?> menuClass = Class.forName("com.sun.electric.plugins." + plugin);
            Method makeMenu = menuClass.getMethod("makeMenu", new Class[0]);
            return (EMenu)makeMenu.invoke(null, new Object[0]);
        }
        catch (NoClassDefFoundError e) {
            if (Job.getDebug()) {
                e.printStackTrace();
            } else {
                System.out.println("Can't find plugin class '" + plugin + "' for menu option");
            }
            return null;
        }
        catch (Exception e) {
            if (Job.getDebug()) {
                e.printStackTrace();
            } else {
                System.out.println("Exception while loading plugin class '" + plugin + "' for menu option");
            }
            return null;
        }
    }

    private static EMenu wiringShortcuts() {
        return new EMenu("Shortcuts", new EMenuItem("Wire to Poly", KeyStroke.getKeyStroke(48, 0)){

            @Override
            public void run() {
                ClickZoomWireListener.theOne.wireTo(0);
            }
        }, new EMenuItem("Wire to M1", KeyStroke.getKeyStroke(49, 0)){

            @Override
            public void run() {
                ClickZoomWireListener.theOne.wireTo(1);
            }
        }, new EMenuItem("Wire to M2", KeyStroke.getKeyStroke(50, 0)){

            @Override
            public void run() {
                ClickZoomWireListener.theOne.wireTo(2);
            }
        }, new EMenuItem("Wire to M3", KeyStroke.getKeyStroke(51, 0)){

            @Override
            public void run() {
                ClickZoomWireListener.theOne.wireTo(3);
            }
        }, new EMenuItem("Wire to M4", KeyStroke.getKeyStroke(52, 0)){

            @Override
            public void run() {
                ClickZoomWireListener.theOne.wireTo(4);
            }
        }, new EMenuItem("Wire to M5", KeyStroke.getKeyStroke(53, 0)){

            @Override
            public void run() {
                ClickZoomWireListener.theOne.wireTo(5);
            }
        }, new EMenuItem("Wire to M6", KeyStroke.getKeyStroke(54, 0)){

            @Override
            public void run() {
                ClickZoomWireListener.theOne.wireTo(6);
            }
        }, new EMenuItem("Wire to M7", KeyStroke.getKeyStroke(55, 0)){

            @Override
            public void run() {
                ClickZoomWireListener.theOne.wireTo(7);
            }
        }, new EMenuItem("Wire to M8", KeyStroke.getKeyStroke(56, 0)){

            @Override
            public void run() {
                ClickZoomWireListener.theOne.wireTo(8);
            }
        }, new EMenuItem("Wire to M9", KeyStroke.getKeyStroke(57, 0)){

            @Override
            public void run() {
                ClickZoomWireListener.theOne.wireTo(9);
            }
        }, new EMenuItem("Wire Down One Level", KeyStroke.getKeyStroke(45, 0)){

            @Override
            public void run() {
                ClickZoomWireListener.theOne.wireDownUp(true);
            }
        }, new EMenuItem("Wire Up One Level", KeyStroke.getKeyStroke(61, 0)){

            @Override
            public void run() {
                ClickZoomWireListener.theOne.wireDownUp(false);
            }
        }, new EMenuItem("Switch Wiring Target", KeyStroke.getKeyStroke(32, 0)){

            @Override
            public void run() {
                ClickZoomWireListener.theOne.switchWiringTarget();
            }
        }, EMenuItem.SEPARATOR, WindowMenu.getHiddenWindowCycleMenuItem());
    }

    public static List<Geometric> getSelectedObjects(boolean wantNodes, boolean wantArcs) {
        WindowFrame wf = WindowFrame.getCurrentWindowFrame();
        if (wf == null) {
            return new ArrayList<Geometric>();
        }
        Highlighter highlighter = wf.getContent().getHighlighter();
        if (highlighter == null) {
            return new ArrayList<Geometric>();
        }
        return highlighter.getHighlightedEObjs(wantNodes, wantArcs);
    }

    public static List<NodeInst> getSelectedNodes() {
        WindowFrame wf = WindowFrame.getCurrentWindowFrame();
        if (wf == null) {
            return new ArrayList<NodeInst>();
        }
        Highlighter highlighter = wf.getContent().getHighlighter();
        if (highlighter == null) {
            return new ArrayList<NodeInst>();
        }
        return highlighter.getHighlightedNodes();
    }

    public static List<ArcInst> getSelectedArcs() {
        WindowFrame wf = WindowFrame.getCurrentWindowFrame();
        if (wf == null) {
            return new ArrayList<ArcInst>();
        }
        Highlighter highlighter = wf.getContent().getHighlighter();
        if (highlighter == null) {
            return new ArrayList<ArcInst>();
        }
        return highlighter.getHighlightedArcs();
    }
}

