/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.simulation;

import com.sun.electric.database.geometry.btree.CachingPageStorage;
import com.sun.electric.database.geometry.btree.CachingPageStorageWrapper;
import com.sun.electric.database.geometry.btree.FilePageStorage;
import com.sun.electric.database.geometry.btree.MemoryPageStorage;
import com.sun.electric.database.geometry.btree.OverflowPageStorage;
import com.sun.electric.database.hierarchy.Cell;
import com.sun.electric.tool.simulation.BusSample;
import com.sun.electric.tool.simulation.Engine;
import com.sun.electric.tool.simulation.Signal;
import com.sun.electric.tool.simulation.SignalCollection;
import com.sun.electric.tool.user.waveform.WaveformWindow;
import com.sun.electric.util.TextUtils;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class Stimuli {
    public static final int LOGIC = 3;
    public static final int LOGIC_LOW = 0;
    public static final int LOGIC_X = 1;
    public static final int LOGIC_HIGH = 2;
    public static final int LOGIC_Z = 3;
    public static final int STRENGTH = 12;
    public static final int OFF_STRENGTH = 0;
    public static final int NODE_STRENGTH = 4;
    public static final int GATE_STRENGTH = 8;
    public static final int VDD_STRENGTH = 12;
    private WaveformWindow ww;
    private Engine engine;
    private Cell cell;
    private URL fileURL;
    private char separatorChar = (char)46;
    private Map<String, SignalCollection> scMap = new HashMap<String, SignalCollection>();
    private List<SignalCollection> scList = new ArrayList<SignalCollection>();
    private Map<Signal<?>, Double[]> controlPointMap = new HashMap();
    private String delim = " ";
    private CachingPageStorage ps;

    public Stimuli() {
        try {
            long highWaterMarkInBytes = 0x3200000L;
            FilePageStorage fps = FilePageStorage.create();
            OverflowPageStorage ops = new OverflowPageStorage(new MemoryPageStorage(fps.getPageSize()), fps, highWaterMarkInBytes);
            this.ps = new CachingPageStorageWrapper(ops, 16384, false);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public CachingPageStorage getPageStorage() {
        return this.ps;
    }

    public void finished() {
        this.controlPointMap.clear();
        this.scMap.clear();
        this.scList.clear();
        this.ww = null;
    }

    public void addSignalCollection(SignalCollection an) {
        this.scMap.put(an.getName(), an);
        this.scList.add(an);
    }

    public SignalCollection findSignalCollection(String title) {
        SignalCollection an = this.scMap.get(title);
        return an;
    }

    public void setNetDelimiter(String d) {
        this.delim = d;
    }

    public String getNetDelimiter() {
        return this.delim;
    }

    public Iterator<SignalCollection> getSignalCollections() {
        return this.scList.iterator();
    }

    public void setCell(Cell cell) {
        this.cell = cell;
    }

    public Cell getCell() {
        return this.cell;
    }

    public void setEngine(Engine engine) {
        this.engine = engine;
    }

    public Engine getEngine() {
        return this.engine;
    }

    public void setWaveformWindow(WaveformWindow ww) {
        this.ww = ww;
    }

    public char getSeparatorChar() {
        return this.separatorChar;
    }

    public void setSeparatorChar(char sep) {
        this.separatorChar = sep;
    }

    public void setFileURL(URL fileURL) {
        this.fileURL = fileURL;
    }

    public URL getFileURL() {
        return this.fileURL;
    }

    public WaveformWindow getWaveformWindow() {
        return this.ww;
    }

    public Double[] getControlPoints(Signal<?> sig) {
        return this.controlPointMap.get(sig);
    }

    public void clearControlPoints(Signal<?> sig) {
        this.controlPointMap.remove(sig);
    }

    public void addControlPoint(Signal<?> sig, double time) {
        Double[] controlPoints = this.controlPointMap.get(sig);
        if (controlPoints == null) {
            controlPoints = new Double[]{new Double(time)};
            this.controlPointMap.put(sig, controlPoints);
        } else {
            for (int i = 0; i < controlPoints.length; ++i) {
                if (controlPoints[i] != time) continue;
                return;
            }
            Double[] newCP = new Double[controlPoints.length + 1];
            for (int i = 0; i < controlPoints.length; ++i) {
                newCP[i] = controlPoints[i];
            }
            newCP[controlPoints.length] = new Double(time);
            this.controlPointMap.put(sig, newCP);
        }
    }

    public void removeControlPoint(Signal<?> sig, double time) {
        Double[] controlPoints = this.controlPointMap.get(sig);
        if (controlPoints == null) {
            return;
        }
        boolean found = false;
        for (int i = 0; i < controlPoints.length; ++i) {
            if (controlPoints[i] != time) continue;
            found = true;
            break;
        }
        if (!found) {
            return;
        }
        Double[] newCP = new Double[controlPoints.length - 1];
        int j = 0;
        for (int i = 0; i < controlPoints.length; ++i) {
            if (controlPoints[i] == time) continue;
            newCP[j++] = controlPoints[i];
        }
        this.controlPointMap.put(sig, newCP);
    }

    public double getMinTime() {
        double leftEdge = 0.0;
        double rightEdge = 0.0;
        for (SignalCollection sc : this.scList) {
            for (Signal<?> sig : sc.getSignals()) {
                if (leftEdge == rightEdge) {
                    leftEdge = sig.getMinTime();
                    rightEdge = sig.getMaxTime();
                    continue;
                }
                if (leftEdge < rightEdge) {
                    leftEdge = Math.min(leftEdge, sig.getMinTime());
                    rightEdge = Math.max(rightEdge, sig.getMaxTime());
                    continue;
                }
                leftEdge = Math.max(leftEdge, sig.getMinTime());
                rightEdge = Math.min(rightEdge, sig.getMaxTime());
            }
        }
        return leftEdge;
    }

    public double getMaxTime() {
        double minRange;
        double leftEdge = 0.0;
        double rightEdge = 0.0;
        for (SignalCollection sc : this.scList) {
            for (Signal<?> sig : sc.getSignals()) {
                if (leftEdge == rightEdge) {
                    leftEdge = sig.getMinTime();
                    rightEdge = sig.getMaxTime();
                    continue;
                }
                if (leftEdge < rightEdge) {
                    leftEdge = Math.min(leftEdge, sig.getMinTime());
                    rightEdge = Math.max(rightEdge, sig.getMaxTime());
                    continue;
                }
                leftEdge = Math.max(leftEdge, sig.getMinTime());
                rightEdge = Math.min(rightEdge, sig.getMaxTime());
            }
        }
        if (this.engine != null && rightEdge - leftEdge < (minRange = this.engine.getMinTimeRange())) {
            rightEdge = leftEdge + minRange;
        }
        return rightEdge;
    }

    public boolean isAnalog() {
        for (SignalCollection sc : this.scList) {
            for (Signal<?> sig : sc.getSignals()) {
                if (sig.isDigital()) continue;
                return true;
            }
        }
        return false;
    }

    public static int strengthToIndex(int strength) {
        return strength / 4;
    }

    public static int indexToStrength(int index) {
        return index * 4;
    }

    public static String describeLevel(int state) {
        switch (state & 3) {
            case 0: {
                return "low";
            }
            case 2: {
                return "high";
            }
            case 1: {
                return "undefined";
            }
            case 3: {
                return "floating";
            }
        }
        return "?";
    }

    public static String describeLevelBriefly(int state) {
        switch (state & 3) {
            case 0: {
                return "L";
            }
            case 2: {
                return "H";
            }
            case 1: {
                return "X";
            }
            case 3: {
                return "Z";
            }
        }
        return "?";
    }

    public static int parseLevel(String s1) {
        if (s1.length() > 0) {
            switch (s1.charAt(0)) {
                case 'L': 
                case 'l': {
                    return 0;
                }
                case 'X': 
                case 'x': {
                    return 1;
                }
                case 'H': 
                case 'h': {
                    return 2;
                }
                case 'Z': 
                case 'z': {
                    return 3;
                }
            }
        }
        return 1;
    }

    public static String describeStrength(int strength) {
        switch (strength & 0xC) {
            case 0: {
                return "off";
            }
            case 4: {
                return "node";
            }
            case 8: {
                return "gate";
            }
            case 12: {
                return "power";
            }
        }
        return "?";
    }

    public static SignalCollection newSignalCollection(Stimuli sd, String title) {
        SignalCollection sc = new SignalCollection(title);
        sd.addSignalCollection(sc);
        return sc;
    }

    public void makeBusSignals(List<Signal<?>> signalList, SignalCollection sc) {
        if (signalList == null) {
            return;
        }
        Collections.sort(signalList, new WaveformWindow.SignalsByName());
        ArrayList busSoFar = new ArrayList();
        for (Signal<?> sig : signalList) {
            String curSignalName = sig.getSignalName();
            int squarePos = curSignalName.indexOf(91);
            if (squarePos < 0) {
                this.makeBus(busSoFar, sc);
                continue;
            }
            boolean startNewBus = false;
            if (busSoFar.size() > 0) {
                String curBusName = curSignalName.substring(0, squarePos);
                int curIndex = TextUtils.atoi(curSignalName.substring(squarePos + 1));
                String curScope = sig.getSignalContext();
                if (curScope == null) {
                    curScope = "";
                }
                Signal lastSig = (Signal)busSoFar.get(busSoFar.size() - 1);
                String lastSignalName = lastSig.getSignalName();
                squarePos = lastSignalName.indexOf(91);
                String lastBusName = lastSignalName.substring(0, squarePos);
                int lastIndex = TextUtils.atoi(lastSignalName.substring(squarePos + 1));
                String lastScope = lastSig.getSignalContext();
                if (lastScope == null) {
                    lastScope = "";
                }
                if (!lastBusName.equals(curBusName)) {
                    startNewBus = true;
                } else if (!lastScope.equals(curScope)) {
                    startNewBus = true;
                } else if (lastIndex + 1 != curIndex) {
                    startNewBus = true;
                }
            }
            if (startNewBus) {
                this.makeBus(busSoFar, sc);
            }
            busSoFar.add(sig);
        }
        this.makeBus(busSoFar, sc);
    }

    private void makeBus(List<Signal<?>> busSoFar, SignalCollection sc) {
        if (busSoFar.size() == 0) {
            return;
        }
        int width = busSoFar.size();
        Signal[] subsigs = new Signal[width];
        for (int i = 0; i < width; ++i) {
            subsigs[i] = busSoFar.get(i);
        }
        String firstEntryName = subsigs[0].getSignalName();
        int firstSquarePos = firstEntryName.indexOf(91);
        int firstIndex = TextUtils.atoi(firstEntryName.substring(firstSquarePos + 1));
        String lastEntryName = subsigs[width - 1].getSignalName();
        int lastSquarePos = lastEntryName.indexOf(91);
        int lastIndex = TextUtils.atoi(lastEntryName.substring(lastSquarePos + 1));
        String busName = firstEntryName.substring(0, firstSquarePos) + "[" + firstIndex + ":" + lastIndex + "]";
        String scope = subsigs[0].getSignalContext();
        BusSample.createSignal(sc, this, busName, scope, true, subsigs);
        busSoFar.clear();
    }
}

