/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.io;

import com.izforge.izpack.io.CorruptVolumeException;
import com.izforge.izpack.io.VolumeNotFoundException;
import com.izforge.izpack.util.Debug;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.zip.GZIPInputStream;

public class FileSpanningInputStream
extends InputStream {
    private static final int EOF = -1;
    protected FileInputStream fileinputstream;
    protected String volumename;
    protected int currentvolumeindex;
    protected int volumestotal;
    protected static boolean nextvolumenotfound = false;
    protected long filepointer;
    protected GZIPInputStream zippedinputstream;
    protected byte[] magicnumber;

    public FileSpanningInputStream(File file, int n) throws IOException {
        this.fileinputstream = new FileInputStream(file);
        this.zippedinputstream = new GZIPInputStream(this.fileinputstream);
        this.currentvolumeindex = 0;
        this.volumename = file.getAbsolutePath();
        this.volumestotal = n;
        this.filepointer = 0L;
        this.magicnumber = new byte[10];
        this.zippedinputstream.read(this.magicnumber);
        Debug.trace("Opening stream to " + file + " magicnr is " + this.magicnumber);
        this.filepointer = 0L;
    }

    public FileSpanningInputStream(String string, int n) throws IOException {
        this(new File(string), n);
    }

    private boolean isMagicNumberValid() throws IOException {
        Debug.trace("trying to read magic number");
        boolean bl = false;
        byte[] byArray = new byte[10];
        long l = this.filepointer;
        this.zippedinputstream.read(byArray);
        this.filepointer = l;
        Debug.trace("MagicNr is " + byArray);
        if (byArray != null && this.magicnumber != null) {
            if (byArray.length != this.magicnumber.length) {
                bl = false;
            } else {
                boolean bl2 = false;
                for (int i = 0; i < byArray.length; ++i) {
                    byte by = byArray[i];
                    byte by2 = this.magicnumber[i];
                    if (by == by2) continue;
                    bl2 = true;
                    break;
                }
                bl = !bl2;
            }
        }
        return bl;
    }

    private boolean createInputStreamToNextVolume() throws IOException {
        ++this.currentvolumeindex;
        if (this.currentvolumeindex >= this.volumestotal) {
            Debug.trace("last volume reached.");
            return false;
        }
        String string = this.volumename + "." + this.currentvolumeindex;
        Debug.trace("Trying to use next volume: " + string);
        File file = new File(string);
        if (!file.exists()) {
            --this.currentvolumeindex;
            nextvolumenotfound = true;
            Debug.trace("volume not found");
            throw new VolumeNotFoundException(string + "was not found.", string);
        }
        Debug.trace("next volume found.");
        this.fileinputstream = new FileInputStream(file);
        this.zippedinputstream = new GZIPInputStream(this.fileinputstream);
        if (!this.isMagicNumberValid()) {
            --this.currentvolumeindex;
            nextvolumenotfound = true;
            Debug.trace("volume found, but magic number incorrect. Maybe not a volume of the same version.");
            throw new CorruptVolumeException(string + "was found, but has magic number error. Maybe not the right version?", string);
        }
        nextvolumenotfound = false;
        return true;
    }

    public int available() throws IOException {
        if (nextvolumenotfound) {
            this.createInputStreamToNextVolume();
        }
        return this.zippedinputstream.available();
    }

    public void close() throws IOException {
        this.zippedinputstream.close();
        this.fileinputstream.close();
    }

    public int read() throws IOException {
        if (nextvolumenotfound) {
            this.createInputStreamToNextVolume();
        }
        int n = this.zippedinputstream.read();
        ++this.filepointer;
        if (n == -1) {
            try {
                this.zippedinputstream.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (this.createInputStreamToNextVolume()) {
                n = this.zippedinputstream.read();
                ++this.filepointer;
            }
        }
        return n;
    }

    public int read(byte[] byArray, int n, int n2) throws IOException {
        if (nextvolumenotfound) {
            this.createInputStreamToNextVolume();
        }
        int n3 = this.zippedinputstream.read(byArray, n, n2);
        this.filepointer += (long)n3;
        if (n3 == -1) {
            ++this.filepointer;
            System.out.println("EOF reached.");
            try {
                this.zippedinputstream.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (this.createInputStreamToNextVolume()) {
                Debug.trace("next volume opened, continuing read");
                n3 = this.zippedinputstream.read(byArray, n, n2);
                this.filepointer += (long)n3;
            }
        }
        return n3;
    }

    public int read(byte[] byArray) throws IOException {
        return this.read(byArray, 0, byArray.length);
    }

    public long skip(long l) throws IOException {
        long l2;
        if (nextvolumenotfound) {
            this.createInputStreamToNextVolume();
        }
        byte[] byArray = new byte[4096];
        try {
            int n;
            for (l2 = 0L; l2 < l; l2 += (long)n) {
                int n2 = (int)Math.min(l - l2, (long)byArray.length);
                n = this.read(byArray, 0, n2);
                if (n != -1) continue;
                throw new IOException("Unexpected end of stream (installer corrupted?)");
            }
        }
        catch (VolumeNotFoundException volumeNotFoundException) {
            volumeNotFoundException.setAlreadyskippedbytes(l2);
            throw volumeNotFoundException;
        }
        return l2;
    }

    public String getVolumename() {
        return this.volumename;
    }

    public void setVolumename(String string) {
        Debug.trace("new volumename: " + string);
        String string2 = "." + this.currentvolumeindex;
        String string3 = "." + (this.currentvolumeindex + 1);
        this.volumename = string.endsWith(string2) ? string.substring(0, string.lastIndexOf(string2)) : (string.endsWith(string3) ? string.substring(0, string.lastIndexOf(string3)) : string);
        Debug.trace("Set volumename to: " + this.volumename);
    }

    public long getFilepointer() {
        return this.filepointer;
    }
}

