/*
 * Decompiled with CFR 0.152.
 */
package gnu.prolog.io.parser.gen;

import gnu.prolog.io.parser.gen.Token;

public class ParseException
extends Exception {
    private static final long serialVersionUID = -8554505194284455954L;
    protected boolean specialConstructor;
    public Token currentToken;
    public int[][] expectedTokenSequences;
    public String[] tokenImage;
    protected String eol = System.getProperty("line.separator", "\n");

    public ParseException(Token currentTokenVal, int[][] expectedTokenSequencesVal, String[] tokenImageVal) {
        super("");
        this.specialConstructor = true;
        this.currentToken = currentTokenVal;
        this.expectedTokenSequences = expectedTokenSequencesVal;
        this.tokenImage = tokenImageVal;
    }

    public ParseException() {
        this.specialConstructor = false;
    }

    public ParseException(String message) {
        super(message);
        this.specialConstructor = false;
    }

    public String getMessage() {
        if (!this.specialConstructor) {
            return super.getMessage();
        }
        StringBuilder expected = new StringBuilder();
        int maxSize = 0;
        int[][] nArray = this.expectedTokenSequences;
        int n = this.expectedTokenSequences.length;
        int n2 = 0;
        while (n2 < n) {
            int[] expectedTokenSequence = nArray[n2];
            if (maxSize < expectedTokenSequence.length) {
                maxSize = expectedTokenSequence.length;
            }
            int j = 0;
            while (j < expectedTokenSequence.length) {
                expected.append(this.tokenImage[expectedTokenSequence[j]]);
                expected.append(' ');
                ++j;
            }
            if (expectedTokenSequence[expectedTokenSequence.length - 1] != 0) {
                expected.append("...");
            }
            expected.append(this.eol);
            expected.append("    ");
            ++n2;
        }
        StringBuilder retval = new StringBuilder("Encountered \"");
        Token tok = this.currentToken.next;
        int i = 0;
        while (i < maxSize) {
            if (i != 0) {
                retval.append(" ");
            }
            if (tok.kind == 0) {
                retval.append(this.tokenImage[0]);
                break;
            }
            retval.append(this.add_escapes(tok.image));
            tok = tok.next;
            ++i;
        }
        retval.append("\" at line ");
        retval.append(this.currentToken.next.beginLine);
        retval.append(", column ");
        retval.append(this.currentToken.next.beginColumn);
        retval.append(".");
        retval.append(this.eol);
        if (this.expectedTokenSequences.length == 1) {
            retval.append("Was expecting:");
            retval.append(this.eol);
            retval.append("    ");
        } else {
            retval.append("Was expecting one of:");
            retval.append(this.eol);
            retval.append("    ");
        }
        retval.append((CharSequence)expected);
        return retval.toString();
    }

    protected String add_escapes(String str) {
        StringBuffer retval = new StringBuffer();
        int i = 0;
        while (i < str.length()) {
            switch (str.charAt(i)) {
                case '\u0000': {
                    break;
                }
                case '\b': {
                    retval.append("\\b");
                    break;
                }
                case '\t': {
                    retval.append("\\t");
                    break;
                }
                case '\n': {
                    retval.append("\\n");
                    break;
                }
                case '\f': {
                    retval.append("\\f");
                    break;
                }
                case '\r': {
                    retval.append("\\r");
                    break;
                }
                case '\"': {
                    retval.append("\\\"");
                    break;
                }
                case '\'': {
                    retval.append("\\'");
                    break;
                }
                case '\\': {
                    retval.append("\\\\");
                    break;
                }
                default: {
                    char ch = str.charAt(i);
                    if (ch < ' ' || ch > '~') {
                        String s = "0000" + Integer.toString(ch, 16);
                        retval.append("\\u" + s.substring(s.length() - 4, s.length()));
                        break;
                    }
                    retval.append(ch);
                }
            }
            ++i;
        }
        return retval.toString();
    }
}

