/*
 * Decompiled with CFR 0.152.
 */
package gnu.jel;

import gnu.jel.Library;
import gnu.jel.TestingUtils;
import gnu.jel.tests.DoubleObject;
import gnu.jel.tests.IntegerObject;
import gnu.jel.tests.VariableProvider;

public class IntegralDotOperatorTest
extends TestingUtils {
    Library lib;
    Object[] rtp;
    VariableProvider vp;

    public IntegralDotOperatorTest(String name) {
        super(name);
    }

    @Override
    public void setUp() throws Exception {
        Class[] dynamicLib = new Class[1];
        this.rtp = new Object[1];
        this.vp = new VariableProvider();
        Class[] staticLib = new Class[]{Class.forName("java.lang.Math"), this.vp.getClass()};
        this.vp.xvar = 5.0;
        this.vp.strVar = "strVar";
        this.rtp[0] = this.vp;
        dynamicLib[0] = this.vp.getClass();
        Class[] dotLib = new Class[]{Class.forName("java.lang.String"), Class.forName("java.lang.Double"), Class.forName("gnu.jel.reflect.Double"), IntegerObject.class, DoubleObject.class};
        this.lib = new Library(staticLib, dynamicLib, dotLib, null, null);
    }

    public void test1() throws Throwable {
        IntegralDotOperatorTest.simExpression("(\"abc\").length()", 3, null, this.rtp, this.lib, null);
    }

    public void test2() throws Throwable {
        IntegralDotOperatorTest.simExpression("\"abc\".length()", 3, null, this.rtp, this.lib, null);
    }

    public void test3() throws Throwable {
        IntegralDotOperatorTest.simExpression("strVar.length()", 6, null, this.rtp, this.lib, null);
    }

    public void test4() throws Throwable {
        IntegralDotOperatorTest.simExpression("\"abc\".endsWith(\"bc\")", Boolean.TRUE, null, this.rtp, this.lib, null);
    }

    public void test5() throws Throwable {
        IntegralDotOperatorTest.simExpression("\"abc\".compareTo(\"bc\")", -1, null, this.rtp, this.lib, null);
    }

    public void test6() throws Throwable {
        IntegralDotOperatorTest.simExpression("\"abcdbc\".indexOf(\"bc\")", 1, null, this.rtp, this.lib, null);
    }

    public void test7() throws Throwable {
        IntegralDotOperatorTest.simExpression("\"abcdbc\".indexOf(\"abc\".substring(1),2)", 4, null, this.rtp, this.lib, null);
    }

    public void test8() throws Throwable {
        IntegralDotOperatorTest.simError("\"abc\".nomethod()", null, this.lib, 7, null);
    }

    public void test9() throws Throwable {
        IntegralDotOperatorTest.simError("\"abc\".length(666)", null, this.lib, 7, null);
    }

    public void test10() throws Throwable {
        IntegralDotOperatorTest.simError("2.0.doubleValue()", null, this.lib, 4, null);
    }

    public void test11() throws Throwable {
        IntegralDotOperatorTest.simExpression("intObj+1", 556, null, this.rtp, this.lib, null);
    }

    public void test12() throws Throwable {
        IntegralDotOperatorTest.simExpression("(int)intObj", 555, null, this.rtp, this.lib, null);
    }

    public void test13() throws Throwable {
        IntegralDotOperatorTest.simExpression("arr[intObj-554]", 5.0, null, this.rtp, this.lib, null);
    }

    public void test14() throws Throwable {
        IntegralDotOperatorTest.simExpression("arr[max(intObj-554,0)]", 5.0, null, this.rtp, this.lib, null);
    }

    public void test15() throws Throwable {
        IntegralDotOperatorTest.simExpression("arr[max(intObj,0)-554]", 5.0, null, this.rtp, this.lib, null);
    }

    public void test16() throws Throwable {
        IntegralDotOperatorTest.simExpression("arr[byteObj]", 6.0, null, this.rtp, this.lib, null);
    }

    public void test17() throws Throwable {
        IntegralDotOperatorTest.simExpression("byteObj+1.0", 3.0, null, this.rtp, this.lib, null);
    }

    public void test18() throws Throwable {
        IntegralDotOperatorTest.simExpression("arrDoubleJELObj1[0].getValue()+arrDoubleJELObj1[1].getValue()", 3.0, null, this.rtp, this.lib, null);
    }
}

