/*
 * Decompiled with CFR 0.152.
 */
package gnu.kawa.functions;

import gnu.bytecode.PrimType;
import gnu.bytecode.Type;
import gnu.kawa.functions.Arithmetic;
import gnu.mapping.ProcedureN;
import gnu.math.IntNum;

public abstract class ArithOp
extends ProcedureN {
    static final int ADD = 1;
    static final int SUB = 2;
    static final int MUL = 3;
    static final int DIV = 4;
    static final int REM = 5;
    public static final int ASHIFT_GENERAL = 6;
    public static final int ASHIFT_LEFT = 7;
    public static final int ASHIFT_RIGHT = 8;
    public static final int LSHIFT_RIGHT = 9;
    public static final int AND = 10;
    public static final int IOR = 11;
    public static final int XOR = 12;
    public static final int NOT = 13;

    public ArithOp(String name) {
        super(name);
    }

    public Object defaultResult() {
        return IntNum.zero();
    }

    public boolean isSideEffectFree() {
        return true;
    }

    public static int classify(Type type) {
        boolean kind = false;
        if (type instanceof PrimType) {
            char sig = type.getSignature().charAt(0);
            if (sig == 'V' || sig == 'Z' || sig == 'C') {
                return 0;
            }
            if (sig == 'D' || sig == 'F') {
                return 3;
            }
            return 4;
        }
        if (type.isSubtype(Arithmetic.typeIntNum)) {
            return 4;
        }
        if (type.isSubtype(Arithmetic.typeDFloNum)) {
            return 3;
        }
        if (type.isSubtype(Arithmetic.typeRealNum)) {
            return 2;
        }
        if (type.isSubtype(Arithmetic.typeNumeric)) {
            return 1;
        }
        return 0;
    }
}

