/*
 * Decompiled with CFR 0.152.
 */
package gnu.expr;

import gnu.expr.ModuleInfo;
import gnu.expr.ModuleManager;
import gnu.mapping.WrappedException;
import java.util.WeakHashMap;

public class ModuleContext {
    static ModuleContext global = new ModuleContext(ModuleManager.instance);
    ModuleManager manager;
    public static int IN_HTTP_SERVER = 1;
    public static int IN_SERVLET = 2;
    int flags;
    private static WeakHashMap<Class, Object> table = new WeakHashMap();

    public int getFlags() {
        return this.flags;
    }

    public void setFlags(int flags) {
        this.flags = flags;
    }

    public void addFlags(int flags) {
        this.flags |= flags;
    }

    public ModuleContext(ModuleManager manager) {
        this.manager = manager;
    }

    public static ModuleContext getContext() {
        return global;
    }

    public ModuleManager getManager() {
        return this.manager;
    }

    public Object findInstance(ModuleInfo info) {
        Class clas;
        try {
            clas = info.getModuleClass();
        }
        catch (ClassNotFoundException ex) {
            String cname = info.getClassName();
            throw new WrappedException("cannot find module " + cname, ex);
        }
        return this.findInstance(clas);
    }

    public Object searchInstance(Class clas) {
        return table.get(clas);
    }

    public Object findInstance(Class clas) {
        Object inst = table.get(clas);
        if (inst == null) {
            try {
                try {
                    inst = clas.getDeclaredField("$instance").get(null);
                }
                catch (NoSuchFieldException ex) {
                    inst = clas.newInstance();
                }
            }
            catch (Throwable ex) {
                throw new WrappedException("exception while initializing module " + clas.getName(), ex);
            }
            this.setInstance(inst);
        }
        return inst;
    }

    public void setInstance(Object instance) {
        table.put(instance.getClass(), instance);
    }

    public ModuleInfo findFromInstance(Object instance) {
        Class<?> instanceClass = instance.getClass();
        ModuleInfo info = ModuleManager.findWithClass(instanceClass);
        this.setInstance(instance);
        return info;
    }

    public void clear() {
        table.clear();
    }
}

