/*
 * Decompiled with CFR 0.152.
 */
package gnu.text;

import gnu.text.Path;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;

public class LineBufferedReader
extends Reader {
    protected Reader in;
    public static final int BUFFER_SIZE = 8192;
    public char[] buffer;
    public int pos;
    public int limit;
    int highestPos;
    public char readState = (char)10;
    private int flags;
    private static final int CONVERT_CR = 1;
    private static final int USER_BUFFER = 2;
    private static final int PREV_WAS_CR = 4;
    private static final int DONT_KEEP_FULL_LINES = 8;
    private int lineStartPos;
    Path path;
    protected int lineNumber;
    protected int readAheadLimit = 0;
    protected int markPos;

    @Override
    public void close() throws IOException {
        this.in.close();
    }

    public char getReadState() {
        return this.readState;
    }

    public void setKeepFullLines(boolean keep) {
        this.flags = keep ? (this.flags &= 0xFFFFFFF7) : (this.flags |= 8);
    }

    public final boolean getConvertCR() {
        return (this.flags & 1) != 0;
    }

    public final void setConvertCR(boolean convertCR) {
        this.flags = convertCR ? (this.flags |= 1) : (this.flags &= 0xFFFFFFFE);
    }

    public LineBufferedReader(InputStream in) {
        this.in = new InputStreamReader(in);
    }

    public LineBufferedReader(Reader in) {
        this.in = in;
    }

    public void lineStart(boolean revisited) throws IOException {
    }

    public int fill(int len) throws IOException {
        return this.in.read(this.buffer, this.pos, len);
    }

    private void clearMark() {
        int i;
        this.readAheadLimit = 0;
        int n = i = this.lineStartPos < 0 ? 0 : this.lineStartPos;
        while (++i < this.pos) {
            char ch = this.buffer[i - 1];
            if (ch != '\n' && (ch != '\r' || this.getConvertCR() && this.buffer[i] == '\n')) continue;
            ++this.lineNumber;
            this.lineStartPos = i;
        }
    }

    public void setBuffer(char[] buffer) throws IOException {
        if (buffer == null) {
            if (this.buffer != null) {
                buffer = new char[this.buffer.length];
                System.arraycopy(this.buffer, 0, buffer, 0, this.buffer.length);
                this.buffer = buffer;
            }
            this.flags &= 0xFFFFFFFD;
        } else {
            if (this.limit - this.pos > buffer.length) {
                throw new IOException("setBuffer - too short");
            }
            this.flags |= 2;
            this.reserve(buffer, 0);
        }
    }

    private void reserve(char[] buffer, int reserve) throws IOException {
        int saveStart;
        if ((reserve += this.limit) <= buffer.length) {
            saveStart = 0;
        } else {
            saveStart = this.pos;
            if (this.readAheadLimit > 0 && this.markPos < this.pos) {
                if (this.pos - this.markPos > this.readAheadLimit || (this.flags & 2) != 0 && reserve - this.markPos > buffer.length) {
                    this.clearMark();
                } else {
                    saveStart = this.markPos;
                }
            }
            if ((reserve -= buffer.length) > saveStart || saveStart > this.lineStartPos && (this.flags & 8) == 0) {
                if (reserve <= this.lineStartPos && saveStart > this.lineStartPos) {
                    saveStart = this.lineStartPos;
                } else if ((this.flags & 2) != 0) {
                    saveStart -= saveStart - reserve >> 2;
                } else {
                    if (this.lineStartPos >= 0) {
                        saveStart = this.lineStartPos;
                    }
                    buffer = new char[2 * buffer.length];
                }
            }
            this.lineStartPos -= saveStart;
            this.limit -= saveStart;
            this.markPos -= saveStart;
            this.pos -= saveStart;
            this.highestPos -= saveStart;
        }
        if (this.limit > 0) {
            System.arraycopy(this.buffer, saveStart, buffer, 0, this.limit);
        }
        this.buffer = buffer;
    }

    @Override
    public int read() throws IOException {
        char ch;
        int prev = this.pos > 0 ? this.buffer[this.pos - 1] : ((this.flags & 4) != 0 ? 13 : (this.lineStartPos >= 0 ? 10 : 0));
        if (prev == 13 || prev == 10) {
            boolean revisited;
            if (this.lineStartPos < this.pos && (this.readAheadLimit == 0 || this.pos <= this.markPos)) {
                this.lineStartPos = this.pos;
                ++this.lineNumber;
            }
            boolean bl = revisited = this.pos < this.highestPos;
            if (prev != 10 || (this.pos <= 1 ? (this.flags & 4) == 0 : this.buffer[this.pos - 2] != '\r')) {
                this.lineStart(revisited);
            }
            if (!revisited) {
                this.highestPos = this.pos + 1;
            }
        }
        if (this.pos >= this.limit) {
            int readCount;
            if (this.buffer == null) {
                this.buffer = new char[8192];
            } else if (this.limit == this.buffer.length) {
                this.reserve(this.buffer, 1);
            }
            if (this.pos == 0) {
                this.flags = prev == 13 ? (this.flags |= 4) : (this.flags &= 0xFFFFFFFB);
            }
            if ((readCount = this.fill(this.buffer.length - this.pos)) <= 0) {
                return -1;
            }
            this.limit += readCount;
        }
        if ((ch = this.buffer[this.pos++]) == '\n') {
            if (prev == 13) {
                if (this.lineStartPos == this.pos - 1) {
                    --this.lineNumber;
                    --this.lineStartPos;
                }
                if (this.getConvertCR()) {
                    return this.read();
                }
            }
        } else if (ch == '\r' && this.getConvertCR()) {
            return 10;
        }
        return ch;
    }

    @Override
    public int read(char[] cbuf, int off, int len) throws IOException {
        int ch = this.pos >= this.limit ? 0 : (this.pos > 0 ? this.buffer[this.pos - 1] : ((this.flags & 4) != 0 || this.lineStartPos >= 0 ? 10 : 0));
        int to_do = len;
        while (to_do > 0) {
            if (this.pos >= this.limit || ch == 10 || ch == 13) {
                if (this.pos >= this.limit && to_do < len) {
                    return len - to_do;
                }
                ch = this.read();
                if (ch < 0) {
                    return (len -= to_do) <= 0 ? -1 : len;
                }
                cbuf[off++] = (char)ch;
                --to_do;
                continue;
            }
            int lim = this.limit;
            int p = this.pos;
            if (to_do < lim - p) {
                lim = p + to_do;
            }
            while (p < lim && (ch = this.buffer[p]) != 10 && ch != 13) {
                cbuf[off++] = (char)ch;
                ++p;
            }
            to_do -= p - this.pos;
            this.pos = p;
        }
        return len;
    }

    public Path getPath() {
        return this.path;
    }

    public void setPath(Path path) {
        this.path = path;
    }

    public String getName() {
        return this.path == null ? null : this.path.toString();
    }

    public void setName(Object name) {
        this.setPath(Path.valueOf(name));
    }

    public int getLineNumber() {
        int lineno = this.lineNumber;
        if (this.readAheadLimit == 0) {
            char prev;
            if (this.pos > 0 && this.pos > this.lineStartPos && ((prev = this.buffer[this.pos - 1]) == '\n' || prev == '\r')) {
                ++lineno;
            }
        } else {
            lineno += LineBufferedReader.countLines(this.buffer, this.lineStartPos < 0 ? 0 : this.lineStartPos, this.pos);
        }
        return lineno;
    }

    public void setLineNumber(int lineNumber) {
        this.lineNumber += lineNumber - this.getLineNumber();
    }

    public void incrLineNumber(int lineDelta, int lineStartPos) {
        this.lineNumber += lineDelta;
        this.lineStartPos = lineStartPos;
    }

    public int getColumnNumber() {
        int start;
        char prev;
        if (this.pos > 0 && ((prev = this.buffer[this.pos - 1]) == '\n' || prev == '\r')) {
            return 0;
        }
        if (this.readAheadLimit <= 0) {
            return this.pos - this.lineStartPos;
        }
        int i = start = this.lineStartPos < 0 ? 0 : this.lineStartPos;
        while (i < this.pos) {
            char ch;
            if ((ch = this.buffer[i++]) != '\n' && ch != '\r') continue;
            start = i;
        }
        int col = this.pos - start;
        if (this.lineStartPos < 0) {
            col -= this.lineStartPos;
        }
        return col;
    }

    @Override
    public boolean markSupported() {
        return true;
    }

    @Override
    public synchronized void mark(int readAheadLimit) {
        if (this.readAheadLimit > 0) {
            this.clearMark();
        }
        this.readAheadLimit = readAheadLimit;
        this.markPos = this.pos;
    }

    @Override
    public void reset() throws IOException {
        if (this.readAheadLimit <= 0) {
            throw new IOException("mark invalid");
        }
        if (this.pos > this.highestPos) {
            this.highestPos = this.pos;
        }
        this.pos = this.markPos;
        this.readAheadLimit = 0;
    }

    public void readLine(StringBuffer sbuf, char mode) throws IOException {
        int ch;
        while ((ch = this.read()) >= 0) {
            int start = --this.pos;
            while (this.pos < this.limit) {
                if ((ch = this.buffer[this.pos++]) != 13 && ch != 10) continue;
                sbuf.append(this.buffer, start, this.pos - 1 - start);
                if (mode == 'P') {
                    --this.pos;
                    return;
                }
                if (this.getConvertCR() || ch == 10) {
                    if (mode != 'I') {
                        sbuf.append('\n');
                    }
                } else {
                    if (mode != 'I') {
                        sbuf.append('\r');
                    }
                    if ((ch = this.read()) == 10) {
                        if (mode != 'I') {
                            sbuf.append('\n');
                        }
                    } else if (ch >= 0) {
                        this.unread_quick();
                    }
                }
                return;
            }
            sbuf.append(this.buffer, start, this.pos - start);
        }
        return;
    }

    public String readLine() throws IOException {
        int ch = this.read();
        if (ch < 0) {
            return null;
        }
        if (ch == 13 || ch == 10) {
            return "";
        }
        int start = this.pos - 1;
        while (this.pos < this.limit) {
            if ((ch = this.buffer[this.pos++]) != 13 && ch != 10) continue;
            int end = this.pos - 1;
            if (ch != 10 && !this.getConvertCR()) {
                if (this.pos >= this.limit) {
                    --this.pos;
                    break;
                }
                if (this.buffer[this.pos] == '\n') {
                    ++this.pos;
                }
            }
            return new String(this.buffer, start, end - start);
        }
        StringBuffer sbuf = new StringBuffer(100);
        sbuf.append(this.buffer, start, this.pos - start);
        this.readLine(sbuf, 'I');
        return sbuf.toString();
    }

    public int skip(int n) throws IOException {
        if (n < 0) {
            int to_do;
            for (to_do = -n; to_do > 0 && this.pos > 0; --to_do) {
                this.unread();
            }
            return n + to_do;
        }
        int to_do = n;
        int ch = this.pos >= this.limit ? 0 : (this.pos > 0 ? this.buffer[this.pos - 1] : ((this.flags & 4) != 0 || this.lineStartPos >= 0 ? 10 : 0));
        while (to_do > 0) {
            if (ch == 10 || ch == 13 || this.pos >= this.limit) {
                ch = this.read();
                if (ch < 0) {
                    return n - to_do;
                }
                --to_do;
                continue;
            }
            int lim = this.limit;
            int p = this.pos;
            if (to_do < lim - p) {
                lim = p + to_do;
            }
            while (p < lim && (ch = this.buffer[p]) != 10 && ch != 13) {
                ++p;
            }
            to_do -= p - this.pos;
            this.pos = p;
        }
        return n;
    }

    @Override
    public boolean ready() throws IOException {
        return this.pos < this.limit || this.in.ready();
    }

    public final void skip_quick() throws IOException {
        ++this.pos;
    }

    public void skip() throws IOException {
        this.read();
    }

    static int countLines(char[] buffer, int start, int limit) {
        int count = 0;
        int prev = 0;
        for (int i = start; i < limit; ++i) {
            int ch = buffer[i];
            if (ch == 10 && prev != 13 || ch == 13) {
                ++count;
            }
            prev = ch;
        }
        return count;
    }

    public void skipRestOfLine() throws IOException {
        int c;
        do {
            if ((c = this.read()) < 0) {
                return;
            }
            if (c != 13) continue;
            c = this.read();
            if (c < 0 || c == 10) break;
            this.unread();
            break;
        } while (c != 10);
    }

    public void unread() throws IOException {
        if (this.pos == 0) {
            throw new IOException("unread too much");
        }
        --this.pos;
        char ch = this.buffer[this.pos];
        if (ch == '\n' || ch == '\r') {
            if (this.pos > 0 && ch == '\n' && this.getConvertCR() && this.buffer[this.pos - 1] == '\r') {
                --this.pos;
            }
            if (this.pos < this.lineStartPos) {
                --this.lineNumber;
                int i = this.pos;
                while (i > 0) {
                    if ((ch = this.buffer[--i]) != '\r' && ch != '\n') continue;
                    ++i;
                    break;
                }
                this.lineStartPos = i;
            }
        }
    }

    public void unread_quick() {
        --this.pos;
    }

    public int peek() throws IOException {
        int ch;
        if (this.pos < this.limit && this.pos > 0 && (ch = this.buffer[this.pos - 1]) != 10 && ch != 13) {
            ch = this.buffer[this.pos];
            if (ch == 13 && this.getConvertCR()) {
                ch = 10;
            }
            return ch;
        }
        int c = this.read();
        if (c >= 0) {
            this.unread_quick();
        }
        return c;
    }
}

