/*
 * Decompiled with CFR 0.152.
 */
package gnu.mapping;

import gnu.lists.ByteVector;
import gnu.mapping.InPort;
import gnu.text.Path;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;

public class BinaryInPort
extends InPort {
    private InputStream strm;
    private byte[] bbuffer;
    private int bpos;
    private int blimit;

    public BinaryInPort(InputStream strm, Path path) {
        super((Reader)null, path);
        this.strm = strm;
        try {
            this.setBuffer(new char[2048]);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.bbuffer = new byte[8192];
    }

    public BinaryInPort(byte[] buffer, int length, Path path) {
        super((Reader)null, path);
        try {
            this.setBuffer(new char[2048]);
        }
        catch (IOException ex) {
            // empty catch block
        }
        this.bbuffer = buffer;
        this.blimit = length;
    }

    protected int fill(int len) throws IOException {
        if (!this.bfill()) {
            return -1;
        }
        int n = 0;
        while (n < len && this.bpos < this.blimit) {
            this.buffer[this.pos + n++] = (char)(this.bbuffer[this.bpos++] & 0xFF);
        }
        return n;
    }

    private boolean bfill() throws IOException {
        while (this.bpos >= this.blimit) {
            if (this.strm == null) {
                return false;
            }
            int n = this.strm.read(this.bbuffer, 0, this.bbuffer.length);
            this.bpos = 0;
            if (n < 0) {
                this.blimit = 0;
                return false;
            }
            this.blimit = n;
        }
        return true;
    }

    public int readByte() throws IOException {
        if (this.pos < this.limit) {
            return this.read();
        }
        if (this.bfill()) {
            return this.bbuffer[this.bpos++] & 0xFF;
        }
        return -1;
    }

    public int peekByte() throws IOException {
        if (this.pos < this.limit) {
            return this.peek();
        }
        if (this.bfill()) {
            return this.bbuffer[this.bpos] & 0xFF;
        }
        return -1;
    }

    public int readBytes(byte[] buf, int offset, int count) throws IOException {
        int rcount = 0;
        while (this.pos < this.limit) {
            if (rcount == count) {
                return rcount;
            }
            int r = this.read();
            if (r < 0) {
                return rcount > 0 ? rcount : -1;
            }
            buf[offset + rcount++] = (byte)r;
        }
        if (rcount > 0) {
            return rcount;
        }
        if (!this.bfill()) {
            return -1;
        }
        int n = this.blimit - this.bpos;
        if (n > count) {
            n = count;
        }
        System.arraycopy(this.bbuffer, this.bpos, buf, offset, n);
        this.bpos += n;
        return n;
    }

    public int readByteVector(ByteVector bvector, int offset, int count) throws IOException {
        int rcount = 0;
        while (this.pos < this.limit) {
            if (rcount == count) {
                return rcount;
            }
            int r = this.read();
            if (r < 0) {
                return rcount > 0 ? rcount : -1;
            }
            bvector.setByteAt(offset + rcount++, (byte)r);
        }
        if (rcount > 0) {
            return rcount;
        }
        if (!this.bfill()) {
            return -1;
        }
        int n = this.blimit - this.bpos;
        if (n > count) {
            n = count;
        }
        bvector.copyFrom(this.bbuffer, this.bpos, offset, n);
        this.bpos += n;
        return n;
    }

    public void close() throws IOException {
        if (this.strm != null) {
            this.strm.close();
        }
        this.strm = null;
        this.bbuffer = null;
        super.close();
    }

    protected boolean sourceReady() throws IOException {
        return this.bpos < this.blimit || this.strm != null && this.strm.available() > 0;
    }

    public static BinaryInPort openFile(Object fname) throws IOException {
        return (BinaryInPort)InPort.openFile(fname, Boolean.FALSE);
    }
}

