/*
 * Decompiled with CFR 0.152.
 */
package gnu.xml;

import gnu.lists.AbstractSequence;
import gnu.lists.CharSeq;
import gnu.lists.Consumable;
import gnu.lists.Consumer;
import gnu.lists.PositionConsumer;
import gnu.lists.PrintConsumer;
import gnu.lists.SeqPosition;
import gnu.lists.UnescapedData;
import gnu.text.Char;
import gnu.xml.NamespaceBinding;
import gnu.xml.XName;
import java.io.OutputStream;
import java.io.StringWriter;
import java.io.Writer;

public class XMLPrinter
extends PrintConsumer
implements PositionConsumer {
    boolean inAttribute = false;
    boolean inStartTag = false;
    boolean canonicalize = true;
    boolean htmlCompat = true;
    public boolean escapeText = true;
    boolean isHtml = false;
    boolean undeclareNamespaces = false;
    Object style;
    NamespaceBinding namespaceBindings = NamespaceBinding.predefinedXML;
    NamespaceBinding[] namespaceSaveStack = new NamespaceBinding[20];
    int groupNesting;
    private static final int WORD = -2;
    int prev = 32;
    static final String HtmlEmptyTags = "/area/base/basefont/br/col/frame/hr/img/input/isindex/link/meta/para/";

    public XMLPrinter(Writer writer, boolean bl) {
        super(writer, bl);
    }

    public XMLPrinter(Consumer consumer, boolean bl) {
        super(consumer, bl);
    }

    public XMLPrinter(PrintConsumer printConsumer, boolean bl) {
        super(printConsumer, bl);
    }

    public XMLPrinter(OutputStream outputStream, boolean bl) {
        super(outputStream, bl);
    }

    public XMLPrinter(Consumer consumer) {
        super(consumer, false);
    }

    public XMLPrinter(Writer writer) {
        super(writer);
    }

    public XMLPrinter(PrintConsumer printConsumer) {
        super(printConsumer, false);
    }

    public XMLPrinter(OutputStream outputStream) {
        super(outputStream, false);
    }

    public static XMLPrinter make(Consumer consumer, Object object2) {
        XMLPrinter xMLPrinter = new XMLPrinter(consumer);
        xMLPrinter.setStyle(object2);
        return xMLPrinter;
    }

    public static String toString(Object object2) {
        StringWriter stringWriter = new StringWriter();
        new XMLPrinter(stringWriter).writeObject(object2);
        return stringWriter.toString();
    }

    public void setStyle(Object object2) {
        this.style = object2;
        this.htmlCompat = false;
        if ("html".equals(object2)) {
            this.isHtml = true;
            this.htmlCompat = true;
        }
        if ("xhtml".equals(object2)) {
            this.htmlCompat = true;
        }
        if ("plain".equals(object2)) {
            this.escapeText = false;
        }
    }

    protected static final boolean isWordChar(char c) {
        return Character.isJavaIdentifierPart(c) || c == '-' || c == '+';
    }

    public void writeChar(int n) {
        this.closeTag();
        if (this.prev == -2 && XMLPrinter.isWordChar((char)n)) {
            super.write(32);
        }
        if (!this.escapeText) {
            super.write((char)n);
        } else if (!(n != 60 || this.isHtml && this.inAttribute)) {
            super.write("&lt;");
        } else if (n == 62) {
            super.write("&gt;");
        } else if (n == 38) {
            super.write("&amp;");
        } else if (n == 34 && this.inAttribute) {
            super.write("&quot;");
        } else if (n >= 127) {
            super.write("&#" + n + ";");
        } else {
            super.write((char)n);
        }
        this.prev = n;
    }

    private void startWord() {
        this.closeTag();
        if (this.prev == -2 || XMLPrinter.isWordChar((char)this.prev)) {
            super.write(32);
        }
        this.prev = -2;
    }

    public void writeBoolean(boolean bl) {
        this.startWord();
        super.print(bl);
    }

    private void closeTag() {
        if (this.inStartTag && !this.inAttribute) {
            super.write(62);
            this.inStartTag = false;
            this.prev = 62;
        }
    }

    protected void startNumber() {
        this.startWord();
    }

    public void beginGroup(String string, Object object2) {
        NamespaceBinding[] namespaceBindingArray;
        this.closeTag();
        super.write(60);
        super.write(string);
        NamespaceBinding namespaceBinding = null;
        this.namespaceSaveStack[this.groupNesting++] = this.namespaceBindings;
        if (object2 instanceof XName) {
            String string2;
            namespaceBinding = ((XName)object2).namespaceNodes;
            namespaceBindingArray = NamespaceBinding.commonAncestor(namespaceBinding, this.namespaceBindings);
            NamespaceBinding namespaceBinding2 = namespaceBinding;
            while (namespaceBinding2 != namespaceBindingArray) {
                String string3 = namespaceBinding2.uri;
                string2 = namespaceBinding2.prefix;
                if (string3 != this.namespaceBindings.resolve(string2)) {
                    super.write(32);
                    if (string2 == null) {
                        super.write("xmlns");
                    } else {
                        super.write("xmlns:");
                        super.write(string2);
                    }
                    super.write("=\"");
                    this.inAttribute = true;
                    if (string3 != null) {
                        this.writeChars(string3);
                    }
                    this.inAttribute = false;
                    super.write(34);
                }
                namespaceBinding2 = namespaceBinding2.next;
            }
            if (this.undeclareNamespaces) {
                namespaceBinding2 = this.namespaceBindings;
                while (namespaceBinding2 != namespaceBindingArray) {
                    string2 = namespaceBinding2.prefix;
                    if (namespaceBinding2.uri != null && namespaceBinding.resolve(string2) == null) {
                        super.write(32);
                        if (string2 == null) {
                            super.write("xmlns");
                        } else {
                            super.write("xmlns:");
                            super.write(string2);
                        }
                        super.write("=\"\"");
                    }
                    namespaceBinding2 = namespaceBinding2.next;
                }
            }
            this.namespaceBindings = namespaceBinding;
        }
        if (this.groupNesting >= this.namespaceSaveStack.length) {
            namespaceBindingArray = new NamespaceBinding[2 * this.groupNesting];
            System.arraycopy(this.namespaceSaveStack, 0, namespaceBindingArray, 0, this.groupNesting);
            this.namespaceSaveStack = namespaceBindingArray;
        }
        this.inStartTag = true;
        if (this.isHtml && ("script".equals(string) || "style".equals(string))) {
            this.escapeText = false;
        }
    }

    public static boolean isHtmlEmptyElementTag(String string) {
        int n = HtmlEmptyTags.indexOf(string);
        return n > 0 && HtmlEmptyTags.charAt(n - 1) == '/' && HtmlEmptyTags.charAt(n + string.length()) == '/';
    }

    public void endGroup(String string) {
        if (this.canonicalize && !this.htmlCompat) {
            this.closeTag();
        }
        if (this.inStartTag) {
            super.write(this.isHtml ? (XMLPrinter.isHtmlEmptyElementTag(string) ? ">" : "></" + string + ">") : (this.htmlCompat ? " />" : "/>"));
            this.inStartTag = false;
        } else {
            super.write("</");
            super.write(string);
            super.write(">");
        }
        this.prev = 62;
        if (this.isHtml && !this.escapeText && ("script".equals(string) || "style".equals(string))) {
            this.escapeText = true;
        }
        this.namespaceBindings = this.namespaceSaveStack[--this.groupNesting];
        this.namespaceSaveStack[this.groupNesting] = null;
    }

    public void beginAttribute(String string, Object object2) {
        if (this.inAttribute) {
            super.write(34);
        }
        this.inAttribute = true;
        super.write(32);
        super.write(string);
        super.write("=\"");
        this.prev = 32;
    }

    public void endAttribute() {
        super.write(34);
        this.inAttribute = false;
        this.prev = 32;
    }

    public void writeObject(Object object2) {
        if (object2 instanceof Consumable && !(object2 instanceof UnescapedData)) {
            ((Consumable)object2).consume(this);
            return;
        }
        if (object2 instanceof SeqPosition) {
            SeqPosition seqPosition = (SeqPosition)object2;
            seqPosition.sequence.consumeNext(seqPosition.ipos, this);
            return;
        }
        this.closeTag();
        if (object2 instanceof UnescapedData) {
            super.write(((UnescapedData)object2).getData());
        } else if (object2 instanceof Char) {
            this.writeChar(((Char)object2).intValue());
        } else if (object2 instanceof String || object2 instanceof CharSeq) {
            this.writeChars(object2.toString());
        } else {
            this.startWord();
            this.prev = 32;
            this.writeChars(object2 == null ? "(null)" : object2.toString());
            this.prev = -2;
        }
    }

    public boolean ignoring() {
        return false;
    }

    public void writeChars(String string) {
        this.closeTag();
        int n = string.length();
        for (int i = 0; i < n; ++i) {
            this.writeChar(string.charAt(i));
        }
    }

    public void write(char[] cArray, int n, int n2) {
        int n3;
        this.closeTag();
        if (n2 <= 0) {
            return;
        }
        int n4 = this.prev;
        if (this.prev == -2) {
            n3 = cArray[n++];
            this.writeChar(n3);
            n4 = n3;
            --n2;
        }
        int n5 = n + n2;
        int n6 = 0;
        while (n < n5) {
            if ((n4 = (n3 = cArray[n++])) >= 127 || n4 == 60 || n4 == 62 || n4 == 38 || n4 == 34 && this.inAttribute) {
                if (n6 > 0) {
                    super.write(cArray, n - 1 - n6, n6);
                }
                this.writeChar(n3);
                n6 = 0;
                continue;
            }
            ++n6;
        }
        if (n6 > 0) {
            super.write(cArray, n5 - n6, n6);
        }
    }

    public boolean writePosition(AbstractSequence abstractSequence, int n) {
        abstractSequence.consumeNext(n, this);
        return true;
    }

    public boolean consume(SeqPosition seqPosition) {
        throw new Error("not implemented consume(TreePosition)");
    }
}

