/*
 * Decompiled with CFR 0.152.
 */
package gnu.kawa.xml;

import gnu.lists.Consumer;
import gnu.text.LineBufferedReader;
import gnu.text.SourceMessages;
import gnu.xml.NamespaceResolver;
import gnu.xml.ParsedXMLToConsumer;
import gnu.xml.XMLParserChar;
import java.io.IOException;
import java.net.URL;

public class XMLParser
extends XMLParserChar {
    SourceMessages messages;

    public XMLParser(LineBufferedReader lineBufferedReader, SourceMessages sourceMessages, Consumer consumer) throws IOException {
        this(lineBufferedReader, new NamespaceResolver(consumer), sourceMessages, consumer);
    }

    private XMLParser(LineBufferedReader lineBufferedReader, NamespaceResolver namespaceResolver, SourceMessages sourceMessages, Consumer consumer) throws IOException {
        super(null, 0, 0, new ParsedXMLToConsumer(namespaceResolver));
        this.in = lineBufferedReader;
        this.messages = sourceMessages;
        namespaceResolver.setParser(this);
    }

    public XMLParser(LineBufferedReader lineBufferedReader, Consumer consumer, SourceMessages sourceMessages) throws IOException {
        super(null, 0, 0, new ParsedXMLToConsumer(consumer));
        this.in = lineBufferedReader;
        this.messages = sourceMessages;
    }

    public XMLParser(URL uRL, SourceMessages sourceMessages, Consumer consumer) throws IOException {
        this(uRL, new NamespaceResolver(consumer), sourceMessages, consumer);
    }

    private XMLParser(URL uRL, NamespaceResolver namespaceResolver, SourceMessages sourceMessages, Consumer consumer) throws IOException {
        this(uRL, (Consumer)namespaceResolver, sourceMessages);
        namespaceResolver.setParser(this);
    }

    public XMLParser(URL uRL, Consumer consumer, SourceMessages sourceMessages) throws IOException {
        super(null, 0, 0, new ParsedXMLToConsumer(consumer));
        LineBufferedReader lineBufferedReader = new LineBufferedReader(uRL.openConnection().getInputStream());
        this.in = lineBufferedReader;
        lineBufferedReader.setName(uRL.toString());
        this.messages = sourceMessages;
    }

    public int fill(char[] cArray, int n, int n2) {
        LineBufferedReader lineBufferedReader = (LineBufferedReader)this.in;
        int n3 = n2 - n;
        try {
            int n4;
            if (n3 > 0) {
                n4 = lineBufferedReader.skip(n - lineBufferedReader.pos);
                lineBufferedReader.mark(n3 + 1);
                n4 = lineBufferedReader.skip(n3);
            } else {
                lineBufferedReader.skip(n2 - lineBufferedReader.pos);
            }
            n4 = lineBufferedReader.read();
            if (n4 <= 0) {
                return -1;
            }
            if (n3 > 0) {
                lineBufferedReader.reset();
                lineBufferedReader.skip(n3);
            } else {
                lineBufferedReader.unread_quick();
            }
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException.getMessage());
        }
        this.pos = lineBufferedReader.pos;
        this.buffer = lineBufferedReader.buffer;
        return lineBufferedReader.limit - lineBufferedReader.pos;
    }

    public void error(char c, String string) {
        LineBufferedReader lineBufferedReader = (LineBufferedReader)this.in;
        try {
            lineBufferedReader.skip(this.pos - lineBufferedReader.pos);
        }
        catch (Exception exception) {
            // empty catch block
        }
        String string2 = lineBufferedReader.getName();
        if (string2 != null && string2.startsWith("file:")) {
            string2 = string2.substring(5);
        }
        int n = lineBufferedReader.getLineNumber();
        int n2 = lineBufferedReader.getColumnNumber();
        this.messages.error(c, string2, n + 1, n2 >= 0 ? n2 + 1 : 0, string);
    }

    public String getName() {
        return ((LineBufferedReader)this.in).getName();
    }

    public int getLineNumber() {
        return ((LineBufferedReader)this.in).getLineNumber();
    }

    public int getColumnNumber() {
        return ((LineBufferedReader)this.in).getColumnNumber();
    }
}

