/*
 * Decompiled with CFR 0.152.
 */
package gnu.bytecode;

import gnu.bytecode.Access;
import gnu.bytecode.Attribute;
import gnu.bytecode.ClassType;
import gnu.bytecode.ClassTypeWriter;
import gnu.bytecode.ConstantPool;
import gnu.bytecode.CpoolClass;
import gnu.bytecode.CpoolUtf8;
import gnu.bytecode.ObjectType;
import java.io.DataOutputStream;
import java.io.IOException;

public class InnerClassesAttr
extends Attribute {
    int count;
    short[] data;

    public InnerClassesAttr(ClassType classType) {
        super("InnerClasses");
        this.addToFrontOf(classType);
    }

    public InnerClassesAttr(short[] sArray, ClassType classType) {
        this(classType);
        this.count = (short)(sArray.length >> 2);
        this.data = sArray;
    }

    public static InnerClassesAttr getFirstInnerClasses(Attribute attribute) {
        while (attribute != null && !(attribute instanceof InnerClassesAttr)) {
            attribute = attribute.next;
        }
        return (InnerClassesAttr)attribute;
    }

    void addClass(CpoolClass cpoolClass, ClassType classType) {
        Object object2;
        int n = 4 * this.count++;
        if (this.data == null) {
            this.data = new short[16];
        } else if (n >= this.data.length) {
            object2 = new short[2 * n];
            System.arraycopy(this.data, 0, object2, 0, n);
            this.data = (short[])object2;
        }
        object2 = classType.constants;
        ClassType classType2 = (ClassType)cpoolClass.getClassType();
        String string = classType2.getSimpleName();
        int n2 = string == null || string.length() == 0 ? 0 : ((ConstantPool)object2).addUtf8((String)string).index;
        this.data[n] = (short)cpoolClass.index;
        ClassType classType3 = classType2.getDeclaringClass();
        this.data[n + 1] = classType3 == null ? (short)0 : (short)((ConstantPool)object2).addClass((ObjectType)classType3).index;
        this.data[n + 2] = (short)n2;
        int n3 = classType2.getModifiers();
        this.data[n + 3] = (short)(n3 &= 0xFFFFFFDF);
    }

    public void assignConstants(ClassType classType) {
        super.assignConstants(classType);
    }

    public int getLength() {
        return 2 + 8 * this.count;
    }

    public void write(DataOutputStream dataOutputStream) throws IOException {
        dataOutputStream.writeShort(this.count);
        for (int i = 0; i < this.count; ++i) {
            dataOutputStream.writeShort(this.data[4 * i]);
            dataOutputStream.writeShort(this.data[4 * i + 1]);
            dataOutputStream.writeShort(this.data[4 * i + 2]);
            dataOutputStream.writeShort(this.data[4 * i + 3]);
        }
    }

    public void print(ClassTypeWriter classTypeWriter) {
        ClassType classType = (ClassType)this.container;
        ConstantPool constantPool = this.data == null ? null : classType.getConstants();
        classTypeWriter.print("Attribute \"");
        classTypeWriter.print(this.getName());
        classTypeWriter.print("\", length:");
        classTypeWriter.print(this.getLength());
        classTypeWriter.print(", count: ");
        classTypeWriter.println(this.count);
        for (int i = 0; i < this.count; ++i) {
            Object object2;
            int n;
            String string;
            int n2 = constantPool == null ? 0 : this.data[4 * i] & 0xFFFF;
            CpoolClass cpoolClass = constantPool == null || n2 == 0 ? null : constantPool.getForcedClass(n2);
            ClassType classType2 = cpoolClass != null && cpoolClass.clas instanceof ClassType ? (ClassType)cpoolClass.clas : null;
            classTypeWriter.print(' ');
            int n3 = n2 == 0 && classType2 != null ? classType2.getModifiers() : this.data[4 * i + 3] & 0xFFFF;
            classTypeWriter.print(Access.toString(n3, 'I'));
            classTypeWriter.print(' ');
            if (n2 == 0 && classType2 != null) {
                string = classType2.getSimpleName();
            } else {
                n = this.data[4 * i + 2] & 0xFFFF;
                if (constantPool == null || n == 0) {
                    string = "(Anonymous)";
                } else {
                    classTypeWriter.printOptionalIndex(n);
                    string = ((CpoolUtf8)constantPool.getForced((int)n, (int)1)).string;
                }
            }
            classTypeWriter.print(string);
            classTypeWriter.print(" = ");
            string = cpoolClass != null ? cpoolClass.getClassName() : "(Unknown)";
            classTypeWriter.print(string);
            classTypeWriter.print("; ");
            if (n2 == 0 && classType2 != null) {
                char c;
                int n4;
                object2 = classType2.getName();
                int n5 = ((String)object2).lastIndexOf(46);
                if (n5 > 0) {
                    object2 = ((String)object2).substring(n5 + 1);
                }
                if ((n4 = ((String)object2).lastIndexOf(36) + 1) < ((String)object2).length() && (c = ((String)object2).charAt(n4)) >= '0' && c <= '9') {
                    classTypeWriter.print("not a member");
                } else {
                    classTypeWriter.print("member of ");
                    classTypeWriter.print(classType.getName());
                }
            } else {
                n = this.data[4 * i + 1] & 0xFFFF;
                if (n == 0) {
                    classTypeWriter.print("not a member");
                } else {
                    classTypeWriter.print("member of ");
                    object2 = constantPool.getForced(n, 7);
                    classTypeWriter.print(((CpoolClass)object2).getStringName());
                }
            }
            classTypeWriter.println();
        }
    }
}

