/*
 * Decompiled with CFR 0.152.
 */
package gnu.bytecode;

import gnu.bytecode.ArrayType;
import gnu.bytecode.CodeAttr;
import gnu.bytecode.Field;
import gnu.bytecode.Filter;
import gnu.bytecode.Method;
import gnu.bytecode.Type;
import java.util.List;
import java.util.Vector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ObjectType
extends Type {
    static final int ADD_FIELDS_DONE = 1;
    static final int ADD_METHODS_DONE = 2;
    static final int ADD_MEMBERCLASSES_DONE = 4;
    static final int ADD_ENCLOSING_DONE = 8;
    static final int EXISTING_CLASS = 16;
    static final int HAS_OUTER_LINK = 32;
    public int flags;

    protected ObjectType() {
        this.size = 4;
    }

    public ObjectType(String string) {
        this.this_name = string;
        this.size = 4;
    }

    public final boolean isExisting() {
        Type type = this.getImplementationType();
        if (type instanceof ArrayType) {
            type = ((ArrayType)type).getComponentType();
        }
        if (type == this) {
            return (this.flags & 0x10) != 0;
        }
        return !(type instanceof ObjectType) || ((ObjectType)type).isExisting();
    }

    public final void setExisting(boolean bl) {
        this.flags = bl ? (this.flags |= 0x10) : (this.flags &= 0xFFFFFFEF);
    }

    public String getInternalName() {
        return this.getName().replace('.', '/');
    }

    public static Class getContextClass(String string) throws ClassNotFoundException {
        return Class.forName(string, false, ObjectType.getContextClassLoader());
    }

    public static ClassLoader getContextClassLoader() {
        try {
            return Thread.currentThread().getContextClassLoader();
        }
        catch (SecurityException securityException) {
            return ObjectType.class.getClassLoader();
        }
    }

    @Override
    public Class getReflectClass() {
        block3: {
            try {
                if (this.reflectClass == null) {
                    this.reflectClass = ObjectType.getContextClass(this.getInternalName().replace('/', '.'));
                }
                this.flags |= 0x10;
            }
            catch (ClassNotFoundException classNotFoundException) {
                if ((this.flags & 0x10) == 0) break block3;
                RuntimeException runtimeException = new RuntimeException("no such class: " + this.getName());
                runtimeException.initCause(classNotFoundException);
                throw runtimeException;
            }
        }
        return this.reflectClass;
    }

    @Override
    public Type getImplementationType() {
        return this == nullType ? objectType : (this == toStringType ? javalangStringType : this);
    }

    @Override
    public Type promote() {
        return this == nullType ? objectType : this;
    }

    @Override
    public boolean isInstance(Object object2) {
        if (this == nullType) {
            return object2 == null;
        }
        return super.isInstance(object2);
    }

    public Field getField(String string, int n) {
        return null;
    }

    public Method getMethod(String string, Type[] typeArray) {
        return Type.objectType.getMethod(string, typeArray);
    }

    public final int getMethods(Filter filter, int n, Vector vector, String string) {
        return this.getMethods(filter, n, vector);
    }

    public int getMethods(Filter filter, int n, List<Method> list) {
        return Type.objectType.getMethods(filter, n, list);
    }

    @Override
    public int compare(Type type) {
        return type == nullType ? 0 : -1;
    }

    @Override
    public Object coerceFromObject(Object object2) {
        if (object2 != null) {
            Class<?> clazz;
            if (this == Type.toStringType) {
                return object2.toString();
            }
            Class clazz2 = this.getReflectClass();
            if (!clazz2.isAssignableFrom(clazz = object2.getClass())) {
                throw new ClassCastException("don't know how to coerce " + clazz.getName() + " to " + this.getName());
            }
        }
        return object2;
    }

    @Override
    public void emitCoerceFromObject(CodeAttr codeAttr) {
        if (this == Type.toStringType) {
            codeAttr.emitDup();
            codeAttr.emitIfNull();
            codeAttr.emitPop(1);
            codeAttr.emitPushNull();
            codeAttr.emitElse();
            codeAttr.emitInvokeVirtual(Type.toString_method);
            codeAttr.emitFi();
        } else if (this != Type.objectType) {
            codeAttr.emitCheckcast(this);
        }
    }
}

