/*
 * Decompiled with CFR 0.152.
 */
package gnu.expr;

import gnu.bytecode.ArrayClassLoader;
import gnu.bytecode.ClassType;
import gnu.bytecode.Field;
import gnu.bytecode.ObjectType;
import gnu.bytecode.Type;
import gnu.expr.ClassExp;
import gnu.expr.Compilation;
import gnu.expr.Declaration;
import gnu.expr.ExpWalker;
import gnu.expr.Expression;
import gnu.expr.LambdaExp;
import gnu.expr.Language;
import gnu.expr.ModuleBody;
import gnu.expr.ModuleInfo;
import gnu.expr.QuoteExp;
import gnu.expr.ReferenceExp;
import gnu.kawa.reflect.FieldLocation;
import gnu.kawa.reflect.StaticFieldLocation;
import gnu.mapping.CallContext;
import gnu.mapping.Environment;
import gnu.mapping.Location;
import gnu.mapping.OutPort;
import gnu.mapping.Symbol;
import gnu.mapping.WrappedException;
import gnu.text.Path;
import gnu.text.SourceMessages;
import gnu.text.SyntaxException;
import java.io.Externalizable;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.OutputStream;
import java.net.URL;
import java.util.zip.CRC32;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;

public class ModuleExp
extends LambdaExp
implements Externalizable {
    public static final int EXPORT_SPECIFIED = 8192;
    public static final int STATIC_SPECIFIED = 16384;
    public static final int NONSTATIC_SPECIFIED = 32768;
    public static final int SUPERTYPE_SPECIFIED = 65536;
    public static final int STATIC_RUN_SPECIFIED = 131072;
    public static final int LAZY_DECLARATIONS = 262144;
    public static final int IMMEDIATE = 524288;
    public static String dumpZipPrefix;
    static int lastZipCounter;
    public static int interactiveCounter;
    public static boolean alwaysCompile;
    ClassType superType;
    ClassType[] interfaces;
    ModuleInfo info;

    public static Class evalToClass(Compilation compilation, URL uRL) throws SyntaxException {
        ModuleExp moduleExp = compilation.getModule();
        SourceMessages sourceMessages = compilation.getMessages();
        try {
            Object object2;
            Object object3;
            Object object4;
            Object object5;
            Object object6;
            compilation.minfo.loadByStages(12);
            if (sourceMessages.seenErrors()) {
                return null;
            }
            ArrayClassLoader arrayClassLoader = compilation.loader;
            if (uRL == null) {
                uRL = Path.currentPath().toURL();
            }
            arrayClassLoader.setResourceContext(uRL);
            ZipOutputStream zipOutputStream = null;
            if (dumpZipPrefix != null) {
                StringBuffer stringBuffer = new StringBuffer(dumpZipPrefix);
                if (interactiveCounter > ++lastZipCounter) {
                    lastZipCounter = interactiveCounter;
                }
                stringBuffer.append(lastZipCounter);
                stringBuffer.append(".zip");
                object6 = new FileOutputStream(stringBuffer.toString());
                zipOutputStream = new ZipOutputStream((OutputStream)object6);
            }
            for (int i = 0; i < compilation.numClasses; ++i) {
                object6 = compilation.classes[i];
                String string = ((Type)object6).getName();
                object5 = ((ClassType)object6).writeToArray();
                arrayClassLoader.addClass(string, (byte[])object5);
                if (zipOutputStream == null) continue;
                object4 = string.replace('.', '/') + ".class";
                object3 = new ZipEntry((String)object4);
                ((ZipEntry)object3).setSize(((Object)object5).length);
                object2 = new CRC32();
                object2.update((byte[])object5);
                ((ZipEntry)object3).setCrc(((CRC32)object2).getValue());
                ((ZipEntry)object3).setMethod(0);
                zipOutputStream.putNextEntry((ZipEntry)object3);
                zipOutputStream.write((byte[])object5);
            }
            if (zipOutputStream != null) {
                zipOutputStream.close();
            }
            Object object7 = null;
            object6 = arrayClassLoader;
            while (((ClassLoader)object6).getParent() instanceof ArrayClassLoader) {
                object6 = (ArrayClassLoader)((ClassLoader)object6).getParent();
            }
            for (int i = 0; i < compilation.numClasses; ++i) {
                object5 = compilation.classes[i];
                object4 = arrayClassLoader.loadClass(((Type)object5).getName());
                ((Type)object5).setReflectClass((Class)object4);
                ((ObjectType)object5).setExisting(true);
                if (i == 0) {
                    object7 = object4;
                    continue;
                }
                if (object6 == arrayClassLoader) continue;
                ((ArrayClassLoader)object6).addClass((Class)object4);
            }
            ModuleInfo moduleInfo = compilation.minfo;
            moduleInfo.setModuleClass((Class)object7);
            compilation.cleanupAfterCompilation();
            int n = moduleInfo.numDependencies;
            for (int i = 0; i < n; ++i) {
                object3 = moduleInfo.dependencies[i];
                object2 = ((ModuleInfo)object3).getModuleClassRaw();
                if (object2 == null) {
                    object2 = ModuleExp.evalToClass(((ModuleInfo)object3).comp, null);
                }
                compilation.loader.addClass((Class)object2);
            }
            return object7;
        }
        catch (IOException iOException) {
            throw new WrappedException("I/O error in lambda eval", iOException);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new WrappedException("class not found in lambda eval", classNotFoundException);
        }
        catch (Throwable throwable) {
            compilation.getMessages().error('f', "internal compile error - caught " + throwable, throwable);
            throw new SyntaxException(sourceMessages);
        }
    }

    public static final boolean evalModule(Environment environment, CallContext callContext, Compilation compilation, URL uRL, OutPort outPort) throws Throwable {
        ModuleExp moduleExp = compilation.getModule();
        Language language = compilation.getLanguage();
        Object object2 = ModuleExp.evalModule1(environment, compilation, uRL, outPort);
        if (object2 == null) {
            return false;
        }
        ModuleExp.evalModule2(environment, callContext, language, moduleExp, object2, outPort);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final Object evalModule1(Environment environment, Compilation compilation, URL uRL, OutPort outPort) throws SyntaxException {
        Class clazz;
        Thread thread2;
        ClassLoader classLoader;
        Compilation compilation2;
        block34: {
            Class clazz2;
            Environment environment2;
            block32: {
                Object var11_15;
                block33: {
                    SourceMessages sourceMessages;
                    block30: {
                        Object var11_13;
                        block31: {
                            block28: {
                                Boolean bl;
                                block29: {
                                    ModuleExp moduleExp;
                                    block26: {
                                        Object var10_10;
                                        block27: {
                                            compilation.getLanguage().resolve(compilation);
                                            moduleExp = compilation.getModule();
                                            environment2 = Environment.getCurrent();
                                            compilation2 = Compilation.getCurrent();
                                            sourceMessages = compilation.getMessages();
                                            classLoader = null;
                                            thread2 = null;
                                            try {
                                                if (environment != environment2) {
                                                    Environment.setCurrent(environment);
                                                }
                                                if (compilation != compilation2) {
                                                    Compilation.setCurrent(compilation);
                                                }
                                                if (alwaysCompile) {
                                                    compilation.mustCompile = true;
                                                }
                                                if (compilation.mustCompile) {
                                                    compilation.addMainClass(moduleExp);
                                                }
                                                compilation.walkModule(moduleExp);
                                                compilation.setState(8);
                                                if (!(outPort != null ? sourceMessages.checkErrors(outPort, 20) : sourceMessages.seenErrors())) break block26;
                                                var10_10 = null;
                                                if (environment == environment2) break block27;
                                            }
                                            catch (Throwable throwable) {
                                                if (environment != environment2) {
                                                    Environment.setCurrent(environment2);
                                                }
                                                if (compilation != compilation2) {
                                                    Compilation.setCurrent(compilation2);
                                                }
                                                if (thread2 != null) {
                                                    thread2.setContextClassLoader(classLoader);
                                                }
                                                throw throwable;
                                            }
                                            Environment.setCurrent(environment2);
                                        }
                                        if (compilation != compilation2) {
                                            Compilation.setCurrent(compilation2);
                                        }
                                        if (thread2 != null) {
                                            thread2.setContextClassLoader(classLoader);
                                        }
                                        return var10_10;
                                    }
                                    if (compilation.mustCompile) break block28;
                                    if (Compilation.debugPrintFinalExpr && outPort != null) {
                                        outPort.println("[Evaluating final module \"" + moduleExp.getName() + "\":");
                                        moduleExp.print(outPort);
                                        outPort.println(']');
                                        outPort.flush();
                                    }
                                    bl = Boolean.TRUE;
                                    if (environment == environment2) break block29;
                                    Environment.setCurrent(environment2);
                                }
                                if (compilation != compilation2) {
                                    Compilation.setCurrent(compilation2);
                                }
                                if (thread2 != null) {
                                    thread2.setContextClassLoader(classLoader);
                                }
                                return bl;
                            }
                            clazz2 = ModuleExp.evalToClass(compilation, uRL);
                            if (clazz2 != null) break block30;
                            var11_13 = null;
                            if (environment == environment2) break block31;
                            Environment.setCurrent(environment2);
                        }
                        if (compilation != compilation2) {
                            Compilation.setCurrent(compilation2);
                        }
                        if (thread2 != null) {
                            thread2.setContextClassLoader(classLoader);
                        }
                        return var11_13;
                    }
                    try {
                        thread2 = Thread.currentThread();
                        classLoader = thread2.getContextClassLoader();
                        thread2.setContextClassLoader(clazz2.getClassLoader());
                    }
                    catch (Throwable throwable) {
                        thread2 = null;
                    }
                    moduleExp.body = null;
                    moduleExp.thisVariable = null;
                    if (!(outPort != null ? sourceMessages.checkErrors(outPort, 20) : sourceMessages.seenErrors())) break block32;
                    var11_15 = null;
                    if (environment == environment2) break block33;
                    Environment.setCurrent(environment2);
                }
                if (compilation != compilation2) {
                    Compilation.setCurrent(compilation2);
                }
                if (thread2 != null) {
                    thread2.setContextClassLoader(classLoader);
                }
                return var11_15;
            }
            clazz = clazz2;
            if (environment == environment2) break block34;
            Environment.setCurrent(environment2);
        }
        if (compilation != compilation2) {
            Compilation.setCurrent(compilation2);
        }
        if (thread2 != null) {
            thread2.setContextClassLoader(classLoader);
        }
        return clazz;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final void evalModule2(Environment environment, CallContext callContext, Language language, ModuleExp moduleExp, Object object2, OutPort outPort) throws Throwable {
        Environment environment2 = Environment.getCurrent();
        ClassLoader classLoader = null;
        Thread thread2 = null;
        try {
            if (environment != environment2) {
                Environment.setCurrent(environment);
            }
            if (object2 == Boolean.TRUE) {
                moduleExp.body.apply(callContext);
            } else {
                Object object3;
                if (object2 instanceof Class) {
                    object3 = (Class)object2;
                    try {
                        object2 = ((Class)object3).getDeclaredField("$instance").get(null);
                    }
                    catch (NoSuchFieldException noSuchFieldException) {
                        object2 = ((Class)object3).newInstance();
                    }
                    catch (ExceptionInInitializerError exceptionInInitializerError) {
                        throw exceptionInInitializerError.getCause();
                    }
                }
                if (object2 instanceof ModuleBody) {
                    ((ModuleBody)object2).run(callContext);
                }
                for (object3 = moduleExp.firstDecl(); object3 != null; object3 = ((Declaration)object3).nextDecl()) {
                    Object object4;
                    Object object5 = ((Declaration)object3).getSymbol();
                    if (((Declaration)object3).isPrivate() || object5 == null) continue;
                    Field field = ((Declaration)object3).field;
                    Symbol symbol = object5 instanceof Symbol ? (Symbol)object5 : Symbol.make("", object5.toString().intern());
                    Object object6 = language.getEnvPropertyFor((Declaration)object3);
                    Expression expression = ((Declaration)object3).getValue();
                    if (!((((Declaration)object3).field.getModifiers() & 0x10) == 0 || expression instanceof ReferenceExp && ((ReferenceExp)expression).getBinding().needsContext())) {
                        if (expression instanceof QuoteExp && expression != QuoteExp.undefined_exp) {
                            object4 = ((QuoteExp)expression).getValue();
                        } else {
                            object4 = ((Declaration)object3).field.getReflectField().get(null);
                            if (!((Declaration)object3).isIndirectBinding()) {
                                ((Declaration)object3).setValue(QuoteExp.getInstance(object4));
                            } else if (!((Declaration)object3).isAlias() || !(expression instanceof ReferenceExp)) {
                                ((Declaration)object3).setValue(null);
                            }
                        }
                        if (((Declaration)object3).isIndirectBinding()) {
                            environment.addLocation(symbol, object6, (Location)object4);
                            continue;
                        }
                        environment.define(symbol, object6, object4);
                        continue;
                    }
                    object4 = new StaticFieldLocation(field.getDeclaringClass(), field.getName());
                    ((FieldLocation)object4).setDeclaration((Declaration)object3);
                    environment.addLocation(symbol, object6, (Location)object4);
                    ((Declaration)object3).setValue(null);
                }
            }
            callContext.runUntilDone();
        }
        finally {
            if (environment != environment2) {
                Environment.setCurrent(environment2);
            }
            if (thread2 != null) {
                thread2.setContextClassLoader(classLoader);
            }
        }
    }

    public String getNamespaceUri() {
        return this.info.uri;
    }

    public final ClassType getSuperType() {
        return this.superType;
    }

    public final void setSuperType(ClassType classType) {
        this.superType = classType;
    }

    public final ClassType[] getInterfaces() {
        return this.interfaces;
    }

    public final void setInterfaces(ClassType[] classTypeArray) {
        this.interfaces = classTypeArray;
    }

    public final boolean isStatic() {
        return this.getFlag(16384) || (Compilation.moduleStatic > 0 || this.getFlag(524288)) && !this.getFlag(65536) && !this.getFlag(32768);
    }

    public boolean staticInitRun() {
        return this.isStatic() && (this.getFlag(131072) || Compilation.moduleStatic == 2);
    }

    public void allocChildClasses(Compilation compilation) {
        this.declareClosureEnv();
        if (!compilation.usingCPStyle()) {
            return;
        }
        this.allocFrame(compilation);
    }

    void allocFields(Compilation compilation) {
        Declaration declaration;
        for (declaration = this.firstDecl(); declaration != null; declaration = declaration.nextDecl()) {
            if (declaration.isSimple() && !declaration.isPublic() || declaration.field != null || !declaration.getFlag(65536) || !declaration.getFlag(6)) continue;
            declaration.makeField(compilation, null);
        }
        for (declaration = this.firstDecl(); declaration != null; declaration = declaration.nextDecl()) {
            if (declaration.field != null) continue;
            Expression expression = declaration.getValue();
            if (declaration.isSimple() && !declaration.isPublic() && !declaration.isNamespaceDecl() && (!declaration.getFlag(16384) || !declaration.getFlag(6)) && !(expression instanceof ClassExp) || declaration.getFlag(65536)) continue;
            if (expression instanceof LambdaExp && !(expression instanceof ModuleExp) && !(expression instanceof ClassExp)) {
                ((LambdaExp)expression).allocFieldFor(compilation);
                continue;
            }
            if (!declaration.getFlag(16384) && !declaration.isAlias() || expression == QuoteExp.undefined_exp) {
                expression = null;
            }
            declaration.makeField(compilation, expression);
        }
    }

    protected Expression walk(ExpWalker expWalker) {
        return expWalker.walkModuleExp(this);
    }

    public void print(OutPort outPort) {
        Declaration declaration;
        outPort.startLogicalBlock("(Module/", ")", 2);
        Object object2 = this.getSymbol();
        if (object2 != null) {
            outPort.print(object2);
            outPort.print('/');
        }
        outPort.print(this.id);
        outPort.print('/');
        outPort.writeSpaceFill();
        outPort.startLogicalBlock("(", false, ")");
        if (declaration != null) {
            outPort.print("Declarations:");
            for (declaration = this.firstDecl(); declaration != null; declaration = declaration.nextDecl()) {
                outPort.writeSpaceFill();
                declaration.printInfo(outPort);
            }
        }
        outPort.endLogicalBlock(")");
        outPort.writeSpaceLinear();
        if (this.body == null) {
            outPort.print("<null body>");
        } else {
            this.body.print(outPort);
        }
        outPort.endLogicalBlock(")");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Declaration firstDecl() {
        ModuleExp moduleExp = this;
        synchronized (moduleExp) {
            if (this.getFlag(262144)) {
                this.info.setupModuleExp();
            }
        }
        return this.decls;
    }

    public ClassType classFor(Compilation compilation) {
        String string;
        Path path;
        if (this.type != null && this.type != Compilation.typeProcedure) {
            return this.type;
        }
        String string2 = this.getFileName();
        String string3 = this.getName();
        String string4 = null;
        Path path2 = null;
        if (string3 != null) {
            string2 = string3;
        } else if (string2 == null) {
            string2 = this.getName();
            if (string2 == null) {
                string2 = "$unnamed_input_file$";
            }
        } else if (this.filename.equals("-") || this.filename.equals("/dev/stdin")) {
            string2 = this.getName();
            if (string2 == null) {
                string2 = "$stdin$";
            }
        } else {
            path2 = Path.valueOf(string2);
            int n = (string2 = path2.getLast()).lastIndexOf(46);
            if (n > 0) {
                string2 = string2.substring(0, n);
            }
        }
        if (this.getName() == null) {
            this.setName(string2);
        }
        string2 = Compilation.mangleNameIfNeeded(string2);
        if (compilation.classPrefix.length() == 0 && path2 != null && !path2.isAbsolute() && (path = path2.getParent()) != null && (string = path.toString()).length() > 0 && string.indexOf("..") < 0) {
            if ((string = string.replaceAll(System.getProperty("file.separator"), "/")).startsWith("./")) {
                string = string.substring(2);
            }
            string4 = string.equals(".") ? string2 : Compilation.mangleURI(string) + "." + string2;
        } else {
            string4 = compilation.classPrefix + string2;
        }
        ClassType classType = new ClassType(string4);
        this.setType(classType);
        if (compilation.mainLambda == this) {
            if (compilation.mainClass == null) {
                compilation.mainClass = classType;
            } else if (!string4.equals(compilation.mainClass.getName())) {
                compilation.error('e', "inconsistent main class name: " + string4 + " - old name: " + compilation.mainClass.getName());
            }
        }
        return classType;
    }

    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        String string = null;
        if (this.type != null && this.type != Compilation.typeProcedure && !this.type.isExisting()) {
            objectOutput.writeObject(this.type);
        } else {
            if (string == null) {
                string = this.getName();
            }
            if (string == null) {
                string = this.getFileName();
            }
            objectOutput.writeObject(string);
        }
    }

    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        Object object2 = objectInput.readObject();
        if (object2 instanceof ClassType) {
            this.type = (ClassType)object2;
            this.setName(this.type.getName());
        } else {
            this.setName((String)object2);
        }
        this.flags |= 0x40000;
    }

    static {
        alwaysCompile = true;
    }
}

