/*
 * Decompiled with CFR 0.152.
 */
package gnu.expr;

import gnu.bytecode.ObjectType;
import gnu.bytecode.Type;
import gnu.expr.ApplyExp;
import gnu.expr.CanInline;
import gnu.expr.Compilation;
import gnu.expr.Declaration;
import gnu.expr.ExpWalker;
import gnu.expr.Expression;
import gnu.expr.IgnoreTarget;
import gnu.expr.InlineCalls;
import gnu.expr.Inlineable;
import gnu.expr.Language;
import gnu.expr.PrimProcedure;
import gnu.expr.ReferenceExp;
import gnu.expr.Special;
import gnu.expr.StackTarget;
import gnu.expr.Target;
import gnu.kawa.util.IdentityHashTable;
import gnu.lists.AbstractFormat;
import gnu.mapping.CallContext;
import gnu.mapping.OutPort;
import gnu.mapping.Procedure;
import gnu.mapping.Values;
import gnu.mapping.WrongArguments;
import gnu.text.SourceLocator;

public class QuoteExp
extends Expression {
    Object value;
    protected Type type;
    public static QuoteExp undefined_exp = new QuoteExp(Special.undefined);
    public static QuoteExp abstractExp = new QuoteExp(Special.abstractSpecial);
    public static QuoteExp voidExp = new QuoteExp(Values.empty, Type.voidType);
    public static QuoteExp trueExp = new QuoteExp(Boolean.TRUE);
    public static QuoteExp falseExp = new QuoteExp(Boolean.FALSE);
    public static QuoteExp nullExp = new QuoteExp(null, Type.nullType);
    public static final QuoteExp classObjectExp = new QuoteExp(Type.pointer_type);

    public final Object getValue() {
        return this.value;
    }

    public final Object valueIfConstant() {
        return this.value;
    }

    public final Type getType() {
        if (this.type != null) {
            return this.type;
        }
        if (this.value == Values.empty) {
            return Type.voidType;
        }
        if (this.value == null) {
            return Type.nullType;
        }
        if (this == undefined_exp) {
            return Type.pointer_type;
        }
        return Type.make(this.value.getClass());
    }

    public static QuoteExp getInstance(Object object2) {
        if (object2 == null) {
            return nullExp;
        }
        if (object2 == Type.pointer_type) {
            return classObjectExp;
        }
        if (object2 == Special.undefined) {
            return undefined_exp;
        }
        if (object2 == Values.empty) {
            return voidExp;
        }
        if (object2 instanceof Boolean) {
            return (Boolean)object2 != false ? trueExp : falseExp;
        }
        return new QuoteExp(object2);
    }

    public QuoteExp(Object object2) {
        this.value = object2;
    }

    public QuoteExp(Object object2, Type type) {
        this.value = object2;
        this.type = type;
    }

    protected boolean mustCompile() {
        return false;
    }

    public void apply(CallContext callContext) {
        callContext.writeValue(this.value);
    }

    public void compile(Compilation compilation, Target target) {
        if (this.type == null || this.type == Type.pointer_type || target instanceof IgnoreTarget || this.type instanceof ObjectType && this.type.isInstance(this.value)) {
            compilation.compileConstant(this.value, target);
        } else {
            compilation.compileConstant(this.value, StackTarget.getInstance(this.type));
            target.compileFromStack(compilation, this.type);
        }
    }

    public Expression deepCopy(IdentityHashTable identityHashTable) {
        return this;
    }

    protected Expression walk(ExpWalker expWalker) {
        return expWalker.walkQuoteExp(this);
    }

    public Expression inline(ApplyExp applyExp, InlineCalls inlineCalls, Declaration declaration, boolean bl) {
        SourceLocator sourceLocator;
        if (this == undefined_exp) {
            return applyExp;
        }
        Object object2 = this.getValue();
        if (!(object2 instanceof Procedure)) {
            return inlineCalls.noteError(declaration == null || object2 == null ? "called value is not a procedure" : "calling " + declaration.getName() + " which is a " + object2.getClass().getName());
        }
        Procedure procedure = (Procedure)object2;
        int n = applyExp.getArgCount();
        String string = WrongArguments.checkArgCount(procedure, n);
        if (string != null) {
            return inlineCalls.noteError(string);
        }
        if (procedure instanceof CanInline) {
            return ((CanInline)((Object)procedure)).inline(applyExp, inlineCalls, bl);
        }
        if (!bl) {
            applyExp.args = inlineCalls.walkExps(applyExp.args, applyExp.args.length);
        }
        if (applyExp.getFlag(2) && (sourceLocator = applyExp.inlineIfConstant(procedure, inlineCalls)) != applyExp) {
            return inlineCalls.walk((Expression)sourceLocator);
        }
        sourceLocator = inlineCalls.getCompilation();
        if (((Compilation)sourceLocator).inlineOk(procedure)) {
            if (procedure instanceof Inlineable) {
                if (applyExp.getFunction() == this) {
                    return applyExp;
                }
                return new ApplyExp(this, applyExp.getArgs()).setLine(applyExp);
            }
            PrimProcedure primProcedure = PrimProcedure.getMethodFor(procedure, declaration, applyExp.args, ((Compilation)sourceLocator).getLanguage());
            if (primProcedure != null) {
                ApplyExp applyExp2;
                if (primProcedure.getStaticFlag() || declaration == null) {
                    applyExp2 = new ApplyExp(primProcedure, applyExp.args);
                } else {
                    if (declaration.base == null) {
                        return applyExp;
                    }
                    Expression[] expressionArray = new Expression[1 + n];
                    System.arraycopy(applyExp.getArgs(), 0, expressionArray, 1, n);
                    expressionArray[0] = new ReferenceExp(declaration.base);
                    applyExp2 = new ApplyExp(primProcedure, expressionArray);
                }
                return applyExp2.setLine(applyExp);
            }
        }
        return applyExp;
    }

    public boolean side_effects() {
        return false;
    }

    public String toString() {
        return "QuoteExp[" + this.value + "]";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void print(OutPort outPort) {
        outPort.startLogicalBlock("(Quote", ")", 2);
        outPort.writeSpaceLinear();
        Object object2 = this.value;
        if (object2 instanceof Expression) {
            object2 = object2.toString();
        }
        AbstractFormat abstractFormat = outPort.objectFormat;
        try {
            outPort.objectFormat = Language.getDefaultLanguage().getFormat(true);
            outPort.print(object2);
        }
        finally {
            outPort.objectFormat = abstractFormat;
        }
        outPort.endLogicalBlock(")");
    }
}

