/*
 * Decompiled with CFR 0.152.
 */
package gnu.kawa.lispexpr;

import gnu.kawa.lispexpr.NamespaceUse;
import gnu.lists.LList;
import gnu.lists.Pair;
import gnu.mapping.Namespace;
import gnu.mapping.Symbol;

public class LispPackage
extends Namespace {
    Namespace exported;
    LList shadowingSymbols = LList.Empty;
    NamespaceUse imported;
    NamespaceUse importing;

    public Symbol lookup(String string, int n, boolean bl) {
        Symbol symbol = this.exported.lookup(string, n, false);
        if (symbol != null) {
            return symbol;
        }
        symbol = this.lookupInternal(string, n);
        if (symbol != null) {
            return symbol;
        }
        NamespaceUse namespaceUse = this.imported;
        while (namespaceUse != null) {
            symbol = this.lookup(string, n, false);
            if (symbol != null) {
                return symbol;
            }
            namespaceUse = namespaceUse.nextImported;
        }
        if (bl) {
            return this.add(new Symbol(this, string), n);
        }
        return null;
    }

    public Symbol lookupPresent(String string, int n, boolean bl) {
        Symbol symbol = this.exported.lookup(string, n, false);
        if (symbol == null) {
            symbol = super.lookup(string, n, bl);
        }
        return symbol;
    }

    public boolean isPresent(String string) {
        return this.lookupPresent(string, string.hashCode(), false) != null;
    }

    public boolean unintern(Symbol symbol) {
        int n;
        String string = symbol.getName();
        if (this.exported.lookup(string, n = string.hashCode(), false) == symbol) {
            this.exported.remove(symbol);
        } else if (super.lookup(string, n, false) == symbol) {
            super.remove(symbol);
        } else {
            return false;
        }
        symbol.setNamespace(null);
        if (this.removeFromShadowingSymbols(symbol)) {
            // empty if block
        }
        return true;
    }

    private void addToShadowingSymbols(Symbol symbol) {
        Object object2 = this.shadowingSymbols;
        while (object2 != LList.Empty) {
            Pair pair = (Pair)object2;
            if (pair.getCar() == symbol) {
                return;
            }
            object2 = pair.getCdr();
        }
        this.shadowingSymbols = new Pair(symbol, this.shadowingSymbols);
    }

    private boolean removeFromShadowingSymbols(Symbol symbol) {
        Pair pair = null;
        Object object2 = this.shadowingSymbols;
        while (object2 != LList.Empty) {
            Pair pair2 = (Pair)object2;
            object2 = pair2.getCdr();
            if (pair2.getCar() == symbol) {
                if (pair == null) {
                    this.shadowingSymbols = (LList)object2;
                } else {
                    pair.setCdr(object2);
                }
                return true;
            }
            pair = pair2;
        }
        return false;
    }

    public void shadow(String string) {
        Symbol symbol = this.lookupPresent(string, string.hashCode(), true);
        this.addToShadowingSymbols(symbol);
    }

    public void shadowingImport(Symbol symbol) {
        String string = symbol.getName();
        int n = string.hashCode();
        Symbol symbol2 = this.lookupPresent(string, string.hashCode(), false);
        if (symbol2 != null && symbol2 != symbol) {
            this.unintern(symbol2);
        }
        this.addToShadowingSymbols(symbol);
    }
}

