/*
 * Decompiled with CFR 0.152.
 */
package org.jline.terminal.impl.jna.win;

import com.sun.jna.Pointer;
import com.sun.jna.ptr.IntByReference;
import java.io.FileDescriptor;
import java.io.FileOutputStream;
import java.io.IOException;
import org.jline.terminal.Size;
import org.jline.terminal.Terminal;
import org.jline.terminal.impl.AbstractWindowsTerminal;
import org.jline.terminal.impl.jna.win.Kernel32;
import org.jline.terminal.impl.jna.win.WindowsAnsiOutputStream;
import org.jline.utils.InfoCmp;
import org.jline.utils.Log;

public class JnaWinSysTerminal
extends AbstractWindowsTerminal {
    private static final Pointer consoleIn = Kernel32.INSTANCE.GetStdHandle(-10);
    private static final Pointer consoleOut = Kernel32.INSTANCE.GetStdHandle(-11);

    public JnaWinSysTerminal(String name, boolean nativeSignals) throws IOException {
        this(name, nativeSignals, Terminal.SignalHandler.SIG_DFL);
    }

    public JnaWinSysTerminal(String name, boolean nativeSignals, Terminal.SignalHandler signalHandler) throws IOException {
        super(new WindowsAnsiOutputStream(new FileOutputStream(FileDescriptor.out), consoleOut), name, nativeSignals, signalHandler);
    }

    @Override
    protected int getConsoleOutputCP() {
        return Kernel32.INSTANCE.GetConsoleOutputCP();
    }

    @Override
    protected int getConsoleMode() {
        IntByReference mode = new IntByReference();
        Kernel32.INSTANCE.GetConsoleMode(consoleIn, mode);
        return mode.getValue();
    }

    @Override
    protected void setConsoleMode(int mode) {
        Kernel32.INSTANCE.SetConsoleMode(consoleIn, mode);
    }

    @Override
    public Size getSize() {
        Kernel32.CONSOLE_SCREEN_BUFFER_INFO info = new Kernel32.CONSOLE_SCREEN_BUFFER_INFO();
        Kernel32.INSTANCE.GetConsoleScreenBufferInfo(consoleOut, info);
        return new Size(info.windowWidth(), info.windowHeight());
    }

    @Override
    protected byte[] readConsoleInput() {
        Kernel32.INPUT_RECORD[] events = null;
        try {
            events = this.doReadConsoleInput();
        }
        catch (IOException e) {
            Log.debug("read Windows terminal input error: ", e);
        }
        if (events == null) {
            return new byte[0];
        }
        StringBuilder sb = new StringBuilder();
        for (Kernel32.INPUT_RECORD event : events) {
            if (event.EventType == 1) {
                boolean isAlt;
                Kernel32.KEY_EVENT_RECORD keyEvent = event.Event.KeyEvent;
                int altState = 3;
                int ctrlState = 12;
                boolean bl = isAlt = (keyEvent.dwControlKeyState & 3) != 0 && (keyEvent.dwControlKeyState & 0xC) == 0;
                if (keyEvent.bKeyDown) {
                    if (keyEvent.uChar.UnicodeChar > '\u0000') {
                        boolean shiftPressed;
                        boolean bl2 = shiftPressed = (keyEvent.dwControlKeyState & 0x10) != 0;
                        if (keyEvent.uChar.UnicodeChar == '\t' && shiftPressed) {
                            sb.append(this.getSequence(InfoCmp.Capability.key_btab));
                            continue;
                        }
                        if (isAlt) {
                            sb.append('\u001b');
                        }
                        sb.append(keyEvent.uChar.UnicodeChar);
                        continue;
                    }
                    String escapeSequence = this.getEscapeSequence(keyEvent.wVirtualKeyCode);
                    if (escapeSequence == null) continue;
                    for (int k = 0; k < keyEvent.wRepeatCount; ++k) {
                        if (isAlt) {
                            sb.append('\u001b');
                        }
                        sb.append(escapeSequence);
                    }
                    continue;
                }
                if (keyEvent.wVirtualKeyCode != 18 || keyEvent.uChar.UnicodeChar <= '\u0000') continue;
                sb.append(keyEvent.uChar.UnicodeChar);
                continue;
            }
            if (event.EventType != 4) continue;
            this.raise(Terminal.Signal.WINCH);
        }
        return sb.toString().getBytes();
    }

    private Kernel32.INPUT_RECORD[] doReadConsoleInput() throws IOException {
        Kernel32.INPUT_RECORD[] ir = new Kernel32.INPUT_RECORD[1];
        IntByReference r = new IntByReference();
        Kernel32.INSTANCE.ReadConsoleInput(consoleIn, ir, ir.length, r);
        for (int i = 0; i < r.getValue(); ++i) {
            switch (ir[i].EventType) {
                case 1: 
                case 4: {
                    return ir;
                }
            }
        }
        return null;
    }
}

