## ----include = FALSE----------------------------------------------------------
knitr::opts_chunk$set(
  collapse = TRUE,
  comment = "#>"
)

## ----setup, eval=FALSE--------------------------------------------------------
# library(SEQTaRget)

## ----eval=FALSE---------------------------------------------------------------
# options <- SEQopts(# tells SEQuential to create kaplan meier curves
#                    km.curves = TRUE,
#                    # tells SEQuential to bootstrap
#                    bootstrap = TRUE,
#                    # tells SEQuential to run bootstraps 5 times
#                    bootstrap.nboot = 5)
# 
# # use example data
# data <- SEQdata
# model <- SEQuential(data, id.col = "ID",
#                           time.col = "time",
#                           eligible.col = "eligible",
#                           treatment.col = "tx_init",
#                           outcome.col = "outcome",
#                           time_varying.cols = c("N", "L", "P"),
#                           fixed.cols = "sex",
#                           method = "ITT",
#                           options = options)
# 
# km_curve(model, plot.type = "risk")        # retrieve risk plot
# survival_data <- km_data(model)            # retrieve survival and risk data

## ----eval=FALSE---------------------------------------------------------------
# options <- SEQopts(km.curves = TRUE,
#                    bootstrap = TRUE,
#                    bootstrap.nboot = 5,
#                    # tells SEQuential to expect LTFU as the censoring column
#                    cense = "LTFU",
#                    # tells SEQuential to treat this column as the
#                    # censoring eligibility column
#                    cense.eligible = "eligible_cense")
# 
# # use example data for LTFU
# data <- SEQdata.LTFU
# model <- SEQuential(data, id.col = "ID",
#                           time.col = "time",
#                           eligible.col = "eligible",
#                           treatment.col = "tx_init",
#                           outcome.col = "outcome",
#                           time_varying.cols = c("N", "L", "P"),
#                           fixed.cols = "sex",
#                           method = "ITT",
#                           options = options)
# 
# km_curve(model, plot.type = "risk")
# survival_data <- km_data(model)

## ----eval=FALSE---------------------------------------------------------------
# options <- SEQopts(km.curves = TRUE,
#                    bootstrap = TRUE,
#                    bootstrap.nboot = 5,
#                    # Using LTFU as our competing event
#                    compevent = "LTFU")
# 
# data <- SEQdata.LTFU
# model <- SEQuential(data, id.col = "ID",
#                           time.col = "time",
#                           eligible.col = "eligible",
#                           treatment.col = "tx_init",
#                           outcome.col = "outcome",
#                           time_varying.cols = c("N", "L", "P"),
#                           fixed.cols = "sex",
#                           method = "ITT",
#                           options = options)
# 
# km_curve(model, plot.type = "risk")
# survival_data <- km_data(model)

## ----eval=FALSE---------------------------------------------------------------
# options <- SEQopts(# km.curves must be set to FALSE to turn on hazard
#                    # ratio creation
#                    km.curves = FALSE,
#                    # set hazard to TRUE for hazard ratio creation
#                    hazard = TRUE,
#                    bootstrap = TRUE,
#                    bootstrap.nboot = 5,
#                    compevent = "LTFU")
# 
# data <- SEQdata.LTFU
# model <- SEQuential(data, id.col = "ID",
#                           time.col = "time",
#                           eligible.col = "eligible",
#                           treatment.col = "tx_init",
#                           outcome.col = "outcome",
#                           time_varying.cols = c("N", "L", "P"),
#                           fixed.cols = "sex",
#                           method = "ITT",
#                           options = options)
# 
# # retrieve hazard ratios
# hazard_ratio(model)

## ----eval=FALSE---------------------------------------------------------------
# options <- SEQopts(km.curves = TRUE,
#                    bootstrap = TRUE,
#                    bootstrap.nboot = 5,
#                    compevent = "LTFU",
#                    # define the subgroup
#                    subgroup = "sex")
# 
# data <- SEQdata.LTFU
# model <- SEQuential(data, id.col = "ID",
#                           time.col = "time",
#                           eligible.col = "eligible",
#                           treatment.col = "tx_init",
#                           outcome.col = "outcome",
#                           time_varying.cols = c("N", "L", "P"),
#                           fixed.cols = "sex",
#                           method = "ITT",
#                           options = options)
# 
# km_curve(model, plot.type = "risk")
# survival_data <- km_data(model)

